/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.api.vendor.df.shipping.v2021_12_28;

import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCache;
import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCacheImpl;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationCredentials;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationSigner;
import com.amazon.SellingPartnerAPIAA.LWAException;
import com.amazon.SellingPartnerAPIAA.RestrictedDataTokenSigner;
import com.google.gson.reflect.TypeToken;
import io.github.bucket4j.Bucket;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Request;
import software.amazon.spapi.ApiCallback;
import software.amazon.spapi.ApiClient;
import software.amazon.spapi.ApiException;
import software.amazon.spapi.ApiResponse;
import software.amazon.spapi.Configuration;
import software.amazon.spapi.Pair;
import software.amazon.spapi.ProgressRequestBody;
import software.amazon.spapi.StringUtil;
import software.amazon.spapi.models.vendor.df.shipping.v2021_12_28.CreateContainerLabelRequest;
import software.amazon.spapi.models.vendor.df.shipping.v2021_12_28.CreateContainerLabelResponse;

public class CreateContainerLabelApi {
    private ApiClient apiClient;
    private Boolean disableRateLimiting;
    private final Configuration config = Configuration.get();
    public final Bucket createContainerLabelBucket = Bucket.builder().addLimit(this.config.getLimit("CreateContainerLabelApi-createContainerLabel")).build();

    public CreateContainerLabelApi(ApiClient apiClient, Boolean disableRateLimiting) {
        this.apiClient = apiClient;
        this.disableRateLimiting = disableRateLimiting;
    }

    private Call createContainerLabelCall(CreateContainerLabelRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        CreateContainerLabelRequest localVarPostBody = body;
        String localVarPath = "/vendor/directFulfillment/shipping/2021-12-28/containerLabel".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/vendor/directFulfillment/shipping/2021-12-28/containerLabel" : "/vendor/directFulfillment/shipping/2021-12-28/containerLabel";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "containerLabel"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call createContainerLabelValidateBeforeCall(CreateContainerLabelRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createContainerLabel(Async)");
        }
        return this.createContainerLabelCall(body, progressRequestListener);
    }

    public CreateContainerLabelResponse createContainerLabel(CreateContainerLabelRequest body, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<CreateContainerLabelResponse> resp = this.createContainerLabelWithHttpInfo(body, restrictedDataToken);
        return resp.getData();
    }

    public CreateContainerLabelResponse createContainerLabel(CreateContainerLabelRequest body) throws ApiException, LWAException {
        ApiResponse<CreateContainerLabelResponse> resp = this.createContainerLabelWithHttpInfo(body, null);
        return resp.getData();
    }

    public ApiResponse<CreateContainerLabelResponse> createContainerLabelWithHttpInfo(CreateContainerLabelRequest body, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.createContainerLabelValidateBeforeCall(body, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "CreateContainerLabelApi-createContainerLabel");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createContainerLabelBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CreateContainerLabelResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("createContainerLabel operation exceeds rate limit");
    }

    public ApiResponse<CreateContainerLabelResponse> createContainerLabelWithHttpInfo(CreateContainerLabelRequest body) throws ApiException, LWAException {
        return this.createContainerLabelWithHttpInfo(body, null);
    }

    public Call createContainerLabelAsync(CreateContainerLabelRequest body, ApiCallback<CreateContainerLabelResponse> callback) throws ApiException, LWAException {
        return this.createContainerLabelAsync(body, callback, null);
    }

    public Call createContainerLabelAsync(CreateContainerLabelRequest body, ApiCallback<CreateContainerLabelResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.createContainerLabelValidateBeforeCall(body, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "CreateContainerLabelApi-createContainerLabel");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createContainerLabelBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CreateContainerLabelResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("createContainerLabel operation exceeds rate limit");
    }

    public static class Builder {
        private LWAAuthorizationCredentials lwaAuthorizationCredentials;
        private String endpoint;
        private LWAAccessTokenCache lwaAccessTokenCache;
        private Boolean disableAccessTokenCache = false;
        private Boolean disableRateLimiting = false;

        public Builder lwaAuthorizationCredentials(LWAAuthorizationCredentials lwaAuthorizationCredentials) {
            this.lwaAuthorizationCredentials = lwaAuthorizationCredentials;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder lwaAccessTokenCache(LWAAccessTokenCache lwaAccessTokenCache) {
            this.lwaAccessTokenCache = lwaAccessTokenCache;
            return this;
        }

        public Builder disableAccessTokenCache() {
            this.disableAccessTokenCache = true;
            return this;
        }

        public Builder disableRateLimiting() {
            this.disableRateLimiting = true;
            return this;
        }

        public CreateContainerLabelApi build() {
            if (this.lwaAuthorizationCredentials == null) {
                throw new RuntimeException("LWAAuthorizationCredentials not set");
            }
            if (StringUtil.isEmpty(this.endpoint)) {
                throw new RuntimeException("Endpoint not set");
            }
            LWAAuthorizationSigner lwaAuthorizationSigner = null;
            if (this.disableAccessTokenCache.booleanValue()) {
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials);
            } else {
                if (this.lwaAccessTokenCache == null) {
                    this.lwaAccessTokenCache = new LWAAccessTokenCacheImpl();
                }
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials, this.lwaAccessTokenCache);
            }
            return new CreateContainerLabelApi(new ApiClient().setLWAAuthorizationSigner(lwaAuthorizationSigner).setBasePath(this.endpoint), this.disableRateLimiting);
        }
    }
}

