/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.api.transfers.v2024_06_01;

import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCache;
import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCacheImpl;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationCredentials;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationSigner;
import com.amazon.SellingPartnerAPIAA.LWAException;
import com.amazon.SellingPartnerAPIAA.RestrictedDataTokenSigner;
import com.google.gson.reflect.TypeToken;
import io.github.bucket4j.Bucket;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import okhttp3.Request;
import software.amazon.spapi.ApiCallback;
import software.amazon.spapi.ApiClient;
import software.amazon.spapi.ApiException;
import software.amazon.spapi.ApiResponse;
import software.amazon.spapi.Configuration;
import software.amazon.spapi.Pair;
import software.amazon.spapi.ProgressRequestBody;
import software.amazon.spapi.StringUtil;
import software.amazon.spapi.models.transfers.v2024_06_01.GetPaymentMethodsResponse;
import software.amazon.spapi.models.transfers.v2024_06_01.InitiatePayoutRequest;
import software.amazon.spapi.models.transfers.v2024_06_01.InitiatePayoutResponse;

public class DefaultApi {
    private ApiClient apiClient;
    private Boolean disableRateLimiting;
    private final Configuration config = Configuration.get();
    public final Bucket getPaymentMethodsBucket = Bucket.builder().addLimit(this.config.getLimit("DefaultApi-getPaymentMethods")).build();
    public final Bucket initiatePayoutBucket = Bucket.builder().addLimit(this.config.getLimit("DefaultApi-initiatePayout")).build();

    public DefaultApi(ApiClient apiClient, Boolean disableRateLimiting) {
        this.apiClient = apiClient;
        this.disableRateLimiting = disableRateLimiting;
    }

    private Call getPaymentMethodsCall(String marketplaceId, List<String> paymentMethodTypes, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/finances/transfers/2024-06-01/paymentMethods".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/finances/transfers/2024-06-01/paymentMethods" : "/finances/transfers/2024-06-01/paymentMethods";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("marketplaceId", marketplaceId));
        }
        if (paymentMethodTypes != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "paymentMethodTypes", paymentMethodTypes));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getPaymentMethodsValidateBeforeCall(String marketplaceId, List<String> paymentMethodTypes, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (marketplaceId == null) {
            throw new ApiException("Missing the required parameter 'marketplaceId' when calling getPaymentMethods(Async)");
        }
        return this.getPaymentMethodsCall(marketplaceId, paymentMethodTypes, progressRequestListener);
    }

    public GetPaymentMethodsResponse getPaymentMethods(String marketplaceId, List<String> paymentMethodTypes, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetPaymentMethodsResponse> resp = this.getPaymentMethodsWithHttpInfo(marketplaceId, paymentMethodTypes, restrictedDataToken);
        return resp.getData();
    }

    public GetPaymentMethodsResponse getPaymentMethods(String marketplaceId, List<String> paymentMethodTypes) throws ApiException, LWAException {
        ApiResponse<GetPaymentMethodsResponse> resp = this.getPaymentMethodsWithHttpInfo(marketplaceId, paymentMethodTypes, null);
        return resp.getData();
    }

    public ApiResponse<GetPaymentMethodsResponse> getPaymentMethodsWithHttpInfo(String marketplaceId, List<String> paymentMethodTypes, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getPaymentMethodsValidateBeforeCall(marketplaceId, paymentMethodTypes, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "DefaultApi-getPaymentMethods");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getPaymentMethodsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetPaymentMethodsResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getPaymentMethods operation exceeds rate limit");
    }

    public ApiResponse<GetPaymentMethodsResponse> getPaymentMethodsWithHttpInfo(String marketplaceId, List<String> paymentMethodTypes) throws ApiException, LWAException {
        return this.getPaymentMethodsWithHttpInfo(marketplaceId, paymentMethodTypes, null);
    }

    public Call getPaymentMethodsAsync(String marketplaceId, List<String> paymentMethodTypes, ApiCallback<GetPaymentMethodsResponse> callback) throws ApiException, LWAException {
        return this.getPaymentMethodsAsync(marketplaceId, paymentMethodTypes, callback, null);
    }

    public Call getPaymentMethodsAsync(String marketplaceId, List<String> paymentMethodTypes, ApiCallback<GetPaymentMethodsResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getPaymentMethodsValidateBeforeCall(marketplaceId, paymentMethodTypes, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "DefaultApi-getPaymentMethods");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getPaymentMethodsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetPaymentMethodsResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getPaymentMethods operation exceeds rate limit");
    }

    private Call initiatePayoutCall(InitiatePayoutRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        InitiatePayoutRequest localVarPostBody = body;
        String localVarPath = "/finances/transfers/2024-06-01/payouts".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/finances/transfers/2024-06-01/payouts" : "/finances/transfers/2024-06-01/payouts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call initiatePayoutValidateBeforeCall(InitiatePayoutRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling initiatePayout(Async)");
        }
        return this.initiatePayoutCall(body, progressRequestListener);
    }

    public InitiatePayoutResponse initiatePayout(InitiatePayoutRequest body, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<InitiatePayoutResponse> resp = this.initiatePayoutWithHttpInfo(body, restrictedDataToken);
        return resp.getData();
    }

    public InitiatePayoutResponse initiatePayout(InitiatePayoutRequest body) throws ApiException, LWAException {
        ApiResponse<InitiatePayoutResponse> resp = this.initiatePayoutWithHttpInfo(body, null);
        return resp.getData();
    }

    public ApiResponse<InitiatePayoutResponse> initiatePayoutWithHttpInfo(InitiatePayoutRequest body, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.initiatePayoutValidateBeforeCall(body, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "DefaultApi-initiatePayout");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.initiatePayoutBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<InitiatePayoutResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("initiatePayout operation exceeds rate limit");
    }

    public ApiResponse<InitiatePayoutResponse> initiatePayoutWithHttpInfo(InitiatePayoutRequest body) throws ApiException, LWAException {
        return this.initiatePayoutWithHttpInfo(body, null);
    }

    public Call initiatePayoutAsync(InitiatePayoutRequest body, ApiCallback<InitiatePayoutResponse> callback) throws ApiException, LWAException {
        return this.initiatePayoutAsync(body, callback, null);
    }

    public Call initiatePayoutAsync(InitiatePayoutRequest body, ApiCallback<InitiatePayoutResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.initiatePayoutValidateBeforeCall(body, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "DefaultApi-initiatePayout");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.initiatePayoutBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<InitiatePayoutResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("initiatePayout operation exceeds rate limit");
    }

    public static class Builder {
        private LWAAuthorizationCredentials lwaAuthorizationCredentials;
        private String endpoint;
        private LWAAccessTokenCache lwaAccessTokenCache;
        private Boolean disableAccessTokenCache = false;
        private Boolean disableRateLimiting = false;

        public Builder lwaAuthorizationCredentials(LWAAuthorizationCredentials lwaAuthorizationCredentials) {
            this.lwaAuthorizationCredentials = lwaAuthorizationCredentials;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder lwaAccessTokenCache(LWAAccessTokenCache lwaAccessTokenCache) {
            this.lwaAccessTokenCache = lwaAccessTokenCache;
            return this;
        }

        public Builder disableAccessTokenCache() {
            this.disableAccessTokenCache = true;
            return this;
        }

        public Builder disableRateLimiting() {
            this.disableRateLimiting = true;
            return this;
        }

        public DefaultApi build() {
            if (this.lwaAuthorizationCredentials == null) {
                throw new RuntimeException("LWAAuthorizationCredentials not set");
            }
            if (StringUtil.isEmpty(this.endpoint)) {
                throw new RuntimeException("Endpoint not set");
            }
            LWAAuthorizationSigner lwaAuthorizationSigner = null;
            if (this.disableAccessTokenCache.booleanValue()) {
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials);
            } else {
                if (this.lwaAccessTokenCache == null) {
                    this.lwaAccessTokenCache = new LWAAccessTokenCacheImpl();
                }
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials, this.lwaAccessTokenCache);
            }
            return new DefaultApi(new ApiClient().setLWAAuthorizationSigner(lwaAuthorizationSigner).setBasePath(this.endpoint), this.disableRateLimiting);
        }
    }
}

