/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.api.sellerwallet.v2024_03_01;

import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCache;
import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCacheImpl;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationCredentials;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationSigner;
import com.amazon.SellingPartnerAPIAA.LWAException;
import com.amazon.SellingPartnerAPIAA.RestrictedDataTokenSigner;
import com.google.gson.reflect.TypeToken;
import io.github.bucket4j.Bucket;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Request;
import software.amazon.spapi.ApiCallback;
import software.amazon.spapi.ApiClient;
import software.amazon.spapi.ApiException;
import software.amazon.spapi.ApiResponse;
import software.amazon.spapi.Configuration;
import software.amazon.spapi.Pair;
import software.amazon.spapi.ProgressRequestBody;
import software.amazon.spapi.StringUtil;
import software.amazon.spapi.models.sellerwallet.v2024_03_01.DeleteTransferSchedule;
import software.amazon.spapi.models.sellerwallet.v2024_03_01.TransferSchedule;
import software.amazon.spapi.models.sellerwallet.v2024_03_01.TransferScheduleListing;
import software.amazon.spapi.models.sellerwallet.v2024_03_01.TransferScheduleRequest;

public class TransferScheduleApi {
    private ApiClient apiClient;
    private Boolean disableRateLimiting;
    private final Configuration config = Configuration.get();
    public final Bucket createTransferScheduleBucket = Bucket.builder().addLimit(this.config.getLimit("TransferScheduleApi-createTransferSchedule")).build();
    public final Bucket deleteScheduleTransactionBucket = Bucket.builder().addLimit(this.config.getLimit("TransferScheduleApi-deleteScheduleTransaction")).build();
    public final Bucket getTransferScheduleBucket = Bucket.builder().addLimit(this.config.getLimit("TransferScheduleApi-getTransferSchedule")).build();
    public final Bucket listTransferSchedulesBucket = Bucket.builder().addLimit(this.config.getLimit("TransferScheduleApi-listTransferSchedules")).build();
    public final Bucket updateTransferScheduleBucket = Bucket.builder().addLimit(this.config.getLimit("TransferScheduleApi-updateTransferSchedule")).build();

    public TransferScheduleApi(ApiClient apiClient, Boolean disableRateLimiting) {
        this.apiClient = apiClient;
        this.disableRateLimiting = disableRateLimiting;
    }

    private Call createTransferScheduleCall(TransferScheduleRequest body, String destAccountDigitalSignature, String amountDigitalSignature, String marketplaceId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        TransferScheduleRequest localVarPostBody = body;
        String localVarPath = "/finances/transfers/wallet/2024-03-01/transferSchedules".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/finances/transfers/wallet/2024-03-01/transferSchedules" : "/finances/transfers/wallet/2024-03-01/transferSchedules";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("marketplaceId", marketplaceId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (destAccountDigitalSignature != null) {
            localVarHeaderParams.put("destAccountDigitalSignature", this.apiClient.parameterToString(destAccountDigitalSignature));
        }
        if (amountDigitalSignature != null) {
            localVarHeaderParams.put("amountDigitalSignature", this.apiClient.parameterToString(amountDigitalSignature));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call createTransferScheduleValidateBeforeCall(TransferScheduleRequest body, String destAccountDigitalSignature, String amountDigitalSignature, String marketplaceId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createTransferSchedule(Async)");
        }
        if (destAccountDigitalSignature == null) {
            throw new ApiException("Missing the required parameter 'destAccountDigitalSignature' when calling createTransferSchedule(Async)");
        }
        if (amountDigitalSignature == null) {
            throw new ApiException("Missing the required parameter 'amountDigitalSignature' when calling createTransferSchedule(Async)");
        }
        if (marketplaceId == null) {
            throw new ApiException("Missing the required parameter 'marketplaceId' when calling createTransferSchedule(Async)");
        }
        return this.createTransferScheduleCall(body, destAccountDigitalSignature, amountDigitalSignature, marketplaceId, progressRequestListener);
    }

    public TransferSchedule createTransferSchedule(TransferScheduleRequest body, String destAccountDigitalSignature, String amountDigitalSignature, String marketplaceId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<TransferSchedule> resp = this.createTransferScheduleWithHttpInfo(body, destAccountDigitalSignature, amountDigitalSignature, marketplaceId, restrictedDataToken);
        return resp.getData();
    }

    public TransferSchedule createTransferSchedule(TransferScheduleRequest body, String destAccountDigitalSignature, String amountDigitalSignature, String marketplaceId) throws ApiException, LWAException {
        ApiResponse<TransferSchedule> resp = this.createTransferScheduleWithHttpInfo(body, destAccountDigitalSignature, amountDigitalSignature, marketplaceId, null);
        return resp.getData();
    }

    public ApiResponse<TransferSchedule> createTransferScheduleWithHttpInfo(TransferScheduleRequest body, String destAccountDigitalSignature, String amountDigitalSignature, String marketplaceId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.createTransferScheduleValidateBeforeCall(body, destAccountDigitalSignature, amountDigitalSignature, marketplaceId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "TransferScheduleApi-createTransferSchedule");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createTransferScheduleBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<TransferSchedule>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("createTransferSchedule operation exceeds rate limit");
    }

    public ApiResponse<TransferSchedule> createTransferScheduleWithHttpInfo(TransferScheduleRequest body, String destAccountDigitalSignature, String amountDigitalSignature, String marketplaceId) throws ApiException, LWAException {
        return this.createTransferScheduleWithHttpInfo(body, destAccountDigitalSignature, amountDigitalSignature, marketplaceId, null);
    }

    public Call createTransferScheduleAsync(TransferScheduleRequest body, String destAccountDigitalSignature, String amountDigitalSignature, String marketplaceId, ApiCallback<TransferSchedule> callback) throws ApiException, LWAException {
        return this.createTransferScheduleAsync(body, destAccountDigitalSignature, amountDigitalSignature, marketplaceId, callback, null);
    }

    public Call createTransferScheduleAsync(TransferScheduleRequest body, String destAccountDigitalSignature, String amountDigitalSignature, String marketplaceId, ApiCallback<TransferSchedule> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.createTransferScheduleValidateBeforeCall(body, destAccountDigitalSignature, amountDigitalSignature, marketplaceId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "TransferScheduleApi-createTransferSchedule");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createTransferScheduleBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<TransferSchedule>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("createTransferSchedule operation exceeds rate limit");
    }

    private Call deleteScheduleTransactionCall(String transferScheduleId, String marketplaceId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/finances/transfers/wallet/2024-03-01/transferSchedules/{transferScheduleId}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/finances/transfers/wallet/2024-03-01/transferSchedules/{transferScheduleId}".replaceAll("\\{transferScheduleId\\}", transferScheduleId.toString()) : "/finances/transfers/wallet/2024-03-01/transferSchedules/{transferScheduleId}".replaceAll("\\{transferScheduleId\\}", this.apiClient.escapeString(transferScheduleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("marketplaceId", marketplaceId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call deleteScheduleTransactionValidateBeforeCall(String transferScheduleId, String marketplaceId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (transferScheduleId == null) {
            throw new ApiException("Missing the required parameter 'transferScheduleId' when calling deleteScheduleTransaction(Async)");
        }
        if (marketplaceId == null) {
            throw new ApiException("Missing the required parameter 'marketplaceId' when calling deleteScheduleTransaction(Async)");
        }
        return this.deleteScheduleTransactionCall(transferScheduleId, marketplaceId, progressRequestListener);
    }

    public DeleteTransferSchedule deleteScheduleTransaction(String transferScheduleId, String marketplaceId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<DeleteTransferSchedule> resp = this.deleteScheduleTransactionWithHttpInfo(transferScheduleId, marketplaceId, restrictedDataToken);
        return resp.getData();
    }

    public DeleteTransferSchedule deleteScheduleTransaction(String transferScheduleId, String marketplaceId) throws ApiException, LWAException {
        ApiResponse<DeleteTransferSchedule> resp = this.deleteScheduleTransactionWithHttpInfo(transferScheduleId, marketplaceId, null);
        return resp.getData();
    }

    public ApiResponse<DeleteTransferSchedule> deleteScheduleTransactionWithHttpInfo(String transferScheduleId, String marketplaceId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.deleteScheduleTransactionValidateBeforeCall(transferScheduleId, marketplaceId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "TransferScheduleApi-deleteScheduleTransaction");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.deleteScheduleTransactionBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<DeleteTransferSchedule>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("deleteScheduleTransaction operation exceeds rate limit");
    }

    public ApiResponse<DeleteTransferSchedule> deleteScheduleTransactionWithHttpInfo(String transferScheduleId, String marketplaceId) throws ApiException, LWAException {
        return this.deleteScheduleTransactionWithHttpInfo(transferScheduleId, marketplaceId, null);
    }

    public Call deleteScheduleTransactionAsync(String transferScheduleId, String marketplaceId, ApiCallback<DeleteTransferSchedule> callback) throws ApiException, LWAException {
        return this.deleteScheduleTransactionAsync(transferScheduleId, marketplaceId, callback, null);
    }

    public Call deleteScheduleTransactionAsync(String transferScheduleId, String marketplaceId, ApiCallback<DeleteTransferSchedule> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.deleteScheduleTransactionValidateBeforeCall(transferScheduleId, marketplaceId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "TransferScheduleApi-deleteScheduleTransaction");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.deleteScheduleTransactionBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<DeleteTransferSchedule>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("deleteScheduleTransaction operation exceeds rate limit");
    }

    private Call getTransferScheduleCall(String transferScheduleId, String marketplaceId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/finances/transfers/wallet/2024-03-01/transferSchedules/{transferScheduleId}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/finances/transfers/wallet/2024-03-01/transferSchedules/{transferScheduleId}".replaceAll("\\{transferScheduleId\\}", transferScheduleId.toString()) : "/finances/transfers/wallet/2024-03-01/transferSchedules/{transferScheduleId}".replaceAll("\\{transferScheduleId\\}", this.apiClient.escapeString(transferScheduleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("marketplaceId", marketplaceId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getTransferScheduleValidateBeforeCall(String transferScheduleId, String marketplaceId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (transferScheduleId == null) {
            throw new ApiException("Missing the required parameter 'transferScheduleId' when calling getTransferSchedule(Async)");
        }
        if (marketplaceId == null) {
            throw new ApiException("Missing the required parameter 'marketplaceId' when calling getTransferSchedule(Async)");
        }
        return this.getTransferScheduleCall(transferScheduleId, marketplaceId, progressRequestListener);
    }

    public TransferSchedule getTransferSchedule(String transferScheduleId, String marketplaceId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<TransferSchedule> resp = this.getTransferScheduleWithHttpInfo(transferScheduleId, marketplaceId, restrictedDataToken);
        return resp.getData();
    }

    public TransferSchedule getTransferSchedule(String transferScheduleId, String marketplaceId) throws ApiException, LWAException {
        ApiResponse<TransferSchedule> resp = this.getTransferScheduleWithHttpInfo(transferScheduleId, marketplaceId, null);
        return resp.getData();
    }

    public ApiResponse<TransferSchedule> getTransferScheduleWithHttpInfo(String transferScheduleId, String marketplaceId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getTransferScheduleValidateBeforeCall(transferScheduleId, marketplaceId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "TransferScheduleApi-getTransferSchedule");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getTransferScheduleBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<TransferSchedule>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getTransferSchedule operation exceeds rate limit");
    }

    public ApiResponse<TransferSchedule> getTransferScheduleWithHttpInfo(String transferScheduleId, String marketplaceId) throws ApiException, LWAException {
        return this.getTransferScheduleWithHttpInfo(transferScheduleId, marketplaceId, null);
    }

    public Call getTransferScheduleAsync(String transferScheduleId, String marketplaceId, ApiCallback<TransferSchedule> callback) throws ApiException, LWAException {
        return this.getTransferScheduleAsync(transferScheduleId, marketplaceId, callback, null);
    }

    public Call getTransferScheduleAsync(String transferScheduleId, String marketplaceId, ApiCallback<TransferSchedule> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getTransferScheduleValidateBeforeCall(transferScheduleId, marketplaceId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "TransferScheduleApi-getTransferSchedule");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getTransferScheduleBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<TransferSchedule>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getTransferSchedule operation exceeds rate limit");
    }

    private Call listTransferSchedulesCall(String accountId, String marketplaceId, String nextPageToken, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/finances/transfers/wallet/2024-03-01/transferSchedules".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/finances/transfers/wallet/2024-03-01/transferSchedules" : "/finances/transfers/wallet/2024-03-01/transferSchedules";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (accountId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("accountId", accountId));
        }
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("marketplaceId", marketplaceId));
        }
        if (nextPageToken != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("nextPageToken", nextPageToken));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call listTransferSchedulesValidateBeforeCall(String accountId, String marketplaceId, String nextPageToken, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling listTransferSchedules(Async)");
        }
        if (marketplaceId == null) {
            throw new ApiException("Missing the required parameter 'marketplaceId' when calling listTransferSchedules(Async)");
        }
        return this.listTransferSchedulesCall(accountId, marketplaceId, nextPageToken, progressRequestListener);
    }

    public TransferScheduleListing listTransferSchedules(String accountId, String marketplaceId, String nextPageToken, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<TransferScheduleListing> resp = this.listTransferSchedulesWithHttpInfo(accountId, marketplaceId, nextPageToken, restrictedDataToken);
        return resp.getData();
    }

    public TransferScheduleListing listTransferSchedules(String accountId, String marketplaceId, String nextPageToken) throws ApiException, LWAException {
        ApiResponse<TransferScheduleListing> resp = this.listTransferSchedulesWithHttpInfo(accountId, marketplaceId, nextPageToken, null);
        return resp.getData();
    }

    public ApiResponse<TransferScheduleListing> listTransferSchedulesWithHttpInfo(String accountId, String marketplaceId, String nextPageToken, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.listTransferSchedulesValidateBeforeCall(accountId, marketplaceId, nextPageToken, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "TransferScheduleApi-listTransferSchedules");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.listTransferSchedulesBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<TransferScheduleListing>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("listTransferSchedules operation exceeds rate limit");
    }

    public ApiResponse<TransferScheduleListing> listTransferSchedulesWithHttpInfo(String accountId, String marketplaceId, String nextPageToken) throws ApiException, LWAException {
        return this.listTransferSchedulesWithHttpInfo(accountId, marketplaceId, nextPageToken, null);
    }

    public Call listTransferSchedulesAsync(String accountId, String marketplaceId, String nextPageToken, ApiCallback<TransferScheduleListing> callback) throws ApiException, LWAException {
        return this.listTransferSchedulesAsync(accountId, marketplaceId, nextPageToken, callback, null);
    }

    public Call listTransferSchedulesAsync(String accountId, String marketplaceId, String nextPageToken, ApiCallback<TransferScheduleListing> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.listTransferSchedulesValidateBeforeCall(accountId, marketplaceId, nextPageToken, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "TransferScheduleApi-listTransferSchedules");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.listTransferSchedulesBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<TransferScheduleListing>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("listTransferSchedules operation exceeds rate limit");
    }

    private Call updateTransferScheduleCall(TransferSchedule body, String destAccountDigitalSignature, String amountDigitalSignature, String marketplaceId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        TransferSchedule localVarPostBody = body;
        String localVarPath = "/finances/transfers/wallet/2024-03-01/transferSchedules".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/finances/transfers/wallet/2024-03-01/transferSchedules" : "/finances/transfers/wallet/2024-03-01/transferSchedules";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("marketplaceId", marketplaceId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (destAccountDigitalSignature != null) {
            localVarHeaderParams.put("destAccountDigitalSignature", this.apiClient.parameterToString(destAccountDigitalSignature));
        }
        if (amountDigitalSignature != null) {
            localVarHeaderParams.put("amountDigitalSignature", this.apiClient.parameterToString(amountDigitalSignature));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call updateTransferScheduleValidateBeforeCall(TransferSchedule body, String destAccountDigitalSignature, String amountDigitalSignature, String marketplaceId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling updateTransferSchedule(Async)");
        }
        if (destAccountDigitalSignature == null) {
            throw new ApiException("Missing the required parameter 'destAccountDigitalSignature' when calling updateTransferSchedule(Async)");
        }
        if (amountDigitalSignature == null) {
            throw new ApiException("Missing the required parameter 'amountDigitalSignature' when calling updateTransferSchedule(Async)");
        }
        if (marketplaceId == null) {
            throw new ApiException("Missing the required parameter 'marketplaceId' when calling updateTransferSchedule(Async)");
        }
        return this.updateTransferScheduleCall(body, destAccountDigitalSignature, amountDigitalSignature, marketplaceId, progressRequestListener);
    }

    public TransferSchedule updateTransferSchedule(TransferSchedule body, String destAccountDigitalSignature, String amountDigitalSignature, String marketplaceId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<TransferSchedule> resp = this.updateTransferScheduleWithHttpInfo(body, destAccountDigitalSignature, amountDigitalSignature, marketplaceId, restrictedDataToken);
        return resp.getData();
    }

    public TransferSchedule updateTransferSchedule(TransferSchedule body, String destAccountDigitalSignature, String amountDigitalSignature, String marketplaceId) throws ApiException, LWAException {
        ApiResponse<TransferSchedule> resp = this.updateTransferScheduleWithHttpInfo(body, destAccountDigitalSignature, amountDigitalSignature, marketplaceId, null);
        return resp.getData();
    }

    public ApiResponse<TransferSchedule> updateTransferScheduleWithHttpInfo(TransferSchedule body, String destAccountDigitalSignature, String amountDigitalSignature, String marketplaceId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.updateTransferScheduleValidateBeforeCall(body, destAccountDigitalSignature, amountDigitalSignature, marketplaceId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "TransferScheduleApi-updateTransferSchedule");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.updateTransferScheduleBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<TransferSchedule>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("updateTransferSchedule operation exceeds rate limit");
    }

    public ApiResponse<TransferSchedule> updateTransferScheduleWithHttpInfo(TransferSchedule body, String destAccountDigitalSignature, String amountDigitalSignature, String marketplaceId) throws ApiException, LWAException {
        return this.updateTransferScheduleWithHttpInfo(body, destAccountDigitalSignature, amountDigitalSignature, marketplaceId, null);
    }

    public Call updateTransferScheduleAsync(TransferSchedule body, String destAccountDigitalSignature, String amountDigitalSignature, String marketplaceId, ApiCallback<TransferSchedule> callback) throws ApiException, LWAException {
        return this.updateTransferScheduleAsync(body, destAccountDigitalSignature, amountDigitalSignature, marketplaceId, callback, null);
    }

    public Call updateTransferScheduleAsync(TransferSchedule body, String destAccountDigitalSignature, String amountDigitalSignature, String marketplaceId, ApiCallback<TransferSchedule> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.updateTransferScheduleValidateBeforeCall(body, destAccountDigitalSignature, amountDigitalSignature, marketplaceId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "TransferScheduleApi-updateTransferSchedule");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.updateTransferScheduleBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<TransferSchedule>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("updateTransferSchedule operation exceeds rate limit");
    }

    public static class Builder {
        private LWAAuthorizationCredentials lwaAuthorizationCredentials;
        private String endpoint;
        private LWAAccessTokenCache lwaAccessTokenCache;
        private Boolean disableAccessTokenCache = false;
        private Boolean disableRateLimiting = false;

        public Builder lwaAuthorizationCredentials(LWAAuthorizationCredentials lwaAuthorizationCredentials) {
            this.lwaAuthorizationCredentials = lwaAuthorizationCredentials;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder lwaAccessTokenCache(LWAAccessTokenCache lwaAccessTokenCache) {
            this.lwaAccessTokenCache = lwaAccessTokenCache;
            return this;
        }

        public Builder disableAccessTokenCache() {
            this.disableAccessTokenCache = true;
            return this;
        }

        public Builder disableRateLimiting() {
            this.disableRateLimiting = true;
            return this;
        }

        public TransferScheduleApi build() {
            if (this.lwaAuthorizationCredentials == null) {
                throw new RuntimeException("LWAAuthorizationCredentials not set");
            }
            if (StringUtil.isEmpty(this.endpoint)) {
                throw new RuntimeException("Endpoint not set");
            }
            LWAAuthorizationSigner lwaAuthorizationSigner = null;
            if (this.disableAccessTokenCache.booleanValue()) {
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials);
            } else {
                if (this.lwaAccessTokenCache == null) {
                    this.lwaAccessTokenCache = new LWAAccessTokenCacheImpl();
                }
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials, this.lwaAccessTokenCache);
            }
            return new TransferScheduleApi(new ApiClient().setLWAAuthorizationSigner(lwaAuthorizationSigner).setBasePath(this.endpoint), this.disableRateLimiting);
        }
    }
}

