/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.api.sellers.v1;

import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCache;
import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCacheImpl;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationCredentials;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationSigner;
import com.amazon.SellingPartnerAPIAA.LWAException;
import com.amazon.SellingPartnerAPIAA.RestrictedDataTokenSigner;
import com.google.gson.reflect.TypeToken;
import io.github.bucket4j.Bucket;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Request;
import software.amazon.spapi.ApiCallback;
import software.amazon.spapi.ApiClient;
import software.amazon.spapi.ApiException;
import software.amazon.spapi.ApiResponse;
import software.amazon.spapi.Configuration;
import software.amazon.spapi.Pair;
import software.amazon.spapi.ProgressRequestBody;
import software.amazon.spapi.StringUtil;
import software.amazon.spapi.models.sellers.v1.GetAccountResponse;
import software.amazon.spapi.models.sellers.v1.GetMarketplaceParticipationsResponse;

public class SellersApi {
    private ApiClient apiClient;
    private Boolean disableRateLimiting;
    private final Configuration config = Configuration.get();
    public final Bucket getAccountBucket = Bucket.builder().addLimit(this.config.getLimit("SellersApi-getAccount")).build();
    public final Bucket getMarketplaceParticipationsBucket = Bucket.builder().addLimit(this.config.getLimit("SellersApi-getMarketplaceParticipations")).build();

    public SellersApi(ApiClient apiClient, Boolean disableRateLimiting) {
        this.apiClient = apiClient;
        this.disableRateLimiting = disableRateLimiting;
    }

    private Call getAccountCall(ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/sellers/v1/account".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/sellers/v1/account" : "/sellers/v1/account";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getAccountValidateBeforeCall(ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        return this.getAccountCall(progressRequestListener);
    }

    public GetAccountResponse getAccount(String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetAccountResponse> resp = this.getAccountWithHttpInfo(restrictedDataToken);
        return resp.getData();
    }

    public GetAccountResponse getAccount() throws ApiException, LWAException {
        ApiResponse<GetAccountResponse> resp = this.getAccountWithHttpInfo(null);
        return resp.getData();
    }

    public ApiResponse<GetAccountResponse> getAccountWithHttpInfo(String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getAccountValidateBeforeCall(null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "SellersApi-getAccount");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getAccountBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetAccountResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getAccount operation exceeds rate limit");
    }

    public ApiResponse<GetAccountResponse> getAccountWithHttpInfo() throws ApiException, LWAException {
        return this.getAccountWithHttpInfo(null);
    }

    public Call getAccountAsync(ApiCallback<GetAccountResponse> callback) throws ApiException, LWAException {
        return this.getAccountAsync(callback, null);
    }

    public Call getAccountAsync(ApiCallback<GetAccountResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getAccountValidateBeforeCall(progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "SellersApi-getAccount");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getAccountBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetAccountResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getAccount operation exceeds rate limit");
    }

    private Call getMarketplaceParticipationsCall(ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/sellers/v1/marketplaceParticipations".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/sellers/v1/marketplaceParticipations" : "/sellers/v1/marketplaceParticipations";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "payload"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getMarketplaceParticipationsValidateBeforeCall(ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        return this.getMarketplaceParticipationsCall(progressRequestListener);
    }

    public GetMarketplaceParticipationsResponse getMarketplaceParticipations(String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetMarketplaceParticipationsResponse> resp = this.getMarketplaceParticipationsWithHttpInfo(restrictedDataToken);
        return resp.getData();
    }

    public GetMarketplaceParticipationsResponse getMarketplaceParticipations() throws ApiException, LWAException {
        ApiResponse<GetMarketplaceParticipationsResponse> resp = this.getMarketplaceParticipationsWithHttpInfo(null);
        return resp.getData();
    }

    public ApiResponse<GetMarketplaceParticipationsResponse> getMarketplaceParticipationsWithHttpInfo(String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getMarketplaceParticipationsValidateBeforeCall(null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "SellersApi-getMarketplaceParticipations");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getMarketplaceParticipationsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetMarketplaceParticipationsResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getMarketplaceParticipations operation exceeds rate limit");
    }

    public ApiResponse<GetMarketplaceParticipationsResponse> getMarketplaceParticipationsWithHttpInfo() throws ApiException, LWAException {
        return this.getMarketplaceParticipationsWithHttpInfo(null);
    }

    public Call getMarketplaceParticipationsAsync(ApiCallback<GetMarketplaceParticipationsResponse> callback) throws ApiException, LWAException {
        return this.getMarketplaceParticipationsAsync(callback, null);
    }

    public Call getMarketplaceParticipationsAsync(ApiCallback<GetMarketplaceParticipationsResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getMarketplaceParticipationsValidateBeforeCall(progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "SellersApi-getMarketplaceParticipations");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getMarketplaceParticipationsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetMarketplaceParticipationsResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getMarketplaceParticipations operation exceeds rate limit");
    }

    public static class Builder {
        private LWAAuthorizationCredentials lwaAuthorizationCredentials;
        private String endpoint;
        private LWAAccessTokenCache lwaAccessTokenCache;
        private Boolean disableAccessTokenCache = false;
        private Boolean disableRateLimiting = false;

        public Builder lwaAuthorizationCredentials(LWAAuthorizationCredentials lwaAuthorizationCredentials) {
            this.lwaAuthorizationCredentials = lwaAuthorizationCredentials;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder lwaAccessTokenCache(LWAAccessTokenCache lwaAccessTokenCache) {
            this.lwaAccessTokenCache = lwaAccessTokenCache;
            return this;
        }

        public Builder disableAccessTokenCache() {
            this.disableAccessTokenCache = true;
            return this;
        }

        public Builder disableRateLimiting() {
            this.disableRateLimiting = true;
            return this;
        }

        public SellersApi build() {
            if (this.lwaAuthorizationCredentials == null) {
                throw new RuntimeException("LWAAuthorizationCredentials not set");
            }
            if (StringUtil.isEmpty(this.endpoint)) {
                throw new RuntimeException("Endpoint not set");
            }
            LWAAuthorizationSigner lwaAuthorizationSigner = null;
            if (this.disableAccessTokenCache.booleanValue()) {
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials);
            } else {
                if (this.lwaAccessTokenCache == null) {
                    this.lwaAccessTokenCache = new LWAAccessTokenCacheImpl();
                }
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials, this.lwaAccessTokenCache);
            }
            return new SellersApi(new ApiClient().setLWAAuthorizationSigner(lwaAuthorizationSigner).setBasePath(this.endpoint), this.disableRateLimiting);
        }
    }
}

