/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.api.producttypedefinitions.v2020_09_01;

import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCache;
import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCacheImpl;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationCredentials;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationSigner;
import com.amazon.SellingPartnerAPIAA.LWAException;
import com.amazon.SellingPartnerAPIAA.RestrictedDataTokenSigner;
import com.google.gson.reflect.TypeToken;
import io.github.bucket4j.Bucket;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import okhttp3.Request;
import software.amazon.spapi.ApiCallback;
import software.amazon.spapi.ApiClient;
import software.amazon.spapi.ApiException;
import software.amazon.spapi.ApiResponse;
import software.amazon.spapi.Configuration;
import software.amazon.spapi.Pair;
import software.amazon.spapi.ProgressRequestBody;
import software.amazon.spapi.StringUtil;
import software.amazon.spapi.models.producttypedefinitions.v2020_09_01.ProductTypeDefinition;
import software.amazon.spapi.models.producttypedefinitions.v2020_09_01.ProductTypeList;

public class DefinitionsApi {
    private ApiClient apiClient;
    private Boolean disableRateLimiting;
    private final Configuration config = Configuration.get();
    public final Bucket getDefinitionsProductTypeBucket = Bucket.builder().addLimit(this.config.getLimit("DefinitionsApi-getDefinitionsProductType")).build();
    public final Bucket searchDefinitionsProductTypesBucket = Bucket.builder().addLimit(this.config.getLimit("DefinitionsApi-searchDefinitionsProductTypes")).build();

    public DefinitionsApi(ApiClient apiClient, Boolean disableRateLimiting) {
        this.apiClient = apiClient;
        this.disableRateLimiting = disableRateLimiting;
    }

    private Call getDefinitionsProductTypeCall(String productType, List<String> marketplaceIds, String sellerId, String productTypeVersion, String requirements, String requirementsEnforced, String locale, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/definitions/2020-09-01/productTypes/{productType}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/definitions/2020-09-01/productTypes/{productType}".replaceAll("\\{productType\\}", productType.toString()) : "/definitions/2020-09-01/productTypes/{productType}".replaceAll("\\{productType\\}", this.apiClient.escapeString(productType.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (sellerId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sellerId", sellerId));
        }
        if (marketplaceIds != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "marketplaceIds", marketplaceIds));
        }
        if (productTypeVersion != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("productTypeVersion", productTypeVersion));
        }
        if (requirements != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("requirements", requirements));
        }
        if (requirementsEnforced != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("requirementsEnforced", requirementsEnforced));
        }
        if (locale != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("locale", locale));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getDefinitionsProductTypeValidateBeforeCall(String productType, List<String> marketplaceIds, String sellerId, String productTypeVersion, String requirements, String requirementsEnforced, String locale, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (productType == null) {
            throw new ApiException("Missing the required parameter 'productType' when calling getDefinitionsProductType(Async)");
        }
        if (marketplaceIds == null) {
            throw new ApiException("Missing the required parameter 'marketplaceIds' when calling getDefinitionsProductType(Async)");
        }
        return this.getDefinitionsProductTypeCall(productType, marketplaceIds, sellerId, productTypeVersion, requirements, requirementsEnforced, locale, progressRequestListener);
    }

    public ProductTypeDefinition getDefinitionsProductType(String productType, List<String> marketplaceIds, String sellerId, String productTypeVersion, String requirements, String requirementsEnforced, String locale, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<ProductTypeDefinition> resp = this.getDefinitionsProductTypeWithHttpInfo(productType, marketplaceIds, sellerId, productTypeVersion, requirements, requirementsEnforced, locale, restrictedDataToken);
        return resp.getData();
    }

    public ProductTypeDefinition getDefinitionsProductType(String productType, List<String> marketplaceIds, String sellerId, String productTypeVersion, String requirements, String requirementsEnforced, String locale) throws ApiException, LWAException {
        ApiResponse<ProductTypeDefinition> resp = this.getDefinitionsProductTypeWithHttpInfo(productType, marketplaceIds, sellerId, productTypeVersion, requirements, requirementsEnforced, locale, null);
        return resp.getData();
    }

    public ApiResponse<ProductTypeDefinition> getDefinitionsProductTypeWithHttpInfo(String productType, List<String> marketplaceIds, String sellerId, String productTypeVersion, String requirements, String requirementsEnforced, String locale, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getDefinitionsProductTypeValidateBeforeCall(productType, marketplaceIds, sellerId, productTypeVersion, requirements, requirementsEnforced, locale, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "DefinitionsApi-getDefinitionsProductType");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getDefinitionsProductTypeBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ProductTypeDefinition>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getDefinitionsProductType operation exceeds rate limit");
    }

    public ApiResponse<ProductTypeDefinition> getDefinitionsProductTypeWithHttpInfo(String productType, List<String> marketplaceIds, String sellerId, String productTypeVersion, String requirements, String requirementsEnforced, String locale) throws ApiException, LWAException {
        return this.getDefinitionsProductTypeWithHttpInfo(productType, marketplaceIds, sellerId, productTypeVersion, requirements, requirementsEnforced, locale, null);
    }

    public Call getDefinitionsProductTypeAsync(String productType, List<String> marketplaceIds, String sellerId, String productTypeVersion, String requirements, String requirementsEnforced, String locale, ApiCallback<ProductTypeDefinition> callback) throws ApiException, LWAException {
        return this.getDefinitionsProductTypeAsync(productType, marketplaceIds, sellerId, productTypeVersion, requirements, requirementsEnforced, locale, callback, null);
    }

    public Call getDefinitionsProductTypeAsync(String productType, List<String> marketplaceIds, String sellerId, String productTypeVersion, String requirements, String requirementsEnforced, String locale, ApiCallback<ProductTypeDefinition> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getDefinitionsProductTypeValidateBeforeCall(productType, marketplaceIds, sellerId, productTypeVersion, requirements, requirementsEnforced, locale, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "DefinitionsApi-getDefinitionsProductType");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getDefinitionsProductTypeBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ProductTypeDefinition>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getDefinitionsProductType operation exceeds rate limit");
    }

    private Call searchDefinitionsProductTypesCall(List<String> marketplaceIds, List<String> keywords, String itemName, String locale, String searchLocale, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/definitions/2020-09-01/productTypes".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/definitions/2020-09-01/productTypes" : "/definitions/2020-09-01/productTypes";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (keywords != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "keywords", keywords));
        }
        if (marketplaceIds != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "marketplaceIds", marketplaceIds));
        }
        if (itemName != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("itemName", itemName));
        }
        if (locale != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("locale", locale));
        }
        if (searchLocale != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("searchLocale", searchLocale));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call searchDefinitionsProductTypesValidateBeforeCall(List<String> marketplaceIds, List<String> keywords, String itemName, String locale, String searchLocale, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (marketplaceIds == null) {
            throw new ApiException("Missing the required parameter 'marketplaceIds' when calling searchDefinitionsProductTypes(Async)");
        }
        return this.searchDefinitionsProductTypesCall(marketplaceIds, keywords, itemName, locale, searchLocale, progressRequestListener);
    }

    public ProductTypeList searchDefinitionsProductTypes(List<String> marketplaceIds, List<String> keywords, String itemName, String locale, String searchLocale, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<ProductTypeList> resp = this.searchDefinitionsProductTypesWithHttpInfo(marketplaceIds, keywords, itemName, locale, searchLocale, restrictedDataToken);
        return resp.getData();
    }

    public ProductTypeList searchDefinitionsProductTypes(List<String> marketplaceIds, List<String> keywords, String itemName, String locale, String searchLocale) throws ApiException, LWAException {
        ApiResponse<ProductTypeList> resp = this.searchDefinitionsProductTypesWithHttpInfo(marketplaceIds, keywords, itemName, locale, searchLocale, null);
        return resp.getData();
    }

    public ApiResponse<ProductTypeList> searchDefinitionsProductTypesWithHttpInfo(List<String> marketplaceIds, List<String> keywords, String itemName, String locale, String searchLocale, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.searchDefinitionsProductTypesValidateBeforeCall(marketplaceIds, keywords, itemName, locale, searchLocale, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "DefinitionsApi-searchDefinitionsProductTypes");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.searchDefinitionsProductTypesBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ProductTypeList>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("searchDefinitionsProductTypes operation exceeds rate limit");
    }

    public ApiResponse<ProductTypeList> searchDefinitionsProductTypesWithHttpInfo(List<String> marketplaceIds, List<String> keywords, String itemName, String locale, String searchLocale) throws ApiException, LWAException {
        return this.searchDefinitionsProductTypesWithHttpInfo(marketplaceIds, keywords, itemName, locale, searchLocale, null);
    }

    public Call searchDefinitionsProductTypesAsync(List<String> marketplaceIds, List<String> keywords, String itemName, String locale, String searchLocale, ApiCallback<ProductTypeList> callback) throws ApiException, LWAException {
        return this.searchDefinitionsProductTypesAsync(marketplaceIds, keywords, itemName, locale, searchLocale, callback, null);
    }

    public Call searchDefinitionsProductTypesAsync(List<String> marketplaceIds, List<String> keywords, String itemName, String locale, String searchLocale, ApiCallback<ProductTypeList> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.searchDefinitionsProductTypesValidateBeforeCall(marketplaceIds, keywords, itemName, locale, searchLocale, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "DefinitionsApi-searchDefinitionsProductTypes");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.searchDefinitionsProductTypesBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ProductTypeList>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("searchDefinitionsProductTypes operation exceeds rate limit");
    }

    public static class Builder {
        private LWAAuthorizationCredentials lwaAuthorizationCredentials;
        private String endpoint;
        private LWAAccessTokenCache lwaAccessTokenCache;
        private Boolean disableAccessTokenCache = false;
        private Boolean disableRateLimiting = false;

        public Builder lwaAuthorizationCredentials(LWAAuthorizationCredentials lwaAuthorizationCredentials) {
            this.lwaAuthorizationCredentials = lwaAuthorizationCredentials;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder lwaAccessTokenCache(LWAAccessTokenCache lwaAccessTokenCache) {
            this.lwaAccessTokenCache = lwaAccessTokenCache;
            return this;
        }

        public Builder disableAccessTokenCache() {
            this.disableAccessTokenCache = true;
            return this;
        }

        public Builder disableRateLimiting() {
            this.disableRateLimiting = true;
            return this;
        }

        public DefinitionsApi build() {
            if (this.lwaAuthorizationCredentials == null) {
                throw new RuntimeException("LWAAuthorizationCredentials not set");
            }
            if (StringUtil.isEmpty(this.endpoint)) {
                throw new RuntimeException("Endpoint not set");
            }
            LWAAuthorizationSigner lwaAuthorizationSigner = null;
            if (this.disableAccessTokenCache.booleanValue()) {
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials);
            } else {
                if (this.lwaAccessTokenCache == null) {
                    this.lwaAccessTokenCache = new LWAAccessTokenCacheImpl();
                }
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials, this.lwaAccessTokenCache);
            }
            return new DefinitionsApi(new ApiClient().setLWAAuthorizationSigner(lwaAuthorizationSigner).setBasePath(this.endpoint), this.disableRateLimiting);
        }
    }
}

