/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.api.productfees.v0;

import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCache;
import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCacheImpl;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationCredentials;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationSigner;
import com.amazon.SellingPartnerAPIAA.LWAException;
import com.amazon.SellingPartnerAPIAA.RestrictedDataTokenSigner;
import com.google.gson.reflect.TypeToken;
import io.github.bucket4j.Bucket;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import okhttp3.Request;
import software.amazon.spapi.ApiCallback;
import software.amazon.spapi.ApiClient;
import software.amazon.spapi.ApiException;
import software.amazon.spapi.ApiResponse;
import software.amazon.spapi.Configuration;
import software.amazon.spapi.Pair;
import software.amazon.spapi.ProgressRequestBody;
import software.amazon.spapi.StringUtil;
import software.amazon.spapi.models.productfees.v0.FeesEstimateByIdRequest;
import software.amazon.spapi.models.productfees.v0.GetMyFeesEstimateRequest;
import software.amazon.spapi.models.productfees.v0.GetMyFeesEstimateResponse;
import software.amazon.spapi.models.productfees.v0.GetMyFeesEstimatesResponse;

public class FeesApi {
    private ApiClient apiClient;
    private Boolean disableRateLimiting;
    private final Configuration config = Configuration.get();
    public final Bucket getMyFeesEstimateForASINBucket = Bucket.builder().addLimit(this.config.getLimit("FeesApi-getMyFeesEstimateForASIN")).build();
    public final Bucket getMyFeesEstimateForSKUBucket = Bucket.builder().addLimit(this.config.getLimit("FeesApi-getMyFeesEstimateForSKU")).build();
    public final Bucket getMyFeesEstimatesBucket = Bucket.builder().addLimit(this.config.getLimit("FeesApi-getMyFeesEstimates")).build();

    public FeesApi(ApiClient apiClient, Boolean disableRateLimiting) {
        this.apiClient = apiClient;
        this.disableRateLimiting = disableRateLimiting;
    }

    private Call getMyFeesEstimateForASINCall(GetMyFeesEstimateRequest body, String asin, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        GetMyFeesEstimateRequest localVarPostBody = body;
        String localVarPath = "/products/fees/v0/items/{Asin}/feesEstimate".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/products/fees/v0/items/{Asin}/feesEstimate".replaceAll("\\{Asin\\}", asin.toString()) : "/products/fees/v0/items/{Asin}/feesEstimate".replaceAll("\\{Asin\\}", this.apiClient.escapeString(asin.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getMyFeesEstimateForASINValidateBeforeCall(GetMyFeesEstimateRequest body, String asin, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling getMyFeesEstimateForASIN(Async)");
        }
        if (asin == null) {
            throw new ApiException("Missing the required parameter 'asin' when calling getMyFeesEstimateForASIN(Async)");
        }
        return this.getMyFeesEstimateForASINCall(body, asin, progressRequestListener);
    }

    public GetMyFeesEstimateResponse getMyFeesEstimateForASIN(GetMyFeesEstimateRequest body, String asin, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetMyFeesEstimateResponse> resp = this.getMyFeesEstimateForASINWithHttpInfo(body, asin, restrictedDataToken);
        return resp.getData();
    }

    public GetMyFeesEstimateResponse getMyFeesEstimateForASIN(GetMyFeesEstimateRequest body, String asin) throws ApiException, LWAException {
        ApiResponse<GetMyFeesEstimateResponse> resp = this.getMyFeesEstimateForASINWithHttpInfo(body, asin, null);
        return resp.getData();
    }

    public ApiResponse<GetMyFeesEstimateResponse> getMyFeesEstimateForASINWithHttpInfo(GetMyFeesEstimateRequest body, String asin, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getMyFeesEstimateForASINValidateBeforeCall(body, asin, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FeesApi-getMyFeesEstimateForASIN");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getMyFeesEstimateForASINBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetMyFeesEstimateResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getMyFeesEstimateForASIN operation exceeds rate limit");
    }

    public ApiResponse<GetMyFeesEstimateResponse> getMyFeesEstimateForASINWithHttpInfo(GetMyFeesEstimateRequest body, String asin) throws ApiException, LWAException {
        return this.getMyFeesEstimateForASINWithHttpInfo(body, asin, null);
    }

    public Call getMyFeesEstimateForASINAsync(GetMyFeesEstimateRequest body, String asin, ApiCallback<GetMyFeesEstimateResponse> callback) throws ApiException, LWAException {
        return this.getMyFeesEstimateForASINAsync(body, asin, callback, null);
    }

    public Call getMyFeesEstimateForASINAsync(GetMyFeesEstimateRequest body, String asin, ApiCallback<GetMyFeesEstimateResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getMyFeesEstimateForASINValidateBeforeCall(body, asin, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FeesApi-getMyFeesEstimateForASIN");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getMyFeesEstimateForASINBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetMyFeesEstimateResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getMyFeesEstimateForASIN operation exceeds rate limit");
    }

    private Call getMyFeesEstimateForSKUCall(GetMyFeesEstimateRequest body, String sellerSKU, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        GetMyFeesEstimateRequest localVarPostBody = body;
        String localVarPath = "/products/fees/v0/listings/{SellerSKU}/feesEstimate".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/products/fees/v0/listings/{SellerSKU}/feesEstimate".replaceAll("\\{SellerSKU\\}", sellerSKU.toString()) : "/products/fees/v0/listings/{SellerSKU}/feesEstimate".replaceAll("\\{SellerSKU\\}", this.apiClient.escapeString(sellerSKU.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getMyFeesEstimateForSKUValidateBeforeCall(GetMyFeesEstimateRequest body, String sellerSKU, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling getMyFeesEstimateForSKU(Async)");
        }
        if (sellerSKU == null) {
            throw new ApiException("Missing the required parameter 'sellerSKU' when calling getMyFeesEstimateForSKU(Async)");
        }
        return this.getMyFeesEstimateForSKUCall(body, sellerSKU, progressRequestListener);
    }

    public GetMyFeesEstimateResponse getMyFeesEstimateForSKU(GetMyFeesEstimateRequest body, String sellerSKU, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetMyFeesEstimateResponse> resp = this.getMyFeesEstimateForSKUWithHttpInfo(body, sellerSKU, restrictedDataToken);
        return resp.getData();
    }

    public GetMyFeesEstimateResponse getMyFeesEstimateForSKU(GetMyFeesEstimateRequest body, String sellerSKU) throws ApiException, LWAException {
        ApiResponse<GetMyFeesEstimateResponse> resp = this.getMyFeesEstimateForSKUWithHttpInfo(body, sellerSKU, null);
        return resp.getData();
    }

    public ApiResponse<GetMyFeesEstimateResponse> getMyFeesEstimateForSKUWithHttpInfo(GetMyFeesEstimateRequest body, String sellerSKU, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getMyFeesEstimateForSKUValidateBeforeCall(body, sellerSKU, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FeesApi-getMyFeesEstimateForSKU");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getMyFeesEstimateForSKUBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetMyFeesEstimateResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getMyFeesEstimateForSKU operation exceeds rate limit");
    }

    public ApiResponse<GetMyFeesEstimateResponse> getMyFeesEstimateForSKUWithHttpInfo(GetMyFeesEstimateRequest body, String sellerSKU) throws ApiException, LWAException {
        return this.getMyFeesEstimateForSKUWithHttpInfo(body, sellerSKU, null);
    }

    public Call getMyFeesEstimateForSKUAsync(GetMyFeesEstimateRequest body, String sellerSKU, ApiCallback<GetMyFeesEstimateResponse> callback) throws ApiException, LWAException {
        return this.getMyFeesEstimateForSKUAsync(body, sellerSKU, callback, null);
    }

    public Call getMyFeesEstimateForSKUAsync(GetMyFeesEstimateRequest body, String sellerSKU, ApiCallback<GetMyFeesEstimateResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getMyFeesEstimateForSKUValidateBeforeCall(body, sellerSKU, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FeesApi-getMyFeesEstimateForSKU");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getMyFeesEstimateForSKUBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetMyFeesEstimateResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getMyFeesEstimateForSKU operation exceeds rate limit");
    }

    private Call getMyFeesEstimatesCall(List<FeesEstimateByIdRequest> body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        List<FeesEstimateByIdRequest> localVarPostBody = body;
        String localVarPath = "/products/fees/v0/feesEstimate".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/products/fees/v0/feesEstimate" : "/products/fees/v0/feesEstimate";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getMyFeesEstimatesValidateBeforeCall(List<FeesEstimateByIdRequest> body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling getMyFeesEstimates(Async)");
        }
        return this.getMyFeesEstimatesCall(body, progressRequestListener);
    }

    public GetMyFeesEstimatesResponse getMyFeesEstimates(List<FeesEstimateByIdRequest> body, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetMyFeesEstimatesResponse> resp = this.getMyFeesEstimatesWithHttpInfo(body, restrictedDataToken);
        return resp.getData();
    }

    public GetMyFeesEstimatesResponse getMyFeesEstimates(List<FeesEstimateByIdRequest> body) throws ApiException, LWAException {
        ApiResponse<GetMyFeesEstimatesResponse> resp = this.getMyFeesEstimatesWithHttpInfo(body, null);
        return resp.getData();
    }

    public ApiResponse<GetMyFeesEstimatesResponse> getMyFeesEstimatesWithHttpInfo(List<FeesEstimateByIdRequest> body, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getMyFeesEstimatesValidateBeforeCall(body, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FeesApi-getMyFeesEstimates");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getMyFeesEstimatesBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetMyFeesEstimatesResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getMyFeesEstimates operation exceeds rate limit");
    }

    public ApiResponse<GetMyFeesEstimatesResponse> getMyFeesEstimatesWithHttpInfo(List<FeesEstimateByIdRequest> body) throws ApiException, LWAException {
        return this.getMyFeesEstimatesWithHttpInfo(body, null);
    }

    public Call getMyFeesEstimatesAsync(List<FeesEstimateByIdRequest> body, ApiCallback<GetMyFeesEstimatesResponse> callback) throws ApiException, LWAException {
        return this.getMyFeesEstimatesAsync(body, callback, null);
    }

    public Call getMyFeesEstimatesAsync(List<FeesEstimateByIdRequest> body, ApiCallback<GetMyFeesEstimatesResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getMyFeesEstimatesValidateBeforeCall(body, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FeesApi-getMyFeesEstimates");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getMyFeesEstimatesBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetMyFeesEstimatesResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getMyFeesEstimates operation exceeds rate limit");
    }

    public static class Builder {
        private LWAAuthorizationCredentials lwaAuthorizationCredentials;
        private String endpoint;
        private LWAAccessTokenCache lwaAccessTokenCache;
        private Boolean disableAccessTokenCache = false;
        private Boolean disableRateLimiting = false;

        public Builder lwaAuthorizationCredentials(LWAAuthorizationCredentials lwaAuthorizationCredentials) {
            this.lwaAuthorizationCredentials = lwaAuthorizationCredentials;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder lwaAccessTokenCache(LWAAccessTokenCache lwaAccessTokenCache) {
            this.lwaAccessTokenCache = lwaAccessTokenCache;
            return this;
        }

        public Builder disableAccessTokenCache() {
            this.disableAccessTokenCache = true;
            return this;
        }

        public Builder disableRateLimiting() {
            this.disableRateLimiting = true;
            return this;
        }

        public FeesApi build() {
            if (this.lwaAuthorizationCredentials == null) {
                throw new RuntimeException("LWAAuthorizationCredentials not set");
            }
            if (StringUtil.isEmpty(this.endpoint)) {
                throw new RuntimeException("Endpoint not set");
            }
            LWAAuthorizationSigner lwaAuthorizationSigner = null;
            if (this.disableAccessTokenCache.booleanValue()) {
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials);
            } else {
                if (this.lwaAccessTokenCache == null) {
                    this.lwaAccessTokenCache = new LWAAccessTokenCacheImpl();
                }
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials, this.lwaAccessTokenCache);
            }
            return new FeesApi(new ApiClient().setLWAAuthorizationSigner(lwaAuthorizationSigner).setBasePath(this.endpoint), this.disableRateLimiting);
        }
    }
}

