/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.api.pricing.v0;

import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCache;
import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCacheImpl;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationCredentials;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationSigner;
import com.amazon.SellingPartnerAPIAA.LWAException;
import com.amazon.SellingPartnerAPIAA.RestrictedDataTokenSigner;
import com.google.gson.reflect.TypeToken;
import io.github.bucket4j.Bucket;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import okhttp3.Request;
import software.amazon.spapi.ApiCallback;
import software.amazon.spapi.ApiClient;
import software.amazon.spapi.ApiException;
import software.amazon.spapi.ApiResponse;
import software.amazon.spapi.Configuration;
import software.amazon.spapi.Pair;
import software.amazon.spapi.ProgressRequestBody;
import software.amazon.spapi.StringUtil;
import software.amazon.spapi.models.pricing.v0.GetItemOffersBatchRequest;
import software.amazon.spapi.models.pricing.v0.GetItemOffersBatchResponse;
import software.amazon.spapi.models.pricing.v0.GetListingOffersBatchRequest;
import software.amazon.spapi.models.pricing.v0.GetListingOffersBatchResponse;
import software.amazon.spapi.models.pricing.v0.GetOffersResponse;
import software.amazon.spapi.models.pricing.v0.GetPricingResponse;

public class ProductPricingApi {
    private ApiClient apiClient;
    private Boolean disableRateLimiting;
    private final Configuration config = Configuration.get();
    public final Bucket getCompetitivePricingBucket = Bucket.builder().addLimit(this.config.getLimit("ProductPricingApi-getCompetitivePricing")).build();
    public final Bucket getItemOffersBucket = Bucket.builder().addLimit(this.config.getLimit("ProductPricingApi-getItemOffers")).build();
    public final Bucket getItemOffersBatchBucket = Bucket.builder().addLimit(this.config.getLimit("ProductPricingApi-getItemOffersBatch")).build();
    public final Bucket getListingOffersBucket = Bucket.builder().addLimit(this.config.getLimit("ProductPricingApi-getListingOffers")).build();
    public final Bucket getListingOffersBatchBucket = Bucket.builder().addLimit(this.config.getLimit("ProductPricingApi-getListingOffersBatch")).build();
    public final Bucket getPricingBucket = Bucket.builder().addLimit(this.config.getLimit("ProductPricingApi-getPricing")).build();

    public ProductPricingApi(ApiClient apiClient, Boolean disableRateLimiting) {
        this.apiClient = apiClient;
        this.disableRateLimiting = disableRateLimiting;
    }

    private Call getCompetitivePricingCall(String marketplaceId, String itemType, List<String> asins, List<String> skus, String customerType, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/products/pricing/v0/competitivePrice".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/products/pricing/v0/competitivePrice" : "/products/pricing/v0/competitivePrice";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("MarketplaceId", marketplaceId));
        }
        if (asins != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "Asins", asins));
        }
        if (skus != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "Skus", skus));
        }
        if (itemType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("ItemType", itemType));
        }
        if (customerType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("CustomerType", customerType));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getCompetitivePricingValidateBeforeCall(String marketplaceId, String itemType, List<String> asins, List<String> skus, String customerType, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (marketplaceId == null) {
            throw new ApiException("Missing the required parameter 'marketplaceId' when calling getCompetitivePricing(Async)");
        }
        if (itemType == null) {
            throw new ApiException("Missing the required parameter 'itemType' when calling getCompetitivePricing(Async)");
        }
        return this.getCompetitivePricingCall(marketplaceId, itemType, asins, skus, customerType, progressRequestListener);
    }

    public GetPricingResponse getCompetitivePricing(String marketplaceId, String itemType, List<String> asins, List<String> skus, String customerType, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetPricingResponse> resp = this.getCompetitivePricingWithHttpInfo(marketplaceId, itemType, asins, skus, customerType, restrictedDataToken);
        return resp.getData();
    }

    public GetPricingResponse getCompetitivePricing(String marketplaceId, String itemType, List<String> asins, List<String> skus, String customerType) throws ApiException, LWAException {
        ApiResponse<GetPricingResponse> resp = this.getCompetitivePricingWithHttpInfo(marketplaceId, itemType, asins, skus, customerType, null);
        return resp.getData();
    }

    public ApiResponse<GetPricingResponse> getCompetitivePricingWithHttpInfo(String marketplaceId, String itemType, List<String> asins, List<String> skus, String customerType, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getCompetitivePricingValidateBeforeCall(marketplaceId, itemType, asins, skus, customerType, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ProductPricingApi-getCompetitivePricing");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getCompetitivePricingBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetPricingResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getCompetitivePricing operation exceeds rate limit");
    }

    public ApiResponse<GetPricingResponse> getCompetitivePricingWithHttpInfo(String marketplaceId, String itemType, List<String> asins, List<String> skus, String customerType) throws ApiException, LWAException {
        return this.getCompetitivePricingWithHttpInfo(marketplaceId, itemType, asins, skus, customerType, null);
    }

    public Call getCompetitivePricingAsync(String marketplaceId, String itemType, List<String> asins, List<String> skus, String customerType, ApiCallback<GetPricingResponse> callback) throws ApiException, LWAException {
        return this.getCompetitivePricingAsync(marketplaceId, itemType, asins, skus, customerType, callback, null);
    }

    public Call getCompetitivePricingAsync(String marketplaceId, String itemType, List<String> asins, List<String> skus, String customerType, ApiCallback<GetPricingResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getCompetitivePricingValidateBeforeCall(marketplaceId, itemType, asins, skus, customerType, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ProductPricingApi-getCompetitivePricing");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getCompetitivePricingBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetPricingResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getCompetitivePricing operation exceeds rate limit");
    }

    private Call getItemOffersCall(String marketplaceId, String itemCondition, String asin, String customerType, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/products/pricing/v0/items/{Asin}/offers".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/products/pricing/v0/items/{Asin}/offers".replaceAll("\\{Asin\\}", asin.toString()) : "/products/pricing/v0/items/{Asin}/offers".replaceAll("\\{Asin\\}", this.apiClient.escapeString(asin.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("MarketplaceId", marketplaceId));
        }
        if (itemCondition != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("ItemCondition", itemCondition));
        }
        if (customerType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("CustomerType", customerType));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getItemOffersValidateBeforeCall(String marketplaceId, String itemCondition, String asin, String customerType, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (marketplaceId == null) {
            throw new ApiException("Missing the required parameter 'marketplaceId' when calling getItemOffers(Async)");
        }
        if (itemCondition == null) {
            throw new ApiException("Missing the required parameter 'itemCondition' when calling getItemOffers(Async)");
        }
        if (asin == null) {
            throw new ApiException("Missing the required parameter 'asin' when calling getItemOffers(Async)");
        }
        return this.getItemOffersCall(marketplaceId, itemCondition, asin, customerType, progressRequestListener);
    }

    public GetOffersResponse getItemOffers(String marketplaceId, String itemCondition, String asin, String customerType, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetOffersResponse> resp = this.getItemOffersWithHttpInfo(marketplaceId, itemCondition, asin, customerType, restrictedDataToken);
        return resp.getData();
    }

    public GetOffersResponse getItemOffers(String marketplaceId, String itemCondition, String asin, String customerType) throws ApiException, LWAException {
        ApiResponse<GetOffersResponse> resp = this.getItemOffersWithHttpInfo(marketplaceId, itemCondition, asin, customerType, null);
        return resp.getData();
    }

    public ApiResponse<GetOffersResponse> getItemOffersWithHttpInfo(String marketplaceId, String itemCondition, String asin, String customerType, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getItemOffersValidateBeforeCall(marketplaceId, itemCondition, asin, customerType, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ProductPricingApi-getItemOffers");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getItemOffersBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetOffersResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getItemOffers operation exceeds rate limit");
    }

    public ApiResponse<GetOffersResponse> getItemOffersWithHttpInfo(String marketplaceId, String itemCondition, String asin, String customerType) throws ApiException, LWAException {
        return this.getItemOffersWithHttpInfo(marketplaceId, itemCondition, asin, customerType, null);
    }

    public Call getItemOffersAsync(String marketplaceId, String itemCondition, String asin, String customerType, ApiCallback<GetOffersResponse> callback) throws ApiException, LWAException {
        return this.getItemOffersAsync(marketplaceId, itemCondition, asin, customerType, callback, null);
    }

    public Call getItemOffersAsync(String marketplaceId, String itemCondition, String asin, String customerType, ApiCallback<GetOffersResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getItemOffersValidateBeforeCall(marketplaceId, itemCondition, asin, customerType, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ProductPricingApi-getItemOffers");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getItemOffersBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetOffersResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getItemOffers operation exceeds rate limit");
    }

    private Call getItemOffersBatchCall(GetItemOffersBatchRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        GetItemOffersBatchRequest localVarPostBody = body;
        String localVarPath = "/batches/products/pricing/v0/itemOffers".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/batches/products/pricing/v0/itemOffers" : "/batches/products/pricing/v0/itemOffers";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getItemOffersBatchValidateBeforeCall(GetItemOffersBatchRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling getItemOffersBatch(Async)");
        }
        return this.getItemOffersBatchCall(body, progressRequestListener);
    }

    public GetItemOffersBatchResponse getItemOffersBatch(GetItemOffersBatchRequest body, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetItemOffersBatchResponse> resp = this.getItemOffersBatchWithHttpInfo(body, restrictedDataToken);
        return resp.getData();
    }

    public GetItemOffersBatchResponse getItemOffersBatch(GetItemOffersBatchRequest body) throws ApiException, LWAException {
        ApiResponse<GetItemOffersBatchResponse> resp = this.getItemOffersBatchWithHttpInfo(body, null);
        return resp.getData();
    }

    public ApiResponse<GetItemOffersBatchResponse> getItemOffersBatchWithHttpInfo(GetItemOffersBatchRequest body, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getItemOffersBatchValidateBeforeCall(body, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ProductPricingApi-getItemOffersBatch");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getItemOffersBatchBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetItemOffersBatchResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getItemOffersBatch operation exceeds rate limit");
    }

    public ApiResponse<GetItemOffersBatchResponse> getItemOffersBatchWithHttpInfo(GetItemOffersBatchRequest body) throws ApiException, LWAException {
        return this.getItemOffersBatchWithHttpInfo(body, null);
    }

    public Call getItemOffersBatchAsync(GetItemOffersBatchRequest body, ApiCallback<GetItemOffersBatchResponse> callback) throws ApiException, LWAException {
        return this.getItemOffersBatchAsync(body, callback, null);
    }

    public Call getItemOffersBatchAsync(GetItemOffersBatchRequest body, ApiCallback<GetItemOffersBatchResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getItemOffersBatchValidateBeforeCall(body, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ProductPricingApi-getItemOffersBatch");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getItemOffersBatchBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetItemOffersBatchResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getItemOffersBatch operation exceeds rate limit");
    }

    private Call getListingOffersCall(String marketplaceId, String itemCondition, String sellerSKU, String customerType, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/products/pricing/v0/listings/{SellerSKU}/offers".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/products/pricing/v0/listings/{SellerSKU}/offers".replaceAll("\\{SellerSKU\\}", sellerSKU.toString()) : "/products/pricing/v0/listings/{SellerSKU}/offers".replaceAll("\\{SellerSKU\\}", this.apiClient.escapeString(sellerSKU.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("MarketplaceId", marketplaceId));
        }
        if (itemCondition != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("ItemCondition", itemCondition));
        }
        if (customerType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("CustomerType", customerType));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getListingOffersValidateBeforeCall(String marketplaceId, String itemCondition, String sellerSKU, String customerType, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (marketplaceId == null) {
            throw new ApiException("Missing the required parameter 'marketplaceId' when calling getListingOffers(Async)");
        }
        if (itemCondition == null) {
            throw new ApiException("Missing the required parameter 'itemCondition' when calling getListingOffers(Async)");
        }
        if (sellerSKU == null) {
            throw new ApiException("Missing the required parameter 'sellerSKU' when calling getListingOffers(Async)");
        }
        return this.getListingOffersCall(marketplaceId, itemCondition, sellerSKU, customerType, progressRequestListener);
    }

    public GetOffersResponse getListingOffers(String marketplaceId, String itemCondition, String sellerSKU, String customerType, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetOffersResponse> resp = this.getListingOffersWithHttpInfo(marketplaceId, itemCondition, sellerSKU, customerType, restrictedDataToken);
        return resp.getData();
    }

    public GetOffersResponse getListingOffers(String marketplaceId, String itemCondition, String sellerSKU, String customerType) throws ApiException, LWAException {
        ApiResponse<GetOffersResponse> resp = this.getListingOffersWithHttpInfo(marketplaceId, itemCondition, sellerSKU, customerType, null);
        return resp.getData();
    }

    public ApiResponse<GetOffersResponse> getListingOffersWithHttpInfo(String marketplaceId, String itemCondition, String sellerSKU, String customerType, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getListingOffersValidateBeforeCall(marketplaceId, itemCondition, sellerSKU, customerType, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ProductPricingApi-getListingOffers");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getListingOffersBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetOffersResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getListingOffers operation exceeds rate limit");
    }

    public ApiResponse<GetOffersResponse> getListingOffersWithHttpInfo(String marketplaceId, String itemCondition, String sellerSKU, String customerType) throws ApiException, LWAException {
        return this.getListingOffersWithHttpInfo(marketplaceId, itemCondition, sellerSKU, customerType, null);
    }

    public Call getListingOffersAsync(String marketplaceId, String itemCondition, String sellerSKU, String customerType, ApiCallback<GetOffersResponse> callback) throws ApiException, LWAException {
        return this.getListingOffersAsync(marketplaceId, itemCondition, sellerSKU, customerType, callback, null);
    }

    public Call getListingOffersAsync(String marketplaceId, String itemCondition, String sellerSKU, String customerType, ApiCallback<GetOffersResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getListingOffersValidateBeforeCall(marketplaceId, itemCondition, sellerSKU, customerType, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ProductPricingApi-getListingOffers");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getListingOffersBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetOffersResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getListingOffers operation exceeds rate limit");
    }

    private Call getListingOffersBatchCall(GetListingOffersBatchRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        GetListingOffersBatchRequest localVarPostBody = body;
        String localVarPath = "/batches/products/pricing/v0/listingOffers".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/batches/products/pricing/v0/listingOffers" : "/batches/products/pricing/v0/listingOffers";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getListingOffersBatchValidateBeforeCall(GetListingOffersBatchRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling getListingOffersBatch(Async)");
        }
        return this.getListingOffersBatchCall(body, progressRequestListener);
    }

    public GetListingOffersBatchResponse getListingOffersBatch(GetListingOffersBatchRequest body, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetListingOffersBatchResponse> resp = this.getListingOffersBatchWithHttpInfo(body, restrictedDataToken);
        return resp.getData();
    }

    public GetListingOffersBatchResponse getListingOffersBatch(GetListingOffersBatchRequest body) throws ApiException, LWAException {
        ApiResponse<GetListingOffersBatchResponse> resp = this.getListingOffersBatchWithHttpInfo(body, null);
        return resp.getData();
    }

    public ApiResponse<GetListingOffersBatchResponse> getListingOffersBatchWithHttpInfo(GetListingOffersBatchRequest body, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getListingOffersBatchValidateBeforeCall(body, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ProductPricingApi-getListingOffersBatch");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getListingOffersBatchBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetListingOffersBatchResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getListingOffersBatch operation exceeds rate limit");
    }

    public ApiResponse<GetListingOffersBatchResponse> getListingOffersBatchWithHttpInfo(GetListingOffersBatchRequest body) throws ApiException, LWAException {
        return this.getListingOffersBatchWithHttpInfo(body, null);
    }

    public Call getListingOffersBatchAsync(GetListingOffersBatchRequest body, ApiCallback<GetListingOffersBatchResponse> callback) throws ApiException, LWAException {
        return this.getListingOffersBatchAsync(body, callback, null);
    }

    public Call getListingOffersBatchAsync(GetListingOffersBatchRequest body, ApiCallback<GetListingOffersBatchResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getListingOffersBatchValidateBeforeCall(body, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ProductPricingApi-getListingOffersBatch");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getListingOffersBatchBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetListingOffersBatchResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getListingOffersBatch operation exceeds rate limit");
    }

    private Call getPricingCall(String marketplaceId, String itemType, List<String> asins, List<String> skus, String itemCondition, String offerType, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/products/pricing/v0/price".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/products/pricing/v0/price" : "/products/pricing/v0/price";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("MarketplaceId", marketplaceId));
        }
        if (asins != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "Asins", asins));
        }
        if (skus != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "Skus", skus));
        }
        if (itemType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("ItemType", itemType));
        }
        if (itemCondition != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("ItemCondition", itemCondition));
        }
        if (offerType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("OfferType", offerType));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getPricingValidateBeforeCall(String marketplaceId, String itemType, List<String> asins, List<String> skus, String itemCondition, String offerType, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (marketplaceId == null) {
            throw new ApiException("Missing the required parameter 'marketplaceId' when calling getPricing(Async)");
        }
        if (itemType == null) {
            throw new ApiException("Missing the required parameter 'itemType' when calling getPricing(Async)");
        }
        return this.getPricingCall(marketplaceId, itemType, asins, skus, itemCondition, offerType, progressRequestListener);
    }

    public GetPricingResponse getPricing(String marketplaceId, String itemType, List<String> asins, List<String> skus, String itemCondition, String offerType, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetPricingResponse> resp = this.getPricingWithHttpInfo(marketplaceId, itemType, asins, skus, itemCondition, offerType, restrictedDataToken);
        return resp.getData();
    }

    public GetPricingResponse getPricing(String marketplaceId, String itemType, List<String> asins, List<String> skus, String itemCondition, String offerType) throws ApiException, LWAException {
        ApiResponse<GetPricingResponse> resp = this.getPricingWithHttpInfo(marketplaceId, itemType, asins, skus, itemCondition, offerType, null);
        return resp.getData();
    }

    public ApiResponse<GetPricingResponse> getPricingWithHttpInfo(String marketplaceId, String itemType, List<String> asins, List<String> skus, String itemCondition, String offerType, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getPricingValidateBeforeCall(marketplaceId, itemType, asins, skus, itemCondition, offerType, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ProductPricingApi-getPricing");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getPricingBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetPricingResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getPricing operation exceeds rate limit");
    }

    public ApiResponse<GetPricingResponse> getPricingWithHttpInfo(String marketplaceId, String itemType, List<String> asins, List<String> skus, String itemCondition, String offerType) throws ApiException, LWAException {
        return this.getPricingWithHttpInfo(marketplaceId, itemType, asins, skus, itemCondition, offerType, null);
    }

    public Call getPricingAsync(String marketplaceId, String itemType, List<String> asins, List<String> skus, String itemCondition, String offerType, ApiCallback<GetPricingResponse> callback) throws ApiException, LWAException {
        return this.getPricingAsync(marketplaceId, itemType, asins, skus, itemCondition, offerType, callback, null);
    }

    public Call getPricingAsync(String marketplaceId, String itemType, List<String> asins, List<String> skus, String itemCondition, String offerType, ApiCallback<GetPricingResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getPricingValidateBeforeCall(marketplaceId, itemType, asins, skus, itemCondition, offerType, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ProductPricingApi-getPricing");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getPricingBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetPricingResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getPricing operation exceeds rate limit");
    }

    public static class Builder {
        private LWAAuthorizationCredentials lwaAuthorizationCredentials;
        private String endpoint;
        private LWAAccessTokenCache lwaAccessTokenCache;
        private Boolean disableAccessTokenCache = false;
        private Boolean disableRateLimiting = false;

        public Builder lwaAuthorizationCredentials(LWAAuthorizationCredentials lwaAuthorizationCredentials) {
            this.lwaAuthorizationCredentials = lwaAuthorizationCredentials;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder lwaAccessTokenCache(LWAAccessTokenCache lwaAccessTokenCache) {
            this.lwaAccessTokenCache = lwaAccessTokenCache;
            return this;
        }

        public Builder disableAccessTokenCache() {
            this.disableAccessTokenCache = true;
            return this;
        }

        public Builder disableRateLimiting() {
            this.disableRateLimiting = true;
            return this;
        }

        public ProductPricingApi build() {
            if (this.lwaAuthorizationCredentials == null) {
                throw new RuntimeException("LWAAuthorizationCredentials not set");
            }
            if (StringUtil.isEmpty(this.endpoint)) {
                throw new RuntimeException("Endpoint not set");
            }
            LWAAuthorizationSigner lwaAuthorizationSigner = null;
            if (this.disableAccessTokenCache.booleanValue()) {
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials);
            } else {
                if (this.lwaAccessTokenCache == null) {
                    this.lwaAccessTokenCache = new LWAAccessTokenCacheImpl();
                }
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials, this.lwaAccessTokenCache);
            }
            return new ProductPricingApi(new ApiClient().setLWAAuthorizationSigner(lwaAuthorizationSigner).setBasePath(this.endpoint), this.disableRateLimiting);
        }
    }
}

