/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.api.listings.restrictions.v2021_08_01;

import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCache;
import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCacheImpl;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationCredentials;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationSigner;
import com.amazon.SellingPartnerAPIAA.LWAException;
import com.amazon.SellingPartnerAPIAA.RestrictedDataTokenSigner;
import com.google.gson.reflect.TypeToken;
import io.github.bucket4j.Bucket;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import okhttp3.Request;
import software.amazon.spapi.ApiCallback;
import software.amazon.spapi.ApiClient;
import software.amazon.spapi.ApiException;
import software.amazon.spapi.ApiResponse;
import software.amazon.spapi.Configuration;
import software.amazon.spapi.Pair;
import software.amazon.spapi.ProgressRequestBody;
import software.amazon.spapi.StringUtil;
import software.amazon.spapi.models.listings.restrictions.v2021_08_01.RestrictionList;

public class ListingsApi {
    private ApiClient apiClient;
    private Boolean disableRateLimiting;
    private final Configuration config = Configuration.get();
    public final Bucket getListingsRestrictionsBucket = Bucket.builder().addLimit(this.config.getLimit("ListingsApi-getListingsRestrictions")).build();

    public ListingsApi(ApiClient apiClient, Boolean disableRateLimiting) {
        this.apiClient = apiClient;
        this.disableRateLimiting = disableRateLimiting;
    }

    private Call getListingsRestrictionsCall(String asin, String sellerId, List<String> marketplaceIds, String conditionType, String reasonLocale, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/listings/2021-08-01/restrictions".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/listings/2021-08-01/restrictions" : "/listings/2021-08-01/restrictions";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (asin != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("asin", asin));
        }
        if (conditionType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("conditionType", conditionType));
        }
        if (sellerId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sellerId", sellerId));
        }
        if (marketplaceIds != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "marketplaceIds", marketplaceIds));
        }
        if (reasonLocale != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("reasonLocale", reasonLocale));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getListingsRestrictionsValidateBeforeCall(String asin, String sellerId, List<String> marketplaceIds, String conditionType, String reasonLocale, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (asin == null) {
            throw new ApiException("Missing the required parameter 'asin' when calling getListingsRestrictions(Async)");
        }
        if (sellerId == null) {
            throw new ApiException("Missing the required parameter 'sellerId' when calling getListingsRestrictions(Async)");
        }
        if (marketplaceIds == null) {
            throw new ApiException("Missing the required parameter 'marketplaceIds' when calling getListingsRestrictions(Async)");
        }
        return this.getListingsRestrictionsCall(asin, sellerId, marketplaceIds, conditionType, reasonLocale, progressRequestListener);
    }

    public RestrictionList getListingsRestrictions(String asin, String sellerId, List<String> marketplaceIds, String conditionType, String reasonLocale, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<RestrictionList> resp = this.getListingsRestrictionsWithHttpInfo(asin, sellerId, marketplaceIds, conditionType, reasonLocale, restrictedDataToken);
        return resp.getData();
    }

    public RestrictionList getListingsRestrictions(String asin, String sellerId, List<String> marketplaceIds, String conditionType, String reasonLocale) throws ApiException, LWAException {
        ApiResponse<RestrictionList> resp = this.getListingsRestrictionsWithHttpInfo(asin, sellerId, marketplaceIds, conditionType, reasonLocale, null);
        return resp.getData();
    }

    public ApiResponse<RestrictionList> getListingsRestrictionsWithHttpInfo(String asin, String sellerId, List<String> marketplaceIds, String conditionType, String reasonLocale, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getListingsRestrictionsValidateBeforeCall(asin, sellerId, marketplaceIds, conditionType, reasonLocale, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ListingsApi-getListingsRestrictions");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getListingsRestrictionsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<RestrictionList>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getListingsRestrictions operation exceeds rate limit");
    }

    public ApiResponse<RestrictionList> getListingsRestrictionsWithHttpInfo(String asin, String sellerId, List<String> marketplaceIds, String conditionType, String reasonLocale) throws ApiException, LWAException {
        return this.getListingsRestrictionsWithHttpInfo(asin, sellerId, marketplaceIds, conditionType, reasonLocale, null);
    }

    public Call getListingsRestrictionsAsync(String asin, String sellerId, List<String> marketplaceIds, String conditionType, String reasonLocale, ApiCallback<RestrictionList> callback) throws ApiException, LWAException {
        return this.getListingsRestrictionsAsync(asin, sellerId, marketplaceIds, conditionType, reasonLocale, callback, null);
    }

    public Call getListingsRestrictionsAsync(String asin, String sellerId, List<String> marketplaceIds, String conditionType, String reasonLocale, ApiCallback<RestrictionList> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getListingsRestrictionsValidateBeforeCall(asin, sellerId, marketplaceIds, conditionType, reasonLocale, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ListingsApi-getListingsRestrictions");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getListingsRestrictionsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<RestrictionList>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getListingsRestrictions operation exceeds rate limit");
    }

    public static class Builder {
        private LWAAuthorizationCredentials lwaAuthorizationCredentials;
        private String endpoint;
        private LWAAccessTokenCache lwaAccessTokenCache;
        private Boolean disableAccessTokenCache = false;
        private Boolean disableRateLimiting = false;

        public Builder lwaAuthorizationCredentials(LWAAuthorizationCredentials lwaAuthorizationCredentials) {
            this.lwaAuthorizationCredentials = lwaAuthorizationCredentials;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder lwaAccessTokenCache(LWAAccessTokenCache lwaAccessTokenCache) {
            this.lwaAccessTokenCache = lwaAccessTokenCache;
            return this;
        }

        public Builder disableAccessTokenCache() {
            this.disableAccessTokenCache = true;
            return this;
        }

        public Builder disableRateLimiting() {
            this.disableRateLimiting = true;
            return this;
        }

        public ListingsApi build() {
            if (this.lwaAuthorizationCredentials == null) {
                throw new RuntimeException("LWAAuthorizationCredentials not set");
            }
            if (StringUtil.isEmpty(this.endpoint)) {
                throw new RuntimeException("Endpoint not set");
            }
            LWAAuthorizationSigner lwaAuthorizationSigner = null;
            if (this.disableAccessTokenCache.booleanValue()) {
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials);
            } else {
                if (this.lwaAccessTokenCache == null) {
                    this.lwaAccessTokenCache = new LWAAccessTokenCacheImpl();
                }
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials, this.lwaAccessTokenCache);
            }
            return new ListingsApi(new ApiClient().setLWAAuthorizationSigner(lwaAuthorizationSigner).setBasePath(this.endpoint), this.disableRateLimiting);
        }
    }
}

