/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.api.invoicing.v0;

import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCache;
import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCacheImpl;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationCredentials;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationSigner;
import com.amazon.SellingPartnerAPIAA.LWAException;
import com.amazon.SellingPartnerAPIAA.RestrictedDataTokenSigner;
import com.google.gson.reflect.TypeToken;
import io.github.bucket4j.Bucket;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Request;
import software.amazon.spapi.ApiCallback;
import software.amazon.spapi.ApiClient;
import software.amazon.spapi.ApiException;
import software.amazon.spapi.ApiResponse;
import software.amazon.spapi.Configuration;
import software.amazon.spapi.Pair;
import software.amazon.spapi.ProgressRequestBody;
import software.amazon.spapi.StringUtil;
import software.amazon.spapi.models.invoicing.v0.GetInvoiceStatusResponse;
import software.amazon.spapi.models.invoicing.v0.GetShipmentDetailsResponse;
import software.amazon.spapi.models.invoicing.v0.SubmitInvoiceRequest;
import software.amazon.spapi.models.invoicing.v0.SubmitInvoiceResponse;

public class ShipmentInvoiceApi {
    private ApiClient apiClient;
    private Boolean disableRateLimiting;
    private final Configuration config = Configuration.get();
    public final Bucket getInvoiceStatusBucket = Bucket.builder().addLimit(this.config.getLimit("ShipmentInvoiceApi-getInvoiceStatus")).build();
    public final Bucket getShipmentDetailsBucket = Bucket.builder().addLimit(this.config.getLimit("ShipmentInvoiceApi-getShipmentDetails")).build();
    public final Bucket submitInvoiceBucket = Bucket.builder().addLimit(this.config.getLimit("ShipmentInvoiceApi-submitInvoice")).build();

    public ShipmentInvoiceApi(ApiClient apiClient, Boolean disableRateLimiting) {
        this.apiClient = apiClient;
        this.disableRateLimiting = disableRateLimiting;
    }

    private Call getInvoiceStatusCall(String shipmentId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/fba/outbound/brazil/v0/shipments/{shipmentId}/invoice/status".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/fba/outbound/brazil/v0/shipments/{shipmentId}/invoice/status".replaceAll("\\{shipmentId\\}", shipmentId.toString()) : "/fba/outbound/brazil/v0/shipments/{shipmentId}/invoice/status".replaceAll("\\{shipmentId\\}", this.apiClient.escapeString(shipmentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getInvoiceStatusValidateBeforeCall(String shipmentId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (shipmentId == null) {
            throw new ApiException("Missing the required parameter 'shipmentId' when calling getInvoiceStatus(Async)");
        }
        return this.getInvoiceStatusCall(shipmentId, progressRequestListener);
    }

    public GetInvoiceStatusResponse getInvoiceStatus(String shipmentId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetInvoiceStatusResponse> resp = this.getInvoiceStatusWithHttpInfo(shipmentId, restrictedDataToken);
        return resp.getData();
    }

    public GetInvoiceStatusResponse getInvoiceStatus(String shipmentId) throws ApiException, LWAException {
        ApiResponse<GetInvoiceStatusResponse> resp = this.getInvoiceStatusWithHttpInfo(shipmentId, null);
        return resp.getData();
    }

    public ApiResponse<GetInvoiceStatusResponse> getInvoiceStatusWithHttpInfo(String shipmentId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getInvoiceStatusValidateBeforeCall(shipmentId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ShipmentInvoiceApi-getInvoiceStatus");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getInvoiceStatusBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetInvoiceStatusResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getInvoiceStatus operation exceeds rate limit");
    }

    public ApiResponse<GetInvoiceStatusResponse> getInvoiceStatusWithHttpInfo(String shipmentId) throws ApiException, LWAException {
        return this.getInvoiceStatusWithHttpInfo(shipmentId, null);
    }

    public Call getInvoiceStatusAsync(String shipmentId, ApiCallback<GetInvoiceStatusResponse> callback) throws ApiException, LWAException {
        return this.getInvoiceStatusAsync(shipmentId, callback, null);
    }

    public Call getInvoiceStatusAsync(String shipmentId, ApiCallback<GetInvoiceStatusResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getInvoiceStatusValidateBeforeCall(shipmentId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ShipmentInvoiceApi-getInvoiceStatus");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getInvoiceStatusBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetInvoiceStatusResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getInvoiceStatus operation exceeds rate limit");
    }

    private Call getShipmentDetailsCall(String shipmentId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/fba/outbound/brazil/v0/shipments/{shipmentId}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/fba/outbound/brazil/v0/shipments/{shipmentId}".replaceAll("\\{shipmentId\\}", shipmentId.toString()) : "/fba/outbound/brazil/v0/shipments/{shipmentId}".replaceAll("\\{shipmentId\\}", this.apiClient.escapeString(shipmentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getShipmentDetailsValidateBeforeCall(String shipmentId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (shipmentId == null) {
            throw new ApiException("Missing the required parameter 'shipmentId' when calling getShipmentDetails(Async)");
        }
        return this.getShipmentDetailsCall(shipmentId, progressRequestListener);
    }

    public GetShipmentDetailsResponse getShipmentDetails(String shipmentId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetShipmentDetailsResponse> resp = this.getShipmentDetailsWithHttpInfo(shipmentId, restrictedDataToken);
        return resp.getData();
    }

    public GetShipmentDetailsResponse getShipmentDetails(String shipmentId) throws ApiException, LWAException {
        ApiResponse<GetShipmentDetailsResponse> resp = this.getShipmentDetailsWithHttpInfo(shipmentId, null);
        return resp.getData();
    }

    public ApiResponse<GetShipmentDetailsResponse> getShipmentDetailsWithHttpInfo(String shipmentId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getShipmentDetailsValidateBeforeCall(shipmentId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ShipmentInvoiceApi-getShipmentDetails");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getShipmentDetailsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetShipmentDetailsResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getShipmentDetails operation exceeds rate limit");
    }

    public ApiResponse<GetShipmentDetailsResponse> getShipmentDetailsWithHttpInfo(String shipmentId) throws ApiException, LWAException {
        return this.getShipmentDetailsWithHttpInfo(shipmentId, null);
    }

    public Call getShipmentDetailsAsync(String shipmentId, ApiCallback<GetShipmentDetailsResponse> callback) throws ApiException, LWAException {
        return this.getShipmentDetailsAsync(shipmentId, callback, null);
    }

    public Call getShipmentDetailsAsync(String shipmentId, ApiCallback<GetShipmentDetailsResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getShipmentDetailsValidateBeforeCall(shipmentId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ShipmentInvoiceApi-getShipmentDetails");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getShipmentDetailsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetShipmentDetailsResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getShipmentDetails operation exceeds rate limit");
    }

    private Call submitInvoiceCall(SubmitInvoiceRequest body, String shipmentId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        SubmitInvoiceRequest localVarPostBody = body;
        String localVarPath = "/fba/outbound/brazil/v0/shipments/{shipmentId}/invoice".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/fba/outbound/brazil/v0/shipments/{shipmentId}/invoice".replaceAll("\\{shipmentId\\}", shipmentId.toString()) : "/fba/outbound/brazil/v0/shipments/{shipmentId}/invoice".replaceAll("\\{shipmentId\\}", this.apiClient.escapeString(shipmentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call submitInvoiceValidateBeforeCall(SubmitInvoiceRequest body, String shipmentId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling submitInvoice(Async)");
        }
        if (shipmentId == null) {
            throw new ApiException("Missing the required parameter 'shipmentId' when calling submitInvoice(Async)");
        }
        return this.submitInvoiceCall(body, shipmentId, progressRequestListener);
    }

    public SubmitInvoiceResponse submitInvoice(SubmitInvoiceRequest body, String shipmentId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<SubmitInvoiceResponse> resp = this.submitInvoiceWithHttpInfo(body, shipmentId, restrictedDataToken);
        return resp.getData();
    }

    public SubmitInvoiceResponse submitInvoice(SubmitInvoiceRequest body, String shipmentId) throws ApiException, LWAException {
        ApiResponse<SubmitInvoiceResponse> resp = this.submitInvoiceWithHttpInfo(body, shipmentId, null);
        return resp.getData();
    }

    public ApiResponse<SubmitInvoiceResponse> submitInvoiceWithHttpInfo(SubmitInvoiceRequest body, String shipmentId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.submitInvoiceValidateBeforeCall(body, shipmentId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ShipmentInvoiceApi-submitInvoice");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.submitInvoiceBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<SubmitInvoiceResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("submitInvoice operation exceeds rate limit");
    }

    public ApiResponse<SubmitInvoiceResponse> submitInvoiceWithHttpInfo(SubmitInvoiceRequest body, String shipmentId) throws ApiException, LWAException {
        return this.submitInvoiceWithHttpInfo(body, shipmentId, null);
    }

    public Call submitInvoiceAsync(SubmitInvoiceRequest body, String shipmentId, ApiCallback<SubmitInvoiceResponse> callback) throws ApiException, LWAException {
        return this.submitInvoiceAsync(body, shipmentId, callback, null);
    }

    public Call submitInvoiceAsync(SubmitInvoiceRequest body, String shipmentId, ApiCallback<SubmitInvoiceResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.submitInvoiceValidateBeforeCall(body, shipmentId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ShipmentInvoiceApi-submitInvoice");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.submitInvoiceBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<SubmitInvoiceResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("submitInvoice operation exceeds rate limit");
    }

    public static class Builder {
        private LWAAuthorizationCredentials lwaAuthorizationCredentials;
        private String endpoint;
        private LWAAccessTokenCache lwaAccessTokenCache;
        private Boolean disableAccessTokenCache = false;
        private Boolean disableRateLimiting = false;

        public Builder lwaAuthorizationCredentials(LWAAuthorizationCredentials lwaAuthorizationCredentials) {
            this.lwaAuthorizationCredentials = lwaAuthorizationCredentials;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder lwaAccessTokenCache(LWAAccessTokenCache lwaAccessTokenCache) {
            this.lwaAccessTokenCache = lwaAccessTokenCache;
            return this;
        }

        public Builder disableAccessTokenCache() {
            this.disableAccessTokenCache = true;
            return this;
        }

        public Builder disableRateLimiting() {
            this.disableRateLimiting = true;
            return this;
        }

        public ShipmentInvoiceApi build() {
            if (this.lwaAuthorizationCredentials == null) {
                throw new RuntimeException("LWAAuthorizationCredentials not set");
            }
            if (StringUtil.isEmpty(this.endpoint)) {
                throw new RuntimeException("Endpoint not set");
            }
            LWAAuthorizationSigner lwaAuthorizationSigner = null;
            if (this.disableAccessTokenCache.booleanValue()) {
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials);
            } else {
                if (this.lwaAccessTokenCache == null) {
                    this.lwaAccessTokenCache = new LWAAccessTokenCacheImpl();
                }
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials, this.lwaAccessTokenCache);
            }
            return new ShipmentInvoiceApi(new ApiClient().setLWAAuthorizationSigner(lwaAuthorizationSigner).setBasePath(this.endpoint), this.disableRateLimiting);
        }
    }
}

