/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.api.fulfillment.inbound.v0;

import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCache;
import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCacheImpl;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationCredentials;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationSigner;
import com.amazon.SellingPartnerAPIAA.LWAException;
import com.amazon.SellingPartnerAPIAA.RestrictedDataTokenSigner;
import com.google.gson.reflect.TypeToken;
import io.github.bucket4j.Bucket;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import okhttp3.Request;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.ApiCallback;
import software.amazon.spapi.ApiClient;
import software.amazon.spapi.ApiException;
import software.amazon.spapi.ApiResponse;
import software.amazon.spapi.Configuration;
import software.amazon.spapi.Pair;
import software.amazon.spapi.ProgressRequestBody;
import software.amazon.spapi.StringUtil;
import software.amazon.spapi.models.fulfillment.inbound.v0.GetBillOfLadingResponse;
import software.amazon.spapi.models.fulfillment.inbound.v0.GetLabelsResponse;
import software.amazon.spapi.models.fulfillment.inbound.v0.GetPrepInstructionsResponse;
import software.amazon.spapi.models.fulfillment.inbound.v0.GetShipmentItemsResponse;
import software.amazon.spapi.models.fulfillment.inbound.v0.GetShipmentsResponse;

public class FbaInboundApi {
    private ApiClient apiClient;
    private Boolean disableRateLimiting;
    private final Configuration config = Configuration.get();
    public final Bucket getBillOfLadingBucket = Bucket.builder().addLimit(this.config.getLimit("FbaInboundApi-getBillOfLading")).build();
    public final Bucket getLabelsBucket = Bucket.builder().addLimit(this.config.getLimit("FbaInboundApi-getLabels")).build();
    public final Bucket getPrepInstructionsBucket = Bucket.builder().addLimit(this.config.getLimit("FbaInboundApi-getPrepInstructions")).build();
    public final Bucket getShipmentItemsBucket = Bucket.builder().addLimit(this.config.getLimit("FbaInboundApi-getShipmentItems")).build();
    public final Bucket getShipmentItemsByShipmentIdBucket = Bucket.builder().addLimit(this.config.getLimit("FbaInboundApi-getShipmentItemsByShipmentId")).build();
    public final Bucket getShipmentsBucket = Bucket.builder().addLimit(this.config.getLimit("FbaInboundApi-getShipments")).build();

    public FbaInboundApi(ApiClient apiClient, Boolean disableRateLimiting) {
        this.apiClient = apiClient;
        this.disableRateLimiting = disableRateLimiting;
    }

    private Call getBillOfLadingCall(String shipmentId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/fba/inbound/v0/shipments/{shipmentId}/billOfLading".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/fba/inbound/v0/shipments/{shipmentId}/billOfLading".replaceAll("\\{shipmentId\\}", shipmentId.toString()) : "/fba/inbound/v0/shipments/{shipmentId}/billOfLading".replaceAll("\\{shipmentId\\}", this.apiClient.escapeString(shipmentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getBillOfLadingValidateBeforeCall(String shipmentId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (shipmentId == null) {
            throw new ApiException("Missing the required parameter 'shipmentId' when calling getBillOfLading(Async)");
        }
        return this.getBillOfLadingCall(shipmentId, progressRequestListener);
    }

    public GetBillOfLadingResponse getBillOfLading(String shipmentId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetBillOfLadingResponse> resp = this.getBillOfLadingWithHttpInfo(shipmentId, restrictedDataToken);
        return resp.getData();
    }

    public GetBillOfLadingResponse getBillOfLading(String shipmentId) throws ApiException, LWAException {
        ApiResponse<GetBillOfLadingResponse> resp = this.getBillOfLadingWithHttpInfo(shipmentId, null);
        return resp.getData();
    }

    public ApiResponse<GetBillOfLadingResponse> getBillOfLadingWithHttpInfo(String shipmentId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getBillOfLadingValidateBeforeCall(shipmentId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FbaInboundApi-getBillOfLading");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getBillOfLadingBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetBillOfLadingResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getBillOfLading operation exceeds rate limit");
    }

    public ApiResponse<GetBillOfLadingResponse> getBillOfLadingWithHttpInfo(String shipmentId) throws ApiException, LWAException {
        return this.getBillOfLadingWithHttpInfo(shipmentId, null);
    }

    public Call getBillOfLadingAsync(String shipmentId, ApiCallback<GetBillOfLadingResponse> callback) throws ApiException, LWAException {
        return this.getBillOfLadingAsync(shipmentId, callback, null);
    }

    public Call getBillOfLadingAsync(String shipmentId, ApiCallback<GetBillOfLadingResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getBillOfLadingValidateBeforeCall(shipmentId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FbaInboundApi-getBillOfLading");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getBillOfLadingBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetBillOfLadingResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getBillOfLading operation exceeds rate limit");
    }

    private Call getLabelsCall(String shipmentId, String pageType, String labelType, Integer numberOfPackages, List<String> packageLabelsToPrint, Integer numberOfPallets, Integer pageSize, Integer pageStartIndex, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/fba/inbound/v0/shipments/{shipmentId}/labels".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/fba/inbound/v0/shipments/{shipmentId}/labels".replaceAll("\\{shipmentId\\}", shipmentId.toString()) : "/fba/inbound/v0/shipments/{shipmentId}/labels".replaceAll("\\{shipmentId\\}", this.apiClient.escapeString(shipmentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pageType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("PageType", pageType));
        }
        if (labelType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("LabelType", labelType));
        }
        if (numberOfPackages != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("NumberOfPackages", numberOfPackages));
        }
        if (packageLabelsToPrint != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "PackageLabelsToPrint", packageLabelsToPrint));
        }
        if (numberOfPallets != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("NumberOfPallets", numberOfPallets));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("PageSize", pageSize));
        }
        if (pageStartIndex != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("PageStartIndex", pageStartIndex));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getLabelsValidateBeforeCall(String shipmentId, String pageType, String labelType, Integer numberOfPackages, List<String> packageLabelsToPrint, Integer numberOfPallets, Integer pageSize, Integer pageStartIndex, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (shipmentId == null) {
            throw new ApiException("Missing the required parameter 'shipmentId' when calling getLabels(Async)");
        }
        if (pageType == null) {
            throw new ApiException("Missing the required parameter 'pageType' when calling getLabels(Async)");
        }
        if (labelType == null) {
            throw new ApiException("Missing the required parameter 'labelType' when calling getLabels(Async)");
        }
        return this.getLabelsCall(shipmentId, pageType, labelType, numberOfPackages, packageLabelsToPrint, numberOfPallets, pageSize, pageStartIndex, progressRequestListener);
    }

    public GetLabelsResponse getLabels(String shipmentId, String pageType, String labelType, Integer numberOfPackages, List<String> packageLabelsToPrint, Integer numberOfPallets, Integer pageSize, Integer pageStartIndex, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetLabelsResponse> resp = this.getLabelsWithHttpInfo(shipmentId, pageType, labelType, numberOfPackages, packageLabelsToPrint, numberOfPallets, pageSize, pageStartIndex, restrictedDataToken);
        return resp.getData();
    }

    public GetLabelsResponse getLabels(String shipmentId, String pageType, String labelType, Integer numberOfPackages, List<String> packageLabelsToPrint, Integer numberOfPallets, Integer pageSize, Integer pageStartIndex) throws ApiException, LWAException {
        ApiResponse<GetLabelsResponse> resp = this.getLabelsWithHttpInfo(shipmentId, pageType, labelType, numberOfPackages, packageLabelsToPrint, numberOfPallets, pageSize, pageStartIndex, null);
        return resp.getData();
    }

    public ApiResponse<GetLabelsResponse> getLabelsWithHttpInfo(String shipmentId, String pageType, String labelType, Integer numberOfPackages, List<String> packageLabelsToPrint, Integer numberOfPallets, Integer pageSize, Integer pageStartIndex, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getLabelsValidateBeforeCall(shipmentId, pageType, labelType, numberOfPackages, packageLabelsToPrint, numberOfPallets, pageSize, pageStartIndex, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FbaInboundApi-getLabels");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getLabelsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetLabelsResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getLabels operation exceeds rate limit");
    }

    public ApiResponse<GetLabelsResponse> getLabelsWithHttpInfo(String shipmentId, String pageType, String labelType, Integer numberOfPackages, List<String> packageLabelsToPrint, Integer numberOfPallets, Integer pageSize, Integer pageStartIndex) throws ApiException, LWAException {
        return this.getLabelsWithHttpInfo(shipmentId, pageType, labelType, numberOfPackages, packageLabelsToPrint, numberOfPallets, pageSize, pageStartIndex, null);
    }

    public Call getLabelsAsync(String shipmentId, String pageType, String labelType, Integer numberOfPackages, List<String> packageLabelsToPrint, Integer numberOfPallets, Integer pageSize, Integer pageStartIndex, ApiCallback<GetLabelsResponse> callback) throws ApiException, LWAException {
        return this.getLabelsAsync(shipmentId, pageType, labelType, numberOfPackages, packageLabelsToPrint, numberOfPallets, pageSize, pageStartIndex, callback, null);
    }

    public Call getLabelsAsync(String shipmentId, String pageType, String labelType, Integer numberOfPackages, List<String> packageLabelsToPrint, Integer numberOfPallets, Integer pageSize, Integer pageStartIndex, ApiCallback<GetLabelsResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getLabelsValidateBeforeCall(shipmentId, pageType, labelType, numberOfPackages, packageLabelsToPrint, numberOfPallets, pageSize, pageStartIndex, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FbaInboundApi-getLabels");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getLabelsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetLabelsResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getLabels operation exceeds rate limit");
    }

    private Call getPrepInstructionsCall(String shipToCountryCode, List<String> sellerSKUList, List<String> asINList, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/fba/inbound/v0/prepInstructions".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/fba/inbound/v0/prepInstructions" : "/fba/inbound/v0/prepInstructions";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (shipToCountryCode != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("ShipToCountryCode", shipToCountryCode));
        }
        if (sellerSKUList != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "SellerSKUList", sellerSKUList));
        }
        if (asINList != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "ASINList", asINList));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getPrepInstructionsValidateBeforeCall(String shipToCountryCode, List<String> sellerSKUList, List<String> asINList, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (shipToCountryCode == null) {
            throw new ApiException("Missing the required parameter 'shipToCountryCode' when calling getPrepInstructions(Async)");
        }
        return this.getPrepInstructionsCall(shipToCountryCode, sellerSKUList, asINList, progressRequestListener);
    }

    public GetPrepInstructionsResponse getPrepInstructions(String shipToCountryCode, List<String> sellerSKUList, List<String> asINList, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetPrepInstructionsResponse> resp = this.getPrepInstructionsWithHttpInfo(shipToCountryCode, sellerSKUList, asINList, restrictedDataToken);
        return resp.getData();
    }

    public GetPrepInstructionsResponse getPrepInstructions(String shipToCountryCode, List<String> sellerSKUList, List<String> asINList) throws ApiException, LWAException {
        ApiResponse<GetPrepInstructionsResponse> resp = this.getPrepInstructionsWithHttpInfo(shipToCountryCode, sellerSKUList, asINList, null);
        return resp.getData();
    }

    public ApiResponse<GetPrepInstructionsResponse> getPrepInstructionsWithHttpInfo(String shipToCountryCode, List<String> sellerSKUList, List<String> asINList, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getPrepInstructionsValidateBeforeCall(shipToCountryCode, sellerSKUList, asINList, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FbaInboundApi-getPrepInstructions");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getPrepInstructionsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetPrepInstructionsResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getPrepInstructions operation exceeds rate limit");
    }

    public ApiResponse<GetPrepInstructionsResponse> getPrepInstructionsWithHttpInfo(String shipToCountryCode, List<String> sellerSKUList, List<String> asINList) throws ApiException, LWAException {
        return this.getPrepInstructionsWithHttpInfo(shipToCountryCode, sellerSKUList, asINList, null);
    }

    public Call getPrepInstructionsAsync(String shipToCountryCode, List<String> sellerSKUList, List<String> asINList, ApiCallback<GetPrepInstructionsResponse> callback) throws ApiException, LWAException {
        return this.getPrepInstructionsAsync(shipToCountryCode, sellerSKUList, asINList, callback, null);
    }

    public Call getPrepInstructionsAsync(String shipToCountryCode, List<String> sellerSKUList, List<String> asINList, ApiCallback<GetPrepInstructionsResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getPrepInstructionsValidateBeforeCall(shipToCountryCode, sellerSKUList, asINList, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FbaInboundApi-getPrepInstructions");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getPrepInstructionsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetPrepInstructionsResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getPrepInstructions operation exceeds rate limit");
    }

    private Call getShipmentItemsCall(String queryType, String marketplaceId, OffsetDateTime lastUpdatedAfter, OffsetDateTime lastUpdatedBefore, String nextToken, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/fba/inbound/v0/shipmentItems".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/fba/inbound/v0/shipmentItems" : "/fba/inbound/v0/shipmentItems";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (lastUpdatedAfter != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("LastUpdatedAfter", lastUpdatedAfter));
        }
        if (lastUpdatedBefore != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("LastUpdatedBefore", lastUpdatedBefore));
        }
        if (queryType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("QueryType", queryType));
        }
        if (nextToken != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("NextToken", nextToken));
        }
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("MarketplaceId", marketplaceId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getShipmentItemsValidateBeforeCall(String queryType, String marketplaceId, OffsetDateTime lastUpdatedAfter, OffsetDateTime lastUpdatedBefore, String nextToken, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (queryType == null) {
            throw new ApiException("Missing the required parameter 'queryType' when calling getShipmentItems(Async)");
        }
        if (marketplaceId == null) {
            throw new ApiException("Missing the required parameter 'marketplaceId' when calling getShipmentItems(Async)");
        }
        return this.getShipmentItemsCall(queryType, marketplaceId, lastUpdatedAfter, lastUpdatedBefore, nextToken, progressRequestListener);
    }

    public GetShipmentItemsResponse getShipmentItems(String queryType, String marketplaceId, OffsetDateTime lastUpdatedAfter, OffsetDateTime lastUpdatedBefore, String nextToken, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetShipmentItemsResponse> resp = this.getShipmentItemsWithHttpInfo(queryType, marketplaceId, lastUpdatedAfter, lastUpdatedBefore, nextToken, restrictedDataToken);
        return resp.getData();
    }

    public GetShipmentItemsResponse getShipmentItems(String queryType, String marketplaceId, OffsetDateTime lastUpdatedAfter, OffsetDateTime lastUpdatedBefore, String nextToken) throws ApiException, LWAException {
        ApiResponse<GetShipmentItemsResponse> resp = this.getShipmentItemsWithHttpInfo(queryType, marketplaceId, lastUpdatedAfter, lastUpdatedBefore, nextToken, null);
        return resp.getData();
    }

    public ApiResponse<GetShipmentItemsResponse> getShipmentItemsWithHttpInfo(String queryType, String marketplaceId, OffsetDateTime lastUpdatedAfter, OffsetDateTime lastUpdatedBefore, String nextToken, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getShipmentItemsValidateBeforeCall(queryType, marketplaceId, lastUpdatedAfter, lastUpdatedBefore, nextToken, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FbaInboundApi-getShipmentItems");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getShipmentItemsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetShipmentItemsResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getShipmentItems operation exceeds rate limit");
    }

    public ApiResponse<GetShipmentItemsResponse> getShipmentItemsWithHttpInfo(String queryType, String marketplaceId, OffsetDateTime lastUpdatedAfter, OffsetDateTime lastUpdatedBefore, String nextToken) throws ApiException, LWAException {
        return this.getShipmentItemsWithHttpInfo(queryType, marketplaceId, lastUpdatedAfter, lastUpdatedBefore, nextToken, null);
    }

    public Call getShipmentItemsAsync(String queryType, String marketplaceId, OffsetDateTime lastUpdatedAfter, OffsetDateTime lastUpdatedBefore, String nextToken, ApiCallback<GetShipmentItemsResponse> callback) throws ApiException, LWAException {
        return this.getShipmentItemsAsync(queryType, marketplaceId, lastUpdatedAfter, lastUpdatedBefore, nextToken, callback, null);
    }

    public Call getShipmentItemsAsync(String queryType, String marketplaceId, OffsetDateTime lastUpdatedAfter, OffsetDateTime lastUpdatedBefore, String nextToken, ApiCallback<GetShipmentItemsResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getShipmentItemsValidateBeforeCall(queryType, marketplaceId, lastUpdatedAfter, lastUpdatedBefore, nextToken, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FbaInboundApi-getShipmentItems");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getShipmentItemsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetShipmentItemsResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getShipmentItems operation exceeds rate limit");
    }

    private Call getShipmentItemsByShipmentIdCall(String shipmentId, String marketplaceId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/fba/inbound/v0/shipments/{shipmentId}/items".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/fba/inbound/v0/shipments/{shipmentId}/items".replaceAll("\\{shipmentId\\}", shipmentId.toString()) : "/fba/inbound/v0/shipments/{shipmentId}/items".replaceAll("\\{shipmentId\\}", this.apiClient.escapeString(shipmentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("MarketplaceId", marketplaceId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getShipmentItemsByShipmentIdValidateBeforeCall(String shipmentId, String marketplaceId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (shipmentId == null) {
            throw new ApiException("Missing the required parameter 'shipmentId' when calling getShipmentItemsByShipmentId(Async)");
        }
        return this.getShipmentItemsByShipmentIdCall(shipmentId, marketplaceId, progressRequestListener);
    }

    public GetShipmentItemsResponse getShipmentItemsByShipmentId(String shipmentId, String marketplaceId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetShipmentItemsResponse> resp = this.getShipmentItemsByShipmentIdWithHttpInfo(shipmentId, marketplaceId, restrictedDataToken);
        return resp.getData();
    }

    public GetShipmentItemsResponse getShipmentItemsByShipmentId(String shipmentId, String marketplaceId) throws ApiException, LWAException {
        ApiResponse<GetShipmentItemsResponse> resp = this.getShipmentItemsByShipmentIdWithHttpInfo(shipmentId, marketplaceId, null);
        return resp.getData();
    }

    public ApiResponse<GetShipmentItemsResponse> getShipmentItemsByShipmentIdWithHttpInfo(String shipmentId, String marketplaceId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getShipmentItemsByShipmentIdValidateBeforeCall(shipmentId, marketplaceId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FbaInboundApi-getShipmentItemsByShipmentId");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getShipmentItemsByShipmentIdBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetShipmentItemsResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getShipmentItemsByShipmentId operation exceeds rate limit");
    }

    public ApiResponse<GetShipmentItemsResponse> getShipmentItemsByShipmentIdWithHttpInfo(String shipmentId, String marketplaceId) throws ApiException, LWAException {
        return this.getShipmentItemsByShipmentIdWithHttpInfo(shipmentId, marketplaceId, null);
    }

    public Call getShipmentItemsByShipmentIdAsync(String shipmentId, String marketplaceId, ApiCallback<GetShipmentItemsResponse> callback) throws ApiException, LWAException {
        return this.getShipmentItemsByShipmentIdAsync(shipmentId, marketplaceId, callback, null);
    }

    public Call getShipmentItemsByShipmentIdAsync(String shipmentId, String marketplaceId, ApiCallback<GetShipmentItemsResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getShipmentItemsByShipmentIdValidateBeforeCall(shipmentId, marketplaceId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FbaInboundApi-getShipmentItemsByShipmentId");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getShipmentItemsByShipmentIdBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetShipmentItemsResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getShipmentItemsByShipmentId operation exceeds rate limit");
    }

    private Call getShipmentsCall(String queryType, String marketplaceId, List<String> shipmentStatusList, List<String> shipmentIdList, OffsetDateTime lastUpdatedAfter, OffsetDateTime lastUpdatedBefore, String nextToken, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/fba/inbound/v0/shipments".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/fba/inbound/v0/shipments" : "/fba/inbound/v0/shipments";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (shipmentStatusList != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "ShipmentStatusList", shipmentStatusList));
        }
        if (shipmentIdList != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "ShipmentIdList", shipmentIdList));
        }
        if (lastUpdatedAfter != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("LastUpdatedAfter", lastUpdatedAfter));
        }
        if (lastUpdatedBefore != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("LastUpdatedBefore", lastUpdatedBefore));
        }
        if (queryType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("QueryType", queryType));
        }
        if (nextToken != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("NextToken", nextToken));
        }
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("MarketplaceId", marketplaceId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getShipmentsValidateBeforeCall(String queryType, String marketplaceId, List<String> shipmentStatusList, List<String> shipmentIdList, OffsetDateTime lastUpdatedAfter, OffsetDateTime lastUpdatedBefore, String nextToken, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (queryType == null) {
            throw new ApiException("Missing the required parameter 'queryType' when calling getShipments(Async)");
        }
        if (marketplaceId == null) {
            throw new ApiException("Missing the required parameter 'marketplaceId' when calling getShipments(Async)");
        }
        return this.getShipmentsCall(queryType, marketplaceId, shipmentStatusList, shipmentIdList, lastUpdatedAfter, lastUpdatedBefore, nextToken, progressRequestListener);
    }

    public GetShipmentsResponse getShipments(String queryType, String marketplaceId, List<String> shipmentStatusList, List<String> shipmentIdList, OffsetDateTime lastUpdatedAfter, OffsetDateTime lastUpdatedBefore, String nextToken, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetShipmentsResponse> resp = this.getShipmentsWithHttpInfo(queryType, marketplaceId, shipmentStatusList, shipmentIdList, lastUpdatedAfter, lastUpdatedBefore, nextToken, restrictedDataToken);
        return resp.getData();
    }

    public GetShipmentsResponse getShipments(String queryType, String marketplaceId, List<String> shipmentStatusList, List<String> shipmentIdList, OffsetDateTime lastUpdatedAfter, OffsetDateTime lastUpdatedBefore, String nextToken) throws ApiException, LWAException {
        ApiResponse<GetShipmentsResponse> resp = this.getShipmentsWithHttpInfo(queryType, marketplaceId, shipmentStatusList, shipmentIdList, lastUpdatedAfter, lastUpdatedBefore, nextToken, null);
        return resp.getData();
    }

    public ApiResponse<GetShipmentsResponse> getShipmentsWithHttpInfo(String queryType, String marketplaceId, List<String> shipmentStatusList, List<String> shipmentIdList, OffsetDateTime lastUpdatedAfter, OffsetDateTime lastUpdatedBefore, String nextToken, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getShipmentsValidateBeforeCall(queryType, marketplaceId, shipmentStatusList, shipmentIdList, lastUpdatedAfter, lastUpdatedBefore, nextToken, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FbaInboundApi-getShipments");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getShipmentsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetShipmentsResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getShipments operation exceeds rate limit");
    }

    public ApiResponse<GetShipmentsResponse> getShipmentsWithHttpInfo(String queryType, String marketplaceId, List<String> shipmentStatusList, List<String> shipmentIdList, OffsetDateTime lastUpdatedAfter, OffsetDateTime lastUpdatedBefore, String nextToken) throws ApiException, LWAException {
        return this.getShipmentsWithHttpInfo(queryType, marketplaceId, shipmentStatusList, shipmentIdList, lastUpdatedAfter, lastUpdatedBefore, nextToken, null);
    }

    public Call getShipmentsAsync(String queryType, String marketplaceId, List<String> shipmentStatusList, List<String> shipmentIdList, OffsetDateTime lastUpdatedAfter, OffsetDateTime lastUpdatedBefore, String nextToken, ApiCallback<GetShipmentsResponse> callback) throws ApiException, LWAException {
        return this.getShipmentsAsync(queryType, marketplaceId, shipmentStatusList, shipmentIdList, lastUpdatedAfter, lastUpdatedBefore, nextToken, callback, null);
    }

    public Call getShipmentsAsync(String queryType, String marketplaceId, List<String> shipmentStatusList, List<String> shipmentIdList, OffsetDateTime lastUpdatedAfter, OffsetDateTime lastUpdatedBefore, String nextToken, ApiCallback<GetShipmentsResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getShipmentsValidateBeforeCall(queryType, marketplaceId, shipmentStatusList, shipmentIdList, lastUpdatedAfter, lastUpdatedBefore, nextToken, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FbaInboundApi-getShipments");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getShipmentsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetShipmentsResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getShipments operation exceeds rate limit");
    }

    public static class Builder {
        private LWAAuthorizationCredentials lwaAuthorizationCredentials;
        private String endpoint;
        private LWAAccessTokenCache lwaAccessTokenCache;
        private Boolean disableAccessTokenCache = false;
        private Boolean disableRateLimiting = false;

        public Builder lwaAuthorizationCredentials(LWAAuthorizationCredentials lwaAuthorizationCredentials) {
            this.lwaAuthorizationCredentials = lwaAuthorizationCredentials;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder lwaAccessTokenCache(LWAAccessTokenCache lwaAccessTokenCache) {
            this.lwaAccessTokenCache = lwaAccessTokenCache;
            return this;
        }

        public Builder disableAccessTokenCache() {
            this.disableAccessTokenCache = true;
            return this;
        }

        public Builder disableRateLimiting() {
            this.disableRateLimiting = true;
            return this;
        }

        public FbaInboundApi build() {
            if (this.lwaAuthorizationCredentials == null) {
                throw new RuntimeException("LWAAuthorizationCredentials not set");
            }
            if (StringUtil.isEmpty(this.endpoint)) {
                throw new RuntimeException("Endpoint not set");
            }
            LWAAuthorizationSigner lwaAuthorizationSigner = null;
            if (this.disableAccessTokenCache.booleanValue()) {
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials);
            } else {
                if (this.lwaAccessTokenCache == null) {
                    this.lwaAccessTokenCache = new LWAAccessTokenCacheImpl();
                }
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials, this.lwaAccessTokenCache);
            }
            return new FbaInboundApi(new ApiClient().setLWAAuthorizationSigner(lwaAuthorizationSigner).setBasePath(this.endpoint), this.disableRateLimiting);
        }
    }
}

