/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.api.feeds.v2021_06_30;

import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCache;
import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCacheImpl;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationCredentials;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationSigner;
import com.amazon.SellingPartnerAPIAA.LWAException;
import com.amazon.SellingPartnerAPIAA.RestrictedDataTokenSigner;
import com.google.gson.reflect.TypeToken;
import io.github.bucket4j.Bucket;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import okhttp3.Request;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.ApiCallback;
import software.amazon.spapi.ApiClient;
import software.amazon.spapi.ApiException;
import software.amazon.spapi.ApiResponse;
import software.amazon.spapi.Configuration;
import software.amazon.spapi.Pair;
import software.amazon.spapi.ProgressRequestBody;
import software.amazon.spapi.StringUtil;
import software.amazon.spapi.models.feeds.v2021_06_30.CreateFeedDocumentResponse;
import software.amazon.spapi.models.feeds.v2021_06_30.CreateFeedDocumentSpecification;
import software.amazon.spapi.models.feeds.v2021_06_30.CreateFeedResponse;
import software.amazon.spapi.models.feeds.v2021_06_30.CreateFeedSpecification;
import software.amazon.spapi.models.feeds.v2021_06_30.Feed;
import software.amazon.spapi.models.feeds.v2021_06_30.FeedDocument;
import software.amazon.spapi.models.feeds.v2021_06_30.GetFeedsResponse;

public class FeedsApi {
    private ApiClient apiClient;
    private Boolean disableRateLimiting;
    private final Configuration config = Configuration.get();
    public final Bucket cancelFeedBucket = Bucket.builder().addLimit(this.config.getLimit("FeedsApi-cancelFeed")).build();
    public final Bucket createFeedBucket = Bucket.builder().addLimit(this.config.getLimit("FeedsApi-createFeed")).build();
    public final Bucket createFeedDocumentBucket = Bucket.builder().addLimit(this.config.getLimit("FeedsApi-createFeedDocument")).build();
    public final Bucket getFeedBucket = Bucket.builder().addLimit(this.config.getLimit("FeedsApi-getFeed")).build();
    public final Bucket getFeedDocumentBucket = Bucket.builder().addLimit(this.config.getLimit("FeedsApi-getFeedDocument")).build();
    public final Bucket getFeedsBucket = Bucket.builder().addLimit(this.config.getLimit("FeedsApi-getFeeds")).build();

    public FeedsApi(ApiClient apiClient, Boolean disableRateLimiting) {
        this.apiClient = apiClient;
        this.disableRateLimiting = disableRateLimiting;
    }

    private Call cancelFeedCall(String feedId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/feeds/2021-06-30/feeds/{feedId}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/feeds/2021-06-30/feeds/{feedId}".replaceAll("\\{feedId\\}", feedId.toString()) : "/feeds/2021-06-30/feeds/{feedId}".replaceAll("\\{feedId\\}", this.apiClient.escapeString(feedId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call cancelFeedValidateBeforeCall(String feedId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (feedId == null) {
            throw new ApiException("Missing the required parameter 'feedId' when calling cancelFeed(Async)");
        }
        return this.cancelFeedCall(feedId, progressRequestListener);
    }

    public void cancelFeed(String feedId, String restrictedDataToken) throws ApiException, LWAException {
        this.cancelFeedWithHttpInfo(feedId, restrictedDataToken);
    }

    public void cancelFeed(String feedId) throws ApiException, LWAException {
        this.cancelFeedWithHttpInfo(feedId, null);
    }

    public ApiResponse<Void> cancelFeedWithHttpInfo(String feedId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.cancelFeedValidateBeforeCall(feedId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FeedsApi-cancelFeed");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.cancelFeedBucket.tryConsume(1L)) {
            return this.apiClient.execute(call);
        }
        throw new ApiException.RateLimitExceeded("cancelFeed operation exceeds rate limit");
    }

    public ApiResponse<Void> cancelFeedWithHttpInfo(String feedId) throws ApiException, LWAException {
        return this.cancelFeedWithHttpInfo(feedId, null);
    }

    public Call cancelFeedAsync(String feedId, ApiCallback<Void> callback) throws ApiException, LWAException {
        return this.cancelFeedAsync(feedId, callback, null);
    }

    public Call cancelFeedAsync(String feedId, ApiCallback<Void> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.cancelFeedValidateBeforeCall(feedId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FeedsApi-cancelFeed");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.cancelFeedBucket.tryConsume(1L)) {
            this.apiClient.executeAsync(call, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("cancelFeed operation exceeds rate limit");
    }

    private Call createFeedCall(CreateFeedSpecification body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        CreateFeedSpecification localVarPostBody = body;
        String localVarPath = "/feeds/2021-06-30/feeds".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/feeds/2021-06-30/feeds" : "/feeds/2021-06-30/feeds";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call createFeedValidateBeforeCall(CreateFeedSpecification body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createFeed(Async)");
        }
        return this.createFeedCall(body, progressRequestListener);
    }

    public CreateFeedResponse createFeed(CreateFeedSpecification body, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<CreateFeedResponse> resp = this.createFeedWithHttpInfo(body, restrictedDataToken);
        return resp.getData();
    }

    public CreateFeedResponse createFeed(CreateFeedSpecification body) throws ApiException, LWAException {
        ApiResponse<CreateFeedResponse> resp = this.createFeedWithHttpInfo(body, null);
        return resp.getData();
    }

    public ApiResponse<CreateFeedResponse> createFeedWithHttpInfo(CreateFeedSpecification body, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.createFeedValidateBeforeCall(body, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FeedsApi-createFeed");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createFeedBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CreateFeedResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("createFeed operation exceeds rate limit");
    }

    public ApiResponse<CreateFeedResponse> createFeedWithHttpInfo(CreateFeedSpecification body) throws ApiException, LWAException {
        return this.createFeedWithHttpInfo(body, null);
    }

    public Call createFeedAsync(CreateFeedSpecification body, ApiCallback<CreateFeedResponse> callback) throws ApiException, LWAException {
        return this.createFeedAsync(body, callback, null);
    }

    public Call createFeedAsync(CreateFeedSpecification body, ApiCallback<CreateFeedResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.createFeedValidateBeforeCall(body, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FeedsApi-createFeed");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createFeedBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CreateFeedResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("createFeed operation exceeds rate limit");
    }

    private Call createFeedDocumentCall(CreateFeedDocumentSpecification body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        CreateFeedDocumentSpecification localVarPostBody = body;
        String localVarPath = "/feeds/2021-06-30/documents".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/feeds/2021-06-30/documents" : "/feeds/2021-06-30/documents";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call createFeedDocumentValidateBeforeCall(CreateFeedDocumentSpecification body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createFeedDocument(Async)");
        }
        return this.createFeedDocumentCall(body, progressRequestListener);
    }

    public CreateFeedDocumentResponse createFeedDocument(CreateFeedDocumentSpecification body, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<CreateFeedDocumentResponse> resp = this.createFeedDocumentWithHttpInfo(body, restrictedDataToken);
        return resp.getData();
    }

    public CreateFeedDocumentResponse createFeedDocument(CreateFeedDocumentSpecification body) throws ApiException, LWAException {
        ApiResponse<CreateFeedDocumentResponse> resp = this.createFeedDocumentWithHttpInfo(body, null);
        return resp.getData();
    }

    public ApiResponse<CreateFeedDocumentResponse> createFeedDocumentWithHttpInfo(CreateFeedDocumentSpecification body, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.createFeedDocumentValidateBeforeCall(body, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FeedsApi-createFeedDocument");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createFeedDocumentBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CreateFeedDocumentResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("createFeedDocument operation exceeds rate limit");
    }

    public ApiResponse<CreateFeedDocumentResponse> createFeedDocumentWithHttpInfo(CreateFeedDocumentSpecification body) throws ApiException, LWAException {
        return this.createFeedDocumentWithHttpInfo(body, null);
    }

    public Call createFeedDocumentAsync(CreateFeedDocumentSpecification body, ApiCallback<CreateFeedDocumentResponse> callback) throws ApiException, LWAException {
        return this.createFeedDocumentAsync(body, callback, null);
    }

    public Call createFeedDocumentAsync(CreateFeedDocumentSpecification body, ApiCallback<CreateFeedDocumentResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.createFeedDocumentValidateBeforeCall(body, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FeedsApi-createFeedDocument");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createFeedDocumentBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CreateFeedDocumentResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("createFeedDocument operation exceeds rate limit");
    }

    private Call getFeedCall(String feedId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/feeds/2021-06-30/feeds/{feedId}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/feeds/2021-06-30/feeds/{feedId}".replaceAll("\\{feedId\\}", feedId.toString()) : "/feeds/2021-06-30/feeds/{feedId}".replaceAll("\\{feedId\\}", this.apiClient.escapeString(feedId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getFeedValidateBeforeCall(String feedId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (feedId == null) {
            throw new ApiException("Missing the required parameter 'feedId' when calling getFeed(Async)");
        }
        return this.getFeedCall(feedId, progressRequestListener);
    }

    public Feed getFeed(String feedId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<Feed> resp = this.getFeedWithHttpInfo(feedId, restrictedDataToken);
        return resp.getData();
    }

    public Feed getFeed(String feedId) throws ApiException, LWAException {
        ApiResponse<Feed> resp = this.getFeedWithHttpInfo(feedId, null);
        return resp.getData();
    }

    public ApiResponse<Feed> getFeedWithHttpInfo(String feedId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getFeedValidateBeforeCall(feedId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FeedsApi-getFeed");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getFeedBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<Feed>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getFeed operation exceeds rate limit");
    }

    public ApiResponse<Feed> getFeedWithHttpInfo(String feedId) throws ApiException, LWAException {
        return this.getFeedWithHttpInfo(feedId, null);
    }

    public Call getFeedAsync(String feedId, ApiCallback<Feed> callback) throws ApiException, LWAException {
        return this.getFeedAsync(feedId, callback, null);
    }

    public Call getFeedAsync(String feedId, ApiCallback<Feed> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getFeedValidateBeforeCall(feedId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FeedsApi-getFeed");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getFeedBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<Feed>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getFeed operation exceeds rate limit");
    }

    private Call getFeedDocumentCall(String feedDocumentId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/feeds/2021-06-30/documents/{feedDocumentId}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/feeds/2021-06-30/documents/{feedDocumentId}".replaceAll("\\{feedDocumentId\\}", feedDocumentId.toString()) : "/feeds/2021-06-30/documents/{feedDocumentId}".replaceAll("\\{feedDocumentId\\}", this.apiClient.escapeString(feedDocumentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getFeedDocumentValidateBeforeCall(String feedDocumentId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (feedDocumentId == null) {
            throw new ApiException("Missing the required parameter 'feedDocumentId' when calling getFeedDocument(Async)");
        }
        return this.getFeedDocumentCall(feedDocumentId, progressRequestListener);
    }

    public FeedDocument getFeedDocument(String feedDocumentId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<FeedDocument> resp = this.getFeedDocumentWithHttpInfo(feedDocumentId, restrictedDataToken);
        return resp.getData();
    }

    public FeedDocument getFeedDocument(String feedDocumentId) throws ApiException, LWAException {
        ApiResponse<FeedDocument> resp = this.getFeedDocumentWithHttpInfo(feedDocumentId, null);
        return resp.getData();
    }

    public ApiResponse<FeedDocument> getFeedDocumentWithHttpInfo(String feedDocumentId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getFeedDocumentValidateBeforeCall(feedDocumentId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FeedsApi-getFeedDocument");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getFeedDocumentBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<FeedDocument>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getFeedDocument operation exceeds rate limit");
    }

    public ApiResponse<FeedDocument> getFeedDocumentWithHttpInfo(String feedDocumentId) throws ApiException, LWAException {
        return this.getFeedDocumentWithHttpInfo(feedDocumentId, null);
    }

    public Call getFeedDocumentAsync(String feedDocumentId, ApiCallback<FeedDocument> callback) throws ApiException, LWAException {
        return this.getFeedDocumentAsync(feedDocumentId, callback, null);
    }

    public Call getFeedDocumentAsync(String feedDocumentId, ApiCallback<FeedDocument> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getFeedDocumentValidateBeforeCall(feedDocumentId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FeedsApi-getFeedDocument");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getFeedDocumentBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<FeedDocument>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getFeedDocument operation exceeds rate limit");
    }

    private Call getFeedsCall(List<String> feedTypes, List<String> marketplaceIds, Integer pageSize, List<String> processingStatuses, OffsetDateTime createdSince, OffsetDateTime createdUntil, String nextToken, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/feeds/2021-06-30/feeds".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/feeds/2021-06-30/feeds" : "/feeds/2021-06-30/feeds";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (feedTypes != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "feedTypes", feedTypes));
        }
        if (marketplaceIds != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "marketplaceIds", marketplaceIds));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pageSize", pageSize));
        }
        if (processingStatuses != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "processingStatuses", processingStatuses));
        }
        if (createdSince != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("createdSince", createdSince));
        }
        if (createdUntil != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("createdUntil", createdUntil));
        }
        if (nextToken != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("nextToken", nextToken));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getFeedsValidateBeforeCall(List<String> feedTypes, List<String> marketplaceIds, Integer pageSize, List<String> processingStatuses, OffsetDateTime createdSince, OffsetDateTime createdUntil, String nextToken, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        return this.getFeedsCall(feedTypes, marketplaceIds, pageSize, processingStatuses, createdSince, createdUntil, nextToken, progressRequestListener);
    }

    public GetFeedsResponse getFeeds(List<String> feedTypes, List<String> marketplaceIds, Integer pageSize, List<String> processingStatuses, OffsetDateTime createdSince, OffsetDateTime createdUntil, String nextToken, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetFeedsResponse> resp = this.getFeedsWithHttpInfo(feedTypes, marketplaceIds, pageSize, processingStatuses, createdSince, createdUntil, nextToken, restrictedDataToken);
        return resp.getData();
    }

    public GetFeedsResponse getFeeds(List<String> feedTypes, List<String> marketplaceIds, Integer pageSize, List<String> processingStatuses, OffsetDateTime createdSince, OffsetDateTime createdUntil, String nextToken) throws ApiException, LWAException {
        ApiResponse<GetFeedsResponse> resp = this.getFeedsWithHttpInfo(feedTypes, marketplaceIds, pageSize, processingStatuses, createdSince, createdUntil, nextToken, null);
        return resp.getData();
    }

    public ApiResponse<GetFeedsResponse> getFeedsWithHttpInfo(List<String> feedTypes, List<String> marketplaceIds, Integer pageSize, List<String> processingStatuses, OffsetDateTime createdSince, OffsetDateTime createdUntil, String nextToken, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getFeedsValidateBeforeCall(feedTypes, marketplaceIds, pageSize, processingStatuses, createdSince, createdUntil, nextToken, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FeedsApi-getFeeds");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getFeedsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetFeedsResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getFeeds operation exceeds rate limit");
    }

    public ApiResponse<GetFeedsResponse> getFeedsWithHttpInfo(List<String> feedTypes, List<String> marketplaceIds, Integer pageSize, List<String> processingStatuses, OffsetDateTime createdSince, OffsetDateTime createdUntil, String nextToken) throws ApiException, LWAException {
        return this.getFeedsWithHttpInfo(feedTypes, marketplaceIds, pageSize, processingStatuses, createdSince, createdUntil, nextToken, null);
    }

    public Call getFeedsAsync(List<String> feedTypes, List<String> marketplaceIds, Integer pageSize, List<String> processingStatuses, OffsetDateTime createdSince, OffsetDateTime createdUntil, String nextToken, ApiCallback<GetFeedsResponse> callback) throws ApiException, LWAException {
        return this.getFeedsAsync(feedTypes, marketplaceIds, pageSize, processingStatuses, createdSince, createdUntil, nextToken, callback, null);
    }

    public Call getFeedsAsync(List<String> feedTypes, List<String> marketplaceIds, Integer pageSize, List<String> processingStatuses, OffsetDateTime createdSince, OffsetDateTime createdUntil, String nextToken, ApiCallback<GetFeedsResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getFeedsValidateBeforeCall(feedTypes, marketplaceIds, pageSize, processingStatuses, createdSince, createdUntil, nextToken, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FeedsApi-getFeeds");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getFeedsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetFeedsResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getFeeds operation exceeds rate limit");
    }

    public static class Builder {
        private LWAAuthorizationCredentials lwaAuthorizationCredentials;
        private String endpoint;
        private LWAAccessTokenCache lwaAccessTokenCache;
        private Boolean disableAccessTokenCache = false;
        private Boolean disableRateLimiting = false;

        public Builder lwaAuthorizationCredentials(LWAAuthorizationCredentials lwaAuthorizationCredentials) {
            this.lwaAuthorizationCredentials = lwaAuthorizationCredentials;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder lwaAccessTokenCache(LWAAccessTokenCache lwaAccessTokenCache) {
            this.lwaAccessTokenCache = lwaAccessTokenCache;
            return this;
        }

        public Builder disableAccessTokenCache() {
            this.disableAccessTokenCache = true;
            return this;
        }

        public Builder disableRateLimiting() {
            this.disableRateLimiting = true;
            return this;
        }

        public FeedsApi build() {
            if (this.lwaAuthorizationCredentials == null) {
                throw new RuntimeException("LWAAuthorizationCredentials not set");
            }
            if (StringUtil.isEmpty(this.endpoint)) {
                throw new RuntimeException("Endpoint not set");
            }
            LWAAuthorizationSigner lwaAuthorizationSigner = null;
            if (this.disableAccessTokenCache.booleanValue()) {
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials);
            } else {
                if (this.lwaAccessTokenCache == null) {
                    this.lwaAccessTokenCache = new LWAAccessTokenCacheImpl();
                }
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials, this.lwaAccessTokenCache);
            }
            return new FeedsApi(new ApiClient().setLWAAuthorizationSigner(lwaAuthorizationSigner).setBasePath(this.endpoint), this.disableRateLimiting);
        }
    }
}

