/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.api.fba.inventory.v1;

import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCache;
import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCacheImpl;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationCredentials;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationSigner;
import com.amazon.SellingPartnerAPIAA.LWAException;
import com.amazon.SellingPartnerAPIAA.RestrictedDataTokenSigner;
import com.google.gson.reflect.TypeToken;
import io.github.bucket4j.Bucket;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import okhttp3.Request;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.ApiCallback;
import software.amazon.spapi.ApiClient;
import software.amazon.spapi.ApiException;
import software.amazon.spapi.ApiResponse;
import software.amazon.spapi.Configuration;
import software.amazon.spapi.Pair;
import software.amazon.spapi.ProgressRequestBody;
import software.amazon.spapi.StringUtil;
import software.amazon.spapi.models.fba.inventory.v1.AddInventoryRequest;
import software.amazon.spapi.models.fba.inventory.v1.AddInventoryResponse;
import software.amazon.spapi.models.fba.inventory.v1.CreateInventoryItemRequest;
import software.amazon.spapi.models.fba.inventory.v1.CreateInventoryItemResponse;
import software.amazon.spapi.models.fba.inventory.v1.DeleteInventoryItemResponse;
import software.amazon.spapi.models.fba.inventory.v1.GetInventorySummariesResponse;

public class FbaInventoryApi {
    private ApiClient apiClient;
    private Boolean disableRateLimiting;
    private final Configuration config = Configuration.get();
    public final Bucket addInventoryBucket = Bucket.builder().addLimit(this.config.getLimit("FbaInventoryApi-addInventory")).build();
    public final Bucket createInventoryItemBucket = Bucket.builder().addLimit(this.config.getLimit("FbaInventoryApi-createInventoryItem")).build();
    public final Bucket deleteInventoryItemBucket = Bucket.builder().addLimit(this.config.getLimit("FbaInventoryApi-deleteInventoryItem")).build();
    public final Bucket getInventorySummariesBucket = Bucket.builder().addLimit(this.config.getLimit("FbaInventoryApi-getInventorySummaries")).build();

    public FbaInventoryApi(ApiClient apiClient, Boolean disableRateLimiting) {
        this.apiClient = apiClient;
        this.disableRateLimiting = disableRateLimiting;
    }

    private Call addInventoryCall(AddInventoryRequest body, String xAmznIdempotencyToken, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        AddInventoryRequest localVarPostBody = body;
        String localVarPath = "/fba/inventory/v1/items/inventory".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/fba/inventory/v1/items/inventory" : "/fba/inventory/v1/items/inventory";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xAmznIdempotencyToken != null) {
            localVarHeaderParams.put("x-amzn-idempotency-token", this.apiClient.parameterToString(xAmznIdempotencyToken));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call addInventoryValidateBeforeCall(AddInventoryRequest body, String xAmznIdempotencyToken, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling addInventory(Async)");
        }
        if (xAmznIdempotencyToken == null) {
            throw new ApiException("Missing the required parameter 'xAmznIdempotencyToken' when calling addInventory(Async)");
        }
        return this.addInventoryCall(body, xAmznIdempotencyToken, progressRequestListener);
    }

    public AddInventoryResponse addInventory(AddInventoryRequest body, String xAmznIdempotencyToken, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<AddInventoryResponse> resp = this.addInventoryWithHttpInfo(body, xAmznIdempotencyToken, restrictedDataToken);
        return resp.getData();
    }

    public AddInventoryResponse addInventory(AddInventoryRequest body, String xAmznIdempotencyToken) throws ApiException, LWAException {
        ApiResponse<AddInventoryResponse> resp = this.addInventoryWithHttpInfo(body, xAmznIdempotencyToken, null);
        return resp.getData();
    }

    public ApiResponse<AddInventoryResponse> addInventoryWithHttpInfo(AddInventoryRequest body, String xAmznIdempotencyToken, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.addInventoryValidateBeforeCall(body, xAmznIdempotencyToken, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FbaInventoryApi-addInventory");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.addInventoryBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<AddInventoryResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("addInventory operation exceeds rate limit");
    }

    public ApiResponse<AddInventoryResponse> addInventoryWithHttpInfo(AddInventoryRequest body, String xAmznIdempotencyToken) throws ApiException, LWAException {
        return this.addInventoryWithHttpInfo(body, xAmznIdempotencyToken, null);
    }

    public Call addInventoryAsync(AddInventoryRequest body, String xAmznIdempotencyToken, ApiCallback<AddInventoryResponse> callback) throws ApiException, LWAException {
        return this.addInventoryAsync(body, xAmznIdempotencyToken, callback, null);
    }

    public Call addInventoryAsync(AddInventoryRequest body, String xAmznIdempotencyToken, ApiCallback<AddInventoryResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.addInventoryValidateBeforeCall(body, xAmznIdempotencyToken, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FbaInventoryApi-addInventory");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.addInventoryBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<AddInventoryResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("addInventory operation exceeds rate limit");
    }

    private Call createInventoryItemCall(CreateInventoryItemRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        CreateInventoryItemRequest localVarPostBody = body;
        String localVarPath = "/fba/inventory/v1/items".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/fba/inventory/v1/items" : "/fba/inventory/v1/items";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call createInventoryItemValidateBeforeCall(CreateInventoryItemRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createInventoryItem(Async)");
        }
        return this.createInventoryItemCall(body, progressRequestListener);
    }

    public CreateInventoryItemResponse createInventoryItem(CreateInventoryItemRequest body, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<CreateInventoryItemResponse> resp = this.createInventoryItemWithHttpInfo(body, restrictedDataToken);
        return resp.getData();
    }

    public CreateInventoryItemResponse createInventoryItem(CreateInventoryItemRequest body) throws ApiException, LWAException {
        ApiResponse<CreateInventoryItemResponse> resp = this.createInventoryItemWithHttpInfo(body, null);
        return resp.getData();
    }

    public ApiResponse<CreateInventoryItemResponse> createInventoryItemWithHttpInfo(CreateInventoryItemRequest body, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.createInventoryItemValidateBeforeCall(body, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FbaInventoryApi-createInventoryItem");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createInventoryItemBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CreateInventoryItemResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("createInventoryItem operation exceeds rate limit");
    }

    public ApiResponse<CreateInventoryItemResponse> createInventoryItemWithHttpInfo(CreateInventoryItemRequest body) throws ApiException, LWAException {
        return this.createInventoryItemWithHttpInfo(body, null);
    }

    public Call createInventoryItemAsync(CreateInventoryItemRequest body, ApiCallback<CreateInventoryItemResponse> callback) throws ApiException, LWAException {
        return this.createInventoryItemAsync(body, callback, null);
    }

    public Call createInventoryItemAsync(CreateInventoryItemRequest body, ApiCallback<CreateInventoryItemResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.createInventoryItemValidateBeforeCall(body, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FbaInventoryApi-createInventoryItem");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createInventoryItemBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CreateInventoryItemResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("createInventoryItem operation exceeds rate limit");
    }

    private Call deleteInventoryItemCall(String sellerSku, String marketplaceId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/fba/inventory/v1/items/{sellerSku}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/fba/inventory/v1/items/{sellerSku}".replaceAll("\\{sellerSku\\}", sellerSku.toString()) : "/fba/inventory/v1/items/{sellerSku}".replaceAll("\\{sellerSku\\}", this.apiClient.escapeString(sellerSku.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("marketplaceId", marketplaceId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call deleteInventoryItemValidateBeforeCall(String sellerSku, String marketplaceId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (sellerSku == null) {
            throw new ApiException("Missing the required parameter 'sellerSku' when calling deleteInventoryItem(Async)");
        }
        if (marketplaceId == null) {
            throw new ApiException("Missing the required parameter 'marketplaceId' when calling deleteInventoryItem(Async)");
        }
        return this.deleteInventoryItemCall(sellerSku, marketplaceId, progressRequestListener);
    }

    public DeleteInventoryItemResponse deleteInventoryItem(String sellerSku, String marketplaceId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<DeleteInventoryItemResponse> resp = this.deleteInventoryItemWithHttpInfo(sellerSku, marketplaceId, restrictedDataToken);
        return resp.getData();
    }

    public DeleteInventoryItemResponse deleteInventoryItem(String sellerSku, String marketplaceId) throws ApiException, LWAException {
        ApiResponse<DeleteInventoryItemResponse> resp = this.deleteInventoryItemWithHttpInfo(sellerSku, marketplaceId, null);
        return resp.getData();
    }

    public ApiResponse<DeleteInventoryItemResponse> deleteInventoryItemWithHttpInfo(String sellerSku, String marketplaceId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.deleteInventoryItemValidateBeforeCall(sellerSku, marketplaceId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FbaInventoryApi-deleteInventoryItem");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.deleteInventoryItemBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<DeleteInventoryItemResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("deleteInventoryItem operation exceeds rate limit");
    }

    public ApiResponse<DeleteInventoryItemResponse> deleteInventoryItemWithHttpInfo(String sellerSku, String marketplaceId) throws ApiException, LWAException {
        return this.deleteInventoryItemWithHttpInfo(sellerSku, marketplaceId, null);
    }

    public Call deleteInventoryItemAsync(String sellerSku, String marketplaceId, ApiCallback<DeleteInventoryItemResponse> callback) throws ApiException, LWAException {
        return this.deleteInventoryItemAsync(sellerSku, marketplaceId, callback, null);
    }

    public Call deleteInventoryItemAsync(String sellerSku, String marketplaceId, ApiCallback<DeleteInventoryItemResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.deleteInventoryItemValidateBeforeCall(sellerSku, marketplaceId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FbaInventoryApi-deleteInventoryItem");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.deleteInventoryItemBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<DeleteInventoryItemResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("deleteInventoryItem operation exceeds rate limit");
    }

    private Call getInventorySummariesCall(String granularityType, String granularityId, List<String> marketplaceIds, Boolean details, OffsetDateTime startDateTime, List<String> sellerSkus, String sellerSku, String nextToken, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/fba/inventory/v1/summaries".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/fba/inventory/v1/summaries" : "/fba/inventory/v1/summaries";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (details != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("details", details));
        }
        if (granularityType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("granularityType", granularityType));
        }
        if (granularityId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("granularityId", granularityId));
        }
        if (startDateTime != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("startDateTime", startDateTime));
        }
        if (sellerSkus != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "sellerSkus", sellerSkus));
        }
        if (sellerSku != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sellerSku", sellerSku));
        }
        if (nextToken != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("nextToken", nextToken));
        }
        if (marketplaceIds != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "marketplaceIds", marketplaceIds));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getInventorySummariesValidateBeforeCall(String granularityType, String granularityId, List<String> marketplaceIds, Boolean details, OffsetDateTime startDateTime, List<String> sellerSkus, String sellerSku, String nextToken, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (granularityType == null) {
            throw new ApiException("Missing the required parameter 'granularityType' when calling getInventorySummaries(Async)");
        }
        if (granularityId == null) {
            throw new ApiException("Missing the required parameter 'granularityId' when calling getInventorySummaries(Async)");
        }
        if (marketplaceIds == null) {
            throw new ApiException("Missing the required parameter 'marketplaceIds' when calling getInventorySummaries(Async)");
        }
        return this.getInventorySummariesCall(granularityType, granularityId, marketplaceIds, details, startDateTime, sellerSkus, sellerSku, nextToken, progressRequestListener);
    }

    public GetInventorySummariesResponse getInventorySummaries(String granularityType, String granularityId, List<String> marketplaceIds, Boolean details, OffsetDateTime startDateTime, List<String> sellerSkus, String sellerSku, String nextToken, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetInventorySummariesResponse> resp = this.getInventorySummariesWithHttpInfo(granularityType, granularityId, marketplaceIds, details, startDateTime, sellerSkus, sellerSku, nextToken, restrictedDataToken);
        return resp.getData();
    }

    public GetInventorySummariesResponse getInventorySummaries(String granularityType, String granularityId, List<String> marketplaceIds, Boolean details, OffsetDateTime startDateTime, List<String> sellerSkus, String sellerSku, String nextToken) throws ApiException, LWAException {
        ApiResponse<GetInventorySummariesResponse> resp = this.getInventorySummariesWithHttpInfo(granularityType, granularityId, marketplaceIds, details, startDateTime, sellerSkus, sellerSku, nextToken, null);
        return resp.getData();
    }

    public ApiResponse<GetInventorySummariesResponse> getInventorySummariesWithHttpInfo(String granularityType, String granularityId, List<String> marketplaceIds, Boolean details, OffsetDateTime startDateTime, List<String> sellerSkus, String sellerSku, String nextToken, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getInventorySummariesValidateBeforeCall(granularityType, granularityId, marketplaceIds, details, startDateTime, sellerSkus, sellerSku, nextToken, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FbaInventoryApi-getInventorySummaries");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getInventorySummariesBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetInventorySummariesResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getInventorySummaries operation exceeds rate limit");
    }

    public ApiResponse<GetInventorySummariesResponse> getInventorySummariesWithHttpInfo(String granularityType, String granularityId, List<String> marketplaceIds, Boolean details, OffsetDateTime startDateTime, List<String> sellerSkus, String sellerSku, String nextToken) throws ApiException, LWAException {
        return this.getInventorySummariesWithHttpInfo(granularityType, granularityId, marketplaceIds, details, startDateTime, sellerSkus, sellerSku, nextToken, null);
    }

    public Call getInventorySummariesAsync(String granularityType, String granularityId, List<String> marketplaceIds, Boolean details, OffsetDateTime startDateTime, List<String> sellerSkus, String sellerSku, String nextToken, ApiCallback<GetInventorySummariesResponse> callback) throws ApiException, LWAException {
        return this.getInventorySummariesAsync(granularityType, granularityId, marketplaceIds, details, startDateTime, sellerSkus, sellerSku, nextToken, callback, null);
    }

    public Call getInventorySummariesAsync(String granularityType, String granularityId, List<String> marketplaceIds, Boolean details, OffsetDateTime startDateTime, List<String> sellerSkus, String sellerSku, String nextToken, ApiCallback<GetInventorySummariesResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getInventorySummariesValidateBeforeCall(granularityType, granularityId, marketplaceIds, details, startDateTime, sellerSkus, sellerSku, nextToken, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FbaInventoryApi-getInventorySummaries");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getInventorySummariesBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetInventorySummariesResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getInventorySummaries operation exceeds rate limit");
    }

    public static class Builder {
        private LWAAuthorizationCredentials lwaAuthorizationCredentials;
        private String endpoint;
        private LWAAccessTokenCache lwaAccessTokenCache;
        private Boolean disableAccessTokenCache = false;
        private Boolean disableRateLimiting = false;

        public Builder lwaAuthorizationCredentials(LWAAuthorizationCredentials lwaAuthorizationCredentials) {
            this.lwaAuthorizationCredentials = lwaAuthorizationCredentials;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder lwaAccessTokenCache(LWAAccessTokenCache lwaAccessTokenCache) {
            this.lwaAccessTokenCache = lwaAccessTokenCache;
            return this;
        }

        public Builder disableAccessTokenCache() {
            this.disableAccessTokenCache = true;
            return this;
        }

        public Builder disableRateLimiting() {
            this.disableRateLimiting = true;
            return this;
        }

        public FbaInventoryApi build() {
            if (this.lwaAuthorizationCredentials == null) {
                throw new RuntimeException("LWAAuthorizationCredentials not set");
            }
            if (StringUtil.isEmpty(this.endpoint)) {
                throw new RuntimeException("Endpoint not set");
            }
            LWAAuthorizationSigner lwaAuthorizationSigner = null;
            if (this.disableAccessTokenCache.booleanValue()) {
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials);
            } else {
                if (this.lwaAccessTokenCache == null) {
                    this.lwaAccessTokenCache = new LWAAccessTokenCacheImpl();
                }
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials, this.lwaAccessTokenCache);
            }
            return new FbaInventoryApi(new ApiClient().setLWAAuthorizationSigner(lwaAuthorizationSigner).setBasePath(this.endpoint), this.disableRateLimiting);
        }
    }
}

