/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.api.easyship.v2022_03_23;

import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCache;
import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCacheImpl;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationCredentials;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationSigner;
import com.amazon.SellingPartnerAPIAA.LWAException;
import com.amazon.SellingPartnerAPIAA.RestrictedDataTokenSigner;
import com.google.gson.reflect.TypeToken;
import io.github.bucket4j.Bucket;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Request;
import software.amazon.spapi.ApiCallback;
import software.amazon.spapi.ApiClient;
import software.amazon.spapi.ApiException;
import software.amazon.spapi.ApiResponse;
import software.amazon.spapi.Configuration;
import software.amazon.spapi.Pair;
import software.amazon.spapi.ProgressRequestBody;
import software.amazon.spapi.StringUtil;
import software.amazon.spapi.models.easyship.v2022_03_23.CreateScheduledPackageRequest;
import software.amazon.spapi.models.easyship.v2022_03_23.CreateScheduledPackagesRequest;
import software.amazon.spapi.models.easyship.v2022_03_23.CreateScheduledPackagesResponse;
import software.amazon.spapi.models.easyship.v2022_03_23.ListHandoverSlotsRequest;
import software.amazon.spapi.models.easyship.v2022_03_23.ListHandoverSlotsResponse;
import software.amazon.spapi.models.easyship.v2022_03_23.ModelPackage;
import software.amazon.spapi.models.easyship.v2022_03_23.Packages;
import software.amazon.spapi.models.easyship.v2022_03_23.UpdateScheduledPackagesRequest;

public class EasyShipApi {
    private ApiClient apiClient;
    private Boolean disableRateLimiting;
    private final Configuration config = Configuration.get();
    public final Bucket createScheduledPackageBucket = Bucket.builder().addLimit(this.config.getLimit("EasyShipApi-createScheduledPackage")).build();
    public final Bucket createScheduledPackageBulkBucket = Bucket.builder().addLimit(this.config.getLimit("EasyShipApi-createScheduledPackageBulk")).build();
    public final Bucket getScheduledPackageBucket = Bucket.builder().addLimit(this.config.getLimit("EasyShipApi-getScheduledPackage")).build();
    public final Bucket listHandoverSlotsBucket = Bucket.builder().addLimit(this.config.getLimit("EasyShipApi-listHandoverSlots")).build();
    public final Bucket updateScheduledPackagesBucket = Bucket.builder().addLimit(this.config.getLimit("EasyShipApi-updateScheduledPackages")).build();

    public EasyShipApi(ApiClient apiClient, Boolean disableRateLimiting) {
        this.apiClient = apiClient;
        this.disableRateLimiting = disableRateLimiting;
    }

    private Call createScheduledPackageCall(CreateScheduledPackageRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        CreateScheduledPackageRequest localVarPostBody = body;
        String localVarPath = "/easyShip/2022-03-23/package".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/easyShip/2022-03-23/package" : "/easyShip/2022-03-23/package";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call createScheduledPackageValidateBeforeCall(CreateScheduledPackageRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createScheduledPackage(Async)");
        }
        return this.createScheduledPackageCall(body, progressRequestListener);
    }

    public ModelPackage createScheduledPackage(CreateScheduledPackageRequest body, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<ModelPackage> resp = this.createScheduledPackageWithHttpInfo(body, restrictedDataToken);
        return resp.getData();
    }

    public ModelPackage createScheduledPackage(CreateScheduledPackageRequest body) throws ApiException, LWAException {
        ApiResponse<ModelPackage> resp = this.createScheduledPackageWithHttpInfo(body, null);
        return resp.getData();
    }

    public ApiResponse<ModelPackage> createScheduledPackageWithHttpInfo(CreateScheduledPackageRequest body, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.createScheduledPackageValidateBeforeCall(body, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "EasyShipApi-createScheduledPackage");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createScheduledPackageBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ModelPackage>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("createScheduledPackage operation exceeds rate limit");
    }

    public ApiResponse<ModelPackage> createScheduledPackageWithHttpInfo(CreateScheduledPackageRequest body) throws ApiException, LWAException {
        return this.createScheduledPackageWithHttpInfo(body, null);
    }

    public Call createScheduledPackageAsync(CreateScheduledPackageRequest body, ApiCallback<ModelPackage> callback) throws ApiException, LWAException {
        return this.createScheduledPackageAsync(body, callback, null);
    }

    public Call createScheduledPackageAsync(CreateScheduledPackageRequest body, ApiCallback<ModelPackage> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.createScheduledPackageValidateBeforeCall(body, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "EasyShipApi-createScheduledPackage");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createScheduledPackageBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ModelPackage>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("createScheduledPackage operation exceeds rate limit");
    }

    private Call createScheduledPackageBulkCall(CreateScheduledPackagesRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        CreateScheduledPackagesRequest localVarPostBody = body;
        String localVarPath = "/easyShip/2022-03-23/packages/bulk".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/easyShip/2022-03-23/packages/bulk" : "/easyShip/2022-03-23/packages/bulk";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call createScheduledPackageBulkValidateBeforeCall(CreateScheduledPackagesRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createScheduledPackageBulk(Async)");
        }
        return this.createScheduledPackageBulkCall(body, progressRequestListener);
    }

    public CreateScheduledPackagesResponse createScheduledPackageBulk(CreateScheduledPackagesRequest body, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<CreateScheduledPackagesResponse> resp = this.createScheduledPackageBulkWithHttpInfo(body, restrictedDataToken);
        return resp.getData();
    }

    public CreateScheduledPackagesResponse createScheduledPackageBulk(CreateScheduledPackagesRequest body) throws ApiException, LWAException {
        ApiResponse<CreateScheduledPackagesResponse> resp = this.createScheduledPackageBulkWithHttpInfo(body, null);
        return resp.getData();
    }

    public ApiResponse<CreateScheduledPackagesResponse> createScheduledPackageBulkWithHttpInfo(CreateScheduledPackagesRequest body, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.createScheduledPackageBulkValidateBeforeCall(body, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "EasyShipApi-createScheduledPackageBulk");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createScheduledPackageBulkBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CreateScheduledPackagesResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("createScheduledPackageBulk operation exceeds rate limit");
    }

    public ApiResponse<CreateScheduledPackagesResponse> createScheduledPackageBulkWithHttpInfo(CreateScheduledPackagesRequest body) throws ApiException, LWAException {
        return this.createScheduledPackageBulkWithHttpInfo(body, null);
    }

    public Call createScheduledPackageBulkAsync(CreateScheduledPackagesRequest body, ApiCallback<CreateScheduledPackagesResponse> callback) throws ApiException, LWAException {
        return this.createScheduledPackageBulkAsync(body, callback, null);
    }

    public Call createScheduledPackageBulkAsync(CreateScheduledPackagesRequest body, ApiCallback<CreateScheduledPackagesResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.createScheduledPackageBulkValidateBeforeCall(body, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "EasyShipApi-createScheduledPackageBulk");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createScheduledPackageBulkBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CreateScheduledPackagesResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("createScheduledPackageBulk operation exceeds rate limit");
    }

    private Call getScheduledPackageCall(String amazonOrderId, String marketplaceId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/easyShip/2022-03-23/package".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/easyShip/2022-03-23/package" : "/easyShip/2022-03-23/package";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (amazonOrderId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("amazonOrderId", amazonOrderId));
        }
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("marketplaceId", marketplaceId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getScheduledPackageValidateBeforeCall(String amazonOrderId, String marketplaceId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (amazonOrderId == null) {
            throw new ApiException("Missing the required parameter 'amazonOrderId' when calling getScheduledPackage(Async)");
        }
        if (marketplaceId == null) {
            throw new ApiException("Missing the required parameter 'marketplaceId' when calling getScheduledPackage(Async)");
        }
        return this.getScheduledPackageCall(amazonOrderId, marketplaceId, progressRequestListener);
    }

    public ModelPackage getScheduledPackage(String amazonOrderId, String marketplaceId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<ModelPackage> resp = this.getScheduledPackageWithHttpInfo(amazonOrderId, marketplaceId, restrictedDataToken);
        return resp.getData();
    }

    public ModelPackage getScheduledPackage(String amazonOrderId, String marketplaceId) throws ApiException, LWAException {
        ApiResponse<ModelPackage> resp = this.getScheduledPackageWithHttpInfo(amazonOrderId, marketplaceId, null);
        return resp.getData();
    }

    public ApiResponse<ModelPackage> getScheduledPackageWithHttpInfo(String amazonOrderId, String marketplaceId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getScheduledPackageValidateBeforeCall(amazonOrderId, marketplaceId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "EasyShipApi-getScheduledPackage");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getScheduledPackageBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ModelPackage>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getScheduledPackage operation exceeds rate limit");
    }

    public ApiResponse<ModelPackage> getScheduledPackageWithHttpInfo(String amazonOrderId, String marketplaceId) throws ApiException, LWAException {
        return this.getScheduledPackageWithHttpInfo(amazonOrderId, marketplaceId, null);
    }

    public Call getScheduledPackageAsync(String amazonOrderId, String marketplaceId, ApiCallback<ModelPackage> callback) throws ApiException, LWAException {
        return this.getScheduledPackageAsync(amazonOrderId, marketplaceId, callback, null);
    }

    public Call getScheduledPackageAsync(String amazonOrderId, String marketplaceId, ApiCallback<ModelPackage> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getScheduledPackageValidateBeforeCall(amazonOrderId, marketplaceId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "EasyShipApi-getScheduledPackage");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getScheduledPackageBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ModelPackage>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getScheduledPackage operation exceeds rate limit");
    }

    private Call listHandoverSlotsCall(ListHandoverSlotsRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        ListHandoverSlotsRequest localVarPostBody = body;
        String localVarPath = "/easyShip/2022-03-23/timeSlot".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/easyShip/2022-03-23/timeSlot" : "/easyShip/2022-03-23/timeSlot";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call listHandoverSlotsValidateBeforeCall(ListHandoverSlotsRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        return this.listHandoverSlotsCall(body, progressRequestListener);
    }

    public ListHandoverSlotsResponse listHandoverSlots(ListHandoverSlotsRequest body, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<ListHandoverSlotsResponse> resp = this.listHandoverSlotsWithHttpInfo(body, restrictedDataToken);
        return resp.getData();
    }

    public ListHandoverSlotsResponse listHandoverSlots(ListHandoverSlotsRequest body) throws ApiException, LWAException {
        ApiResponse<ListHandoverSlotsResponse> resp = this.listHandoverSlotsWithHttpInfo(body, null);
        return resp.getData();
    }

    public ApiResponse<ListHandoverSlotsResponse> listHandoverSlotsWithHttpInfo(ListHandoverSlotsRequest body, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.listHandoverSlotsValidateBeforeCall(body, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "EasyShipApi-listHandoverSlots");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.listHandoverSlotsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ListHandoverSlotsResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("listHandoverSlots operation exceeds rate limit");
    }

    public ApiResponse<ListHandoverSlotsResponse> listHandoverSlotsWithHttpInfo(ListHandoverSlotsRequest body) throws ApiException, LWAException {
        return this.listHandoverSlotsWithHttpInfo(body, null);
    }

    public Call listHandoverSlotsAsync(ListHandoverSlotsRequest body, ApiCallback<ListHandoverSlotsResponse> callback) throws ApiException, LWAException {
        return this.listHandoverSlotsAsync(body, callback, null);
    }

    public Call listHandoverSlotsAsync(ListHandoverSlotsRequest body, ApiCallback<ListHandoverSlotsResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.listHandoverSlotsValidateBeforeCall(body, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "EasyShipApi-listHandoverSlots");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.listHandoverSlotsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ListHandoverSlotsResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("listHandoverSlots operation exceeds rate limit");
    }

    private Call updateScheduledPackagesCall(UpdateScheduledPackagesRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        UpdateScheduledPackagesRequest localVarPostBody = body;
        String localVarPath = "/easyShip/2022-03-23/package".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/easyShip/2022-03-23/package" : "/easyShip/2022-03-23/package";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call updateScheduledPackagesValidateBeforeCall(UpdateScheduledPackagesRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        return this.updateScheduledPackagesCall(body, progressRequestListener);
    }

    public Packages updateScheduledPackages(UpdateScheduledPackagesRequest body, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<Packages> resp = this.updateScheduledPackagesWithHttpInfo(body, restrictedDataToken);
        return resp.getData();
    }

    public Packages updateScheduledPackages(UpdateScheduledPackagesRequest body) throws ApiException, LWAException {
        ApiResponse<Packages> resp = this.updateScheduledPackagesWithHttpInfo(body, null);
        return resp.getData();
    }

    public ApiResponse<Packages> updateScheduledPackagesWithHttpInfo(UpdateScheduledPackagesRequest body, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.updateScheduledPackagesValidateBeforeCall(body, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "EasyShipApi-updateScheduledPackages");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.updateScheduledPackagesBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<Packages>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("updateScheduledPackages operation exceeds rate limit");
    }

    public ApiResponse<Packages> updateScheduledPackagesWithHttpInfo(UpdateScheduledPackagesRequest body) throws ApiException, LWAException {
        return this.updateScheduledPackagesWithHttpInfo(body, null);
    }

    public Call updateScheduledPackagesAsync(UpdateScheduledPackagesRequest body, ApiCallback<Packages> callback) throws ApiException, LWAException {
        return this.updateScheduledPackagesAsync(body, callback, null);
    }

    public Call updateScheduledPackagesAsync(UpdateScheduledPackagesRequest body, ApiCallback<Packages> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.updateScheduledPackagesValidateBeforeCall(body, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "EasyShipApi-updateScheduledPackages");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.updateScheduledPackagesBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<Packages>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("updateScheduledPackages operation exceeds rate limit");
    }

    public static class Builder {
        private LWAAuthorizationCredentials lwaAuthorizationCredentials;
        private String endpoint;
        private LWAAccessTokenCache lwaAccessTokenCache;
        private Boolean disableAccessTokenCache = false;
        private Boolean disableRateLimiting = false;

        public Builder lwaAuthorizationCredentials(LWAAuthorizationCredentials lwaAuthorizationCredentials) {
            this.lwaAuthorizationCredentials = lwaAuthorizationCredentials;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder lwaAccessTokenCache(LWAAccessTokenCache lwaAccessTokenCache) {
            this.lwaAccessTokenCache = lwaAccessTokenCache;
            return this;
        }

        public Builder disableAccessTokenCache() {
            this.disableAccessTokenCache = true;
            return this;
        }

        public Builder disableRateLimiting() {
            this.disableRateLimiting = true;
            return this;
        }

        public EasyShipApi build() {
            if (this.lwaAuthorizationCredentials == null) {
                throw new RuntimeException("LWAAuthorizationCredentials not set");
            }
            if (StringUtil.isEmpty(this.endpoint)) {
                throw new RuntimeException("Endpoint not set");
            }
            LWAAuthorizationSigner lwaAuthorizationSigner = null;
            if (this.disableAccessTokenCache.booleanValue()) {
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials);
            } else {
                if (this.lwaAccessTokenCache == null) {
                    this.lwaAccessTokenCache = new LWAAccessTokenCacheImpl();
                }
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials, this.lwaAccessTokenCache);
            }
            return new EasyShipApi(new ApiClient().setLWAAuthorizationSigner(lwaAuthorizationSigner).setBasePath(this.endpoint), this.disableRateLimiting);
        }
    }
}

