/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.api.appintegrations.v2024_04_01;

import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCache;
import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCacheImpl;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationCredentials;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationSigner;
import com.amazon.SellingPartnerAPIAA.LWAException;
import com.amazon.SellingPartnerAPIAA.RestrictedDataTokenSigner;
import com.google.gson.reflect.TypeToken;
import io.github.bucket4j.Bucket;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Request;
import software.amazon.spapi.ApiCallback;
import software.amazon.spapi.ApiClient;
import software.amazon.spapi.ApiException;
import software.amazon.spapi.ApiResponse;
import software.amazon.spapi.Configuration;
import software.amazon.spapi.Pair;
import software.amazon.spapi.ProgressRequestBody;
import software.amazon.spapi.StringUtil;
import software.amazon.spapi.models.appintegrations.v2024_04_01.CreateNotificationRequest;
import software.amazon.spapi.models.appintegrations.v2024_04_01.CreateNotificationResponse;
import software.amazon.spapi.models.appintegrations.v2024_04_01.DeleteNotificationsRequest;
import software.amazon.spapi.models.appintegrations.v2024_04_01.RecordActionFeedbackRequest;

public class AppIntegrationsApi {
    private ApiClient apiClient;
    private Boolean disableRateLimiting;
    private final Configuration config = Configuration.get();
    public final Bucket createNotificationBucket = Bucket.builder().addLimit(this.config.getLimit("AppIntegrationsApi-createNotification")).build();
    public final Bucket deleteNotificationsBucket = Bucket.builder().addLimit(this.config.getLimit("AppIntegrationsApi-deleteNotifications")).build();
    public final Bucket recordActionFeedbackBucket = Bucket.builder().addLimit(this.config.getLimit("AppIntegrationsApi-recordActionFeedback")).build();

    public AppIntegrationsApi(ApiClient apiClient, Boolean disableRateLimiting) {
        this.apiClient = apiClient;
        this.disableRateLimiting = disableRateLimiting;
    }

    private Call createNotificationCall(CreateNotificationRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        CreateNotificationRequest localVarPostBody = body;
        String localVarPath = "/appIntegrations/2024-04-01/notifications".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/appIntegrations/2024-04-01/notifications" : "/appIntegrations/2024-04-01/notifications";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call createNotificationValidateBeforeCall(CreateNotificationRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createNotification(Async)");
        }
        return this.createNotificationCall(body, progressRequestListener);
    }

    public CreateNotificationResponse createNotification(CreateNotificationRequest body, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<CreateNotificationResponse> resp = this.createNotificationWithHttpInfo(body, restrictedDataToken);
        return resp.getData();
    }

    public CreateNotificationResponse createNotification(CreateNotificationRequest body) throws ApiException, LWAException {
        ApiResponse<CreateNotificationResponse> resp = this.createNotificationWithHttpInfo(body, null);
        return resp.getData();
    }

    public ApiResponse<CreateNotificationResponse> createNotificationWithHttpInfo(CreateNotificationRequest body, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.createNotificationValidateBeforeCall(body, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "AppIntegrationsApi-createNotification");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createNotificationBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CreateNotificationResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("createNotification operation exceeds rate limit");
    }

    public ApiResponse<CreateNotificationResponse> createNotificationWithHttpInfo(CreateNotificationRequest body) throws ApiException, LWAException {
        return this.createNotificationWithHttpInfo(body, null);
    }

    public Call createNotificationAsync(CreateNotificationRequest body, ApiCallback<CreateNotificationResponse> callback) throws ApiException, LWAException {
        return this.createNotificationAsync(body, callback, null);
    }

    public Call createNotificationAsync(CreateNotificationRequest body, ApiCallback<CreateNotificationResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.createNotificationValidateBeforeCall(body, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "AppIntegrationsApi-createNotification");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createNotificationBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CreateNotificationResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("createNotification operation exceeds rate limit");
    }

    private Call deleteNotificationsCall(DeleteNotificationsRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        DeleteNotificationsRequest localVarPostBody = body;
        String localVarPath = "/appIntegrations/2024-04-01/notifications/deletion".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/appIntegrations/2024-04-01/notifications/deletion" : "/appIntegrations/2024-04-01/notifications/deletion";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call deleteNotificationsValidateBeforeCall(DeleteNotificationsRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling deleteNotifications(Async)");
        }
        return this.deleteNotificationsCall(body, progressRequestListener);
    }

    public void deleteNotifications(DeleteNotificationsRequest body, String restrictedDataToken) throws ApiException, LWAException {
        this.deleteNotificationsWithHttpInfo(body, restrictedDataToken);
    }

    public void deleteNotifications(DeleteNotificationsRequest body) throws ApiException, LWAException {
        this.deleteNotificationsWithHttpInfo(body, null);
    }

    public ApiResponse<Void> deleteNotificationsWithHttpInfo(DeleteNotificationsRequest body, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.deleteNotificationsValidateBeforeCall(body, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "AppIntegrationsApi-deleteNotifications");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.deleteNotificationsBucket.tryConsume(1L)) {
            return this.apiClient.execute(call);
        }
        throw new ApiException.RateLimitExceeded("deleteNotifications operation exceeds rate limit");
    }

    public ApiResponse<Void> deleteNotificationsWithHttpInfo(DeleteNotificationsRequest body) throws ApiException, LWAException {
        return this.deleteNotificationsWithHttpInfo(body, null);
    }

    public Call deleteNotificationsAsync(DeleteNotificationsRequest body, ApiCallback<Void> callback) throws ApiException, LWAException {
        return this.deleteNotificationsAsync(body, callback, null);
    }

    public Call deleteNotificationsAsync(DeleteNotificationsRequest body, ApiCallback<Void> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.deleteNotificationsValidateBeforeCall(body, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "AppIntegrationsApi-deleteNotifications");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.deleteNotificationsBucket.tryConsume(1L)) {
            this.apiClient.executeAsync(call, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("deleteNotifications operation exceeds rate limit");
    }

    private Call recordActionFeedbackCall(RecordActionFeedbackRequest body, String notificationId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        RecordActionFeedbackRequest localVarPostBody = body;
        String localVarPath = "/appIntegrations/2024-04-01/notifications/{notificationId}/feedback".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/appIntegrations/2024-04-01/notifications/{notificationId}/feedback".replaceAll("\\{notificationId\\}", notificationId.toString()) : "/appIntegrations/2024-04-01/notifications/{notificationId}/feedback".replaceAll("\\{notificationId\\}", this.apiClient.escapeString(notificationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call recordActionFeedbackValidateBeforeCall(RecordActionFeedbackRequest body, String notificationId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling recordActionFeedback(Async)");
        }
        if (notificationId == null) {
            throw new ApiException("Missing the required parameter 'notificationId' when calling recordActionFeedback(Async)");
        }
        return this.recordActionFeedbackCall(body, notificationId, progressRequestListener);
    }

    public void recordActionFeedback(RecordActionFeedbackRequest body, String notificationId, String restrictedDataToken) throws ApiException, LWAException {
        this.recordActionFeedbackWithHttpInfo(body, notificationId, restrictedDataToken);
    }

    public void recordActionFeedback(RecordActionFeedbackRequest body, String notificationId) throws ApiException, LWAException {
        this.recordActionFeedbackWithHttpInfo(body, notificationId, null);
    }

    public ApiResponse<Void> recordActionFeedbackWithHttpInfo(RecordActionFeedbackRequest body, String notificationId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.recordActionFeedbackValidateBeforeCall(body, notificationId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "AppIntegrationsApi-recordActionFeedback");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.recordActionFeedbackBucket.tryConsume(1L)) {
            return this.apiClient.execute(call);
        }
        throw new ApiException.RateLimitExceeded("recordActionFeedback operation exceeds rate limit");
    }

    public ApiResponse<Void> recordActionFeedbackWithHttpInfo(RecordActionFeedbackRequest body, String notificationId) throws ApiException, LWAException {
        return this.recordActionFeedbackWithHttpInfo(body, notificationId, null);
    }

    public Call recordActionFeedbackAsync(RecordActionFeedbackRequest body, String notificationId, ApiCallback<Void> callback) throws ApiException, LWAException {
        return this.recordActionFeedbackAsync(body, notificationId, callback, null);
    }

    public Call recordActionFeedbackAsync(RecordActionFeedbackRequest body, String notificationId, ApiCallback<Void> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.recordActionFeedbackValidateBeforeCall(body, notificationId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "AppIntegrationsApi-recordActionFeedback");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.recordActionFeedbackBucket.tryConsume(1L)) {
            this.apiClient.executeAsync(call, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("recordActionFeedback operation exceeds rate limit");
    }

    public static class Builder {
        private LWAAuthorizationCredentials lwaAuthorizationCredentials;
        private String endpoint;
        private LWAAccessTokenCache lwaAccessTokenCache;
        private Boolean disableAccessTokenCache = false;
        private Boolean disableRateLimiting = false;

        public Builder lwaAuthorizationCredentials(LWAAuthorizationCredentials lwaAuthorizationCredentials) {
            this.lwaAuthorizationCredentials = lwaAuthorizationCredentials;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder lwaAccessTokenCache(LWAAccessTokenCache lwaAccessTokenCache) {
            this.lwaAccessTokenCache = lwaAccessTokenCache;
            return this;
        }

        public Builder disableAccessTokenCache() {
            this.disableAccessTokenCache = true;
            return this;
        }

        public Builder disableRateLimiting() {
            this.disableRateLimiting = true;
            return this;
        }

        public AppIntegrationsApi build() {
            if (this.lwaAuthorizationCredentials == null) {
                throw new RuntimeException("LWAAuthorizationCredentials not set");
            }
            if (StringUtil.isEmpty(this.endpoint)) {
                throw new RuntimeException("Endpoint not set");
            }
            LWAAuthorizationSigner lwaAuthorizationSigner = null;
            if (this.disableAccessTokenCache.booleanValue()) {
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials);
            } else {
                if (this.lwaAccessTokenCache == null) {
                    this.lwaAccessTokenCache = new LWAAccessTokenCacheImpl();
                }
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials, this.lwaAccessTokenCache);
            }
            return new AppIntegrationsApi(new ApiClient().setLWAAuthorizationSigner(lwaAuthorizationSigner).setBasePath(this.endpoint), this.disableRateLimiting);
        }
    }
}

