/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.SellingPartnerAPIAA;

import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCache;
import com.amazon.SellingPartnerAPIAA.LWAAccessTokenRequestMeta;
import com.amazon.SellingPartnerAPIAA.LWAException;
import com.amazon.SellingPartnerAPIAA.LWAExceptionErrorCode;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import lombok.Generated;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.lang3.EnumUtils;

class LWAClient {
    private static final String ACCESS_TOKEN_KEY = "access_token";
    private static final String ACCESS_TOKEN_EXPIRES_IN = "expires_in";
    private static final MediaType JSON_MEDIA_TYPE = MediaType.parse((String)"application/json; charset=utf-8");
    private String endpoint;
    private OkHttpClient okHttpClient = new OkHttpClient();
    private LWAAccessTokenCache lwaAccessTokenCache;

    public void setLWAAccessTokenCache(LWAAccessTokenCache tokenCache) {
        this.lwaAccessTokenCache = tokenCache;
    }

    LWAClient(String endpoint) {
        this.endpoint = endpoint;
    }

    String getAccessToken(LWAAccessTokenRequestMeta lwaAccessTokenRequestMeta) throws LWAException {
        if (this.lwaAccessTokenCache != null) {
            return this.getAccessTokenFromCache(lwaAccessTokenRequestMeta);
        }
        return this.getAccessTokenFromEndpoint(lwaAccessTokenRequestMeta);
    }

    String getAccessTokenFromCache(LWAAccessTokenRequestMeta lwaAccessTokenRequestMeta) throws LWAException {
        String accessTokenCacheData = this.lwaAccessTokenCache.get(lwaAccessTokenRequestMeta);
        if (accessTokenCacheData != null) {
            return accessTokenCacheData;
        }
        return this.getAccessTokenFromEndpoint(lwaAccessTokenRequestMeta);
    }

    String getAccessTokenFromEndpoint(LWAAccessTokenRequestMeta lwaAccessTokenRequestMeta) throws LWAException {
        String accessToken;
        RequestBody requestBody = RequestBody.create((MediaType)JSON_MEDIA_TYPE, (String)new Gson().toJson((Object)lwaAccessTokenRequestMeta));
        Request accessTokenRequest = new Request.Builder().url(this.endpoint).post(requestBody).build();
        Object lwaErrorCode = null;
        try {
            Response response = this.okHttpClient.newCall(accessTokenRequest).execute();
            ResponseBody body = response.body();
            if (body == null) {
                throw new LWAException(LWAExceptionErrorCode.other.toString(), "Error getting LWA Token", "Response body missing");
            }
            JsonObject responseJson = JsonParser.parseString((String)body.string()).getAsJsonObject();
            if (!response.isSuccessful()) {
                if (responseJson.has("error") && EnumUtils.isValidEnum(LWAExceptionErrorCode.class, (String)responseJson.get("error").getAsString())) {
                    throw new LWAException(responseJson.get("error").getAsString(), responseJson.get("error_description").getAsString(), "Error getting LWA Token");
                }
                throw new LWAException(LWAExceptionErrorCode.other.toString(), "Other LWA Exception", "Error getting LWA Token");
            }
            accessToken = responseJson.get(ACCESS_TOKEN_KEY).getAsString();
            if (this.lwaAccessTokenCache != null) {
                long timeToTokenexpiry = responseJson.get(ACCESS_TOKEN_EXPIRES_IN).getAsLong();
                this.lwaAccessTokenCache.put(lwaAccessTokenRequestMeta, accessToken, timeToTokenexpiry);
            }
        }
        catch (LWAException e) {
            throw new LWAException(e.getErrorCode(), e.getErrorMessage(), e.getMessage());
        }
        catch (Exception e) {
            throw new RuntimeException("Error getting LWA Token");
        }
        return accessToken;
    }

    @Generated
    public String getEndpoint() {
        return this.endpoint;
    }

    @Generated
    void setOkHttpClient(OkHttpClient okHttpClient) {
        this.okHttpClient = okHttpClient;
    }
}

