/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.tasks;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileTree;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.cocoapods.KotlinCocoapodsPluginKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.Framework;
import org.jetbrains.kotlin.gradle.tasks.FatFrameworkTask;
import org.jetbrains.kotlin.gradle.tasks.FatFrameworkTask$WhenMappings;
import org.jetbrains.kotlin.gradle.tasks.FatFrameworkTaskKt;
import org.jetbrains.kotlin.gradle.tasks.IosDsymFiles;
import org.jetbrains.kotlin.gradle.tasks.IosFrameworkFiles;
import org.jetbrains.kotlin.gradle.tasks.KotlinNativeTasksKt;
import org.jetbrains.kotlin.konan.target.Architecture;
import org.jetbrains.kotlin.konan.target.Family;
import org.jetbrains.kotlin.konan.target.KonanTarget;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001LB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u00104\u001a\u000205H\u0005J\u0018\u00106\u001a\u0002052\u0006\u00107\u001a\u00020\u000e2\u0006\u00108\u001a\u00020\bH\u0002J\u001f\u00109\u001a\u0002052\u0012\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060:\"\u00020\u0006\u00a2\u0006\u0002\u0010;J\u0014\u00109\u001a\u0002052\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00060&J\u0018\u0010<\u001a\n >*\u0004\u0018\u00010=0=2\u0006\u00107\u001a\u00020\u000eH\u0002J\b\u0010?\u001a\u000205H\u0002J\u0010\u0010@\u001a\u00020A2\u0006\u00107\u001a\u00020\u000eH\u0002J\u0018\u0010B\u001a\u0002052\u0006\u00107\u001a\u00020\u000e2\u0006\u00108\u001a\u00020\bH\u0002J5\u0010C\u001a\n >*\u0004\u0018\u00010=0=2\u0006\u0010D\u001a\u00020\u000e2\u001b\u0010E\u001a\u0017\u0012\b\u0012\u00060GR\u00020\u0000\u0012\u0004\u0012\u0002050F\u00a2\u0006\u0002\bHH\u0002J,\u0010I\u001a\n >*\u0004\u0018\u00010=0=2\u0012\u0010J\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000e0K2\u0006\u00107\u001a\u00020\u000eH\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001e\u0010\r\u001a\u00020\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u000e8G\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0010R\u0014\u0010\u0019\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u000e8G\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0010R\u0014\u0010\u001f\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\nR\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00060\"8G\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&8EX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u001a\u0010*\u001a\b\u0012\u0004\u0012\u00020'0&8EX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010)R\u0018\u0010,\u001a\u00020\b*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u0018\u0010/\u001a\u00020\b*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010.R\u0018\u00101\u001a\u00020\b*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00103\u00a8\u0006M"}, d2={"Lorg/jetbrains/kotlin/gradle/tasks/FatFrameworkTask;", "Lorg/gradle/api/DefaultTask;", "()V", "archToFramework", "", "Lorg/jetbrains/kotlin/konan/target/Architecture;", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/Framework;", "baseName", "", "getBaseName", "()Ljava/lang/String;", "setBaseName", "(Ljava/lang/String;)V", "destinationDir", "Ljava/io/File;", "getDestinationDir", "()Ljava/io/File;", "setDestinationDir", "(Ljava/io/File;)V", "fatDsym", "Lorg/jetbrains/kotlin/gradle/tasks/IosDsymFiles;", "getFatDsym", "()Lorg/jetbrains/kotlin/gradle/tasks/IosDsymFiles;", "fatDsymDir", "getFatDsymDir", "fatFramework", "Lorg/jetbrains/kotlin/gradle/tasks/IosFrameworkFiles;", "getFatFramework", "()Lorg/jetbrains/kotlin/gradle/tasks/IosFrameworkFiles;", "fatFrameworkDir", "getFatFrameworkDir", "fatFrameworkName", "getFatFrameworkName", "frameworks", "", "getFrameworks", "()Ljava/util/Collection;", "inputDsymFiles", "", "Lorg/gradle/api/file/FileTree;", "getInputDsymFiles", "()Ljava/lang/Iterable;", "inputFrameworkFiles", "getInputFrameworkFiles", "clangMacro", "getClangMacro", "(Lorg/jetbrains/kotlin/konan/target/Architecture;)Ljava/lang/String;", "lipoArg", "getLipoArg", "plistPlatform", "getPlistPlatform", "(Lorg/jetbrains/kotlin/gradle/plugin/mpp/Framework;)Ljava/lang/String;", "createFatFramework", "", "createModuleFile", "outputFile", "frameworkName", "from", "", "([Lorg/jetbrains/kotlin/gradle/plugin/mpp/Framework;)V", "mergeBinaries", "Lorg/gradle/process/ExecResult;", "kotlin.jvm.PlatformType", "mergeDSYM", "mergeHeaders", "", "mergePlists", "processPlist", "plist", "commands", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/gradle/tasks/FatFrameworkTask$PlistBuddyRunner;", "Lkotlin/ExtensionFunctionType;", "runLipo", "inputFiles", "", "PlistBuddyRunner", "kotlin-gradle-plugin"})
public class FatFrameworkTask
extends DefaultTask {
    @Input
    @NotNull
    private String baseName;
    @OutputDirectory
    @NotNull
    private File destinationDir;
    private final Map<Architecture, Framework> archToFramework;

    @Internal
    @NotNull
    public final Collection<Framework> getFrameworks() {
        return this.archToFramework.values();
    }

    @NotNull
    public final String getBaseName() {
        return this.baseName;
    }

    public final void setBaseName(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.baseName = string;
    }

    @NotNull
    public final File getDestinationDir() {
        return this.destinationDir;
    }

    public final void setDestinationDir(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"<set-?>");
        this.destinationDir = file;
    }

    @Internal
    @NotNull
    public final File getFatFrameworkDir() {
        return this.getFatFramework().getRootDir();
    }

    @Internal
    @NotNull
    public final File getFatDsymDir() {
        return this.getFatDsym().getRootDir();
    }

    private final String getFatFrameworkName() {
        return KotlinCocoapodsPluginKt.asValidFrameworkName(this.baseName);
    }

    private final IosFrameworkFiles getFatFramework() {
        return new IosFrameworkFiles(this.destinationDir, this.getFatFrameworkName());
    }

    private final IosDsymFiles getFatDsym() {
        return this.getFatFramework().getDSYM();
    }

    /*
     * WARNING - void declaration
     */
    @InputFiles
    @SkipWhenEmpty
    @NotNull
    protected final Iterable<FileTree> getInputFrameworkFiles() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getFrameworks();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Framework framework2 = (Framework)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ConfigurableFileTree configurableFileTree = this.getProject().fileTree((Object)it.getOutputFile());
            collection.add(configurableFileTree);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @InputFiles
    @NotNull
    protected final Iterable<FileTree> getInputDsymFiles() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.getFrameworks();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ConfigurableFileTree configurableFileTree;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Framework framework2 = (Framework)element$iv$iv;
            boolean bl2 = false;
            Object object = FatFrameworkTaskKt.access$getFiles$p(framework2).getDSYM();
            boolean bl3 = false;
            boolean bl4 = false;
            Object it = object;
            boolean bl5 = false;
            Object object2 = ((IosDsymFiles)it).exists() ? object : null;
            if (object2 != null && (object2 = ((IosDsymFiles)object2).getRootDir()) != null) {
                object = object2;
                bl3 = false;
                bl4 = false;
                it = object;
                boolean bl6 = false;
                configurableFileTree = this.getProject().fileTree(it);
            } else {
                configurableFileTree = null;
            }
            if (configurableFileTree == null) continue;
            ConfigurableFileTree configurableFileTree2 = configurableFileTree;
            boolean bl7 = false;
            boolean bl8 = false;
            ConfigurableFileTree it$iv$iv = configurableFileTree2;
            boolean bl9 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void from(Framework ... frameworks) {
        Intrinsics.checkParameterIsNotNull((Object)frameworks, (String)"frameworks");
        this.from(ArraysKt.toList((Object[])frameworks));
    }

    public final void from(@NotNull Iterable<Framework> frameworks) {
        Intrinsics.checkParameterIsNotNull(frameworks, (String)"frameworks");
        Iterable<Framework> $this$forEach$iv = frameworks;
        boolean $i$f$forEach = false;
        Iterator<Framework> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Framework element$iv;
            Framework it = element$iv = iterator.next();
            boolean bl = false;
            KonanTarget konanTarget = it.getTarget().getKonanTarget();
            Architecture arch = konanTarget.getArchitecture();
            boolean bl2 = konanTarget.getFamily() == Family.IOS;
            boolean bl3 = false;
            boolean bl4 = false;
            if (!bl2) {
                boolean bl5 = false;
                String string = "Cannot add a framework with target '" + konanTarget.getVisibleName() + "' to the fat framework: " + "fat frameworks are available only for iOS binaries.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            bl2 = !this.archToFramework.containsKey(arch);
            bl3 = false;
            bl4 = false;
            if (!bl2) {
                boolean bl6 = false;
                Framework alreadyAdded = (Framework)MapsKt.getValue(this.archToFramework, (Object)arch);
                String string = arch.name();
                StringBuilder stringBuilder = new StringBuilder().append("This fat framework already has a binary for architecture `");
                boolean bl7 = false;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.toLowerCase();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
                String string4 = string3;
                String string5 = stringBuilder.append(string4).append("` ").append('(').append(alreadyAdded.getName()).append(" for target `").append(alreadyAdded.getTarget().getName()).append("`)").toString();
                throw (Throwable)new IllegalArgumentException(string5.toString());
            }
            this.archToFramework.put(arch, it);
            this.dependsOn(new Object[]{it.getLinkTask()});
        }
    }

    private final String getLipoArg(@NotNull Architecture $receiver) {
        String string;
        switch (FatFrameworkTask$WhenMappings.$EnumSwitchMapping$0[$receiver.ordinal()]) {
            case 1: {
                string = "x86_64";
                break;
            }
            case 2: {
                string = "armv7";
                break;
            }
            case 3: {
                string = "arm64";
                break;
            }
            default: {
                String string2 = "Fat frameworks are not supported for architecture `" + $receiver.name() + '`';
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
        }
        return string;
    }

    private final String getClangMacro(@NotNull Architecture $receiver) {
        String string;
        switch (FatFrameworkTask$WhenMappings.$EnumSwitchMapping$1[$receiver.ordinal()]) {
            case 1: {
                string = "__x86_64__";
                break;
            }
            case 2: {
                string = "__arm__";
                break;
            }
            case 3: {
                string = "__aarch64__";
                break;
            }
            default: {
                String string2 = "Fat frameworks are not supported for architecture `" + $receiver.name() + '`';
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
        }
        return string;
    }

    private final String getPlistPlatform(@NotNull Framework $receiver) {
        String string;
        KonanTarget konanTarget = $receiver.getTarget().getKonanTarget();
        if (Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.IOS_ARM32.INSTANCE) || Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.IOS_ARM64.INSTANCE)) {
            string = "iPhoneOS";
        } else if (Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.IOS_X64.INSTANCE)) {
            string = "iPhoneSimulator";
        } else {
            String string2 = "Fat frameworks are not supported for target `" + $receiver.getTarget().getKonanTarget().getVisibleName() + '`';
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return string;
    }

    private final ExecResult processPlist(File plist, Function1<? super PlistBuddyRunner, Unit> commands) {
        PlistBuddyRunner plistBuddyRunner = new PlistBuddyRunner(plist);
        boolean bl = false;
        boolean bl2 = false;
        PlistBuddyRunner $receiver = plistBuddyRunner;
        boolean bl3 = false;
        commands.invoke((Object)$receiver);
        return plistBuddyRunner.run();
    }

    private final ExecResult runLipo(Map<Architecture, ? extends File> inputFiles, File outputFile2) {
        return this.getProject().exec((Action)new Action<ExecSpec>(this, inputFiles, outputFile2){
            final /* synthetic */ FatFrameworkTask this$0;
            final /* synthetic */ Map $inputFiles;
            final /* synthetic */ File $outputFile;

            public final void execute(ExecSpec it) {
                ExecSpec execSpec = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)execSpec, (String)"it");
                execSpec.setExecutable("/usr/bin/lipo");
                List list2 = CollectionsKt.mutableListOf((Object[])new String[]{"-create"});
                ExecSpec execSpec2 = it;
                boolean bl = false;
                boolean bl2 = false;
                List $receiver = list2;
                boolean bl3 = false;
                Map $this$forEach$iv = this.$inputFiles;
                boolean $i$f$forEach = false;
                Map map2 = $this$forEach$iv;
                boolean bl4 = false;
                Iterator<Map.Entry<K, V>> iterator = map2.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<K, V> element$iv;
                    Map.Entry<K, V> $dstr$arch$binary = element$iv = iterator.next();
                    boolean bl5 = false;
                    Map.Entry<K, V> entry = $dstr$arch$binary;
                    boolean bl6 = false;
                    Architecture arch = (Architecture)entry.getKey();
                    entry = $dstr$arch$binary;
                    bl6 = false;
                    File binary = (File)entry.getValue();
                    $receiver.addAll(CollectionsKt.listOf((Object[])new String[]{"-arch", FatFrameworkTask.access$getLipoArg$p(this.this$0, arch), binary.getAbsolutePath()}));
                }
                String string = this.$outputFile.getAbsolutePath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"outputFile.absolutePath");
                KotlinNativeTasksKt.addArg($receiver, "-output", string);
                List list3 = list2;
                execSpec2.setArgs(list3);
            }
            {
                this.this$0 = fatFrameworkTask2;
                this.$inputFiles = map2;
                this.$outputFile = file;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final ExecResult mergeBinaries(File outputFile2) {
        Map map2;
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Map<Architecture, Framework> map3 = this.archToFramework;
        FatFrameworkTask fatFrameworkTask2 = this;
        boolean $i$f$mapValues = false;
        void var4_5 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $dstr$_u24__u24$framework;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map4 = destination$iv$iv;
            boolean bl = false;
            Object k = it$iv$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            map2 = map4;
            boolean bl2 = false;
            void var17_18 = $dstr$_u24__u24$framework;
            boolean bl3 = false;
            Framework framework2 = (Framework)var17_18.getValue();
            File file = FatFrameworkTaskKt.access$getFiles$p(framework2).getBinary();
            map2.put(k2, file);
        }
        map2 = destination$iv$iv;
        return fatFrameworkTask2.runLipo(map2, outputFile2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Object mergeHeaders(File outputFile2) {
        Object object = outputFile2;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        Object object2 = object;
        boolean bl2 = false;
        object2 = new FileOutputStream((File)object2);
        bl2 = false;
        object = new OutputStreamWriter((OutputStream)object2, charset);
        boolean bl3 = false;
        Throwable throwable = null;
        try {
            Object object3;
            boolean bl4;
            void $this$mapValuesTo$iv$iv;
            OutputStreamWriter writer = (OutputStreamWriter)object;
            boolean bl5 = false;
            Map<Architecture, Framework> $this$mapValues$iv = this.archToFramework;
            boolean $i$f$mapValues = false;
            Map<Architecture, Framework> map2 = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void $dstr$_u24__u24$framework;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map3 = destination$iv$iv;
                boolean bl6 = false;
                Object k = it$iv$iv.getKey();
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k2 = k;
                Map map4 = map3;
                boolean bl7 = false;
                void var24_37 = $dstr$_u24__u24$framework;
                bl4 = false;
                Framework framework2 = (Framework)var24_37.getValue();
                String string = FilesKt.readText$default((File)FatFrameworkTaskKt.access$getFiles$p(framework2).getHeader(), null, (int)1, null);
                map4.put(k2, string);
            }
            Map headerContents = destination$iv$iv;
            if (CollectionsKt.distinct((Iterable)headerContents.values()).size() == 1) {
                writer.write((String)CollectionsKt.first((Iterable)headerContents.values()));
                object3 = Unit.INSTANCE;
            } else {
                Iterable $this$forEachIndexed$iv = MapsKt.toList((Map)headerContents);
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    CharSequence charSequence;
                    Appendable appendable;
                    void $dstr$arch$content;
                    Object element$iv$iv$iv;
                    int n = index$iv++;
                    boolean bl8 = false;
                    if (n < 0) {
                        throw (Throwable)new ArithmeticException("Index overflow has happened.");
                    }
                    int n2 = n;
                    element$iv$iv$iv = (Pair)item$iv;
                    int i2 = n2;
                    boolean bl9 = false;
                    Architecture arch = (Architecture)$dstr$arch$content.component1();
                    String content = (String)$dstr$arch$content.component2();
                    String macro = this.getClangMacro(arch);
                    if (i2 == 0) {
                        appendable = writer;
                        charSequence = "#if defined(" + macro + ")\n";
                        bl4 = false;
                        Appendable appendable2 = appendable.append(charSequence);
                        Intrinsics.checkExpressionValueIsNotNull((Object)appendable2, (String)"append(value)");
                        StringsKt.appendln((Appendable)appendable2);
                    } else {
                        appendable = writer;
                        charSequence = "#elif defined(" + macro + ")\n";
                        bl4 = false;
                        Appendable appendable3 = appendable.append(charSequence);
                        Intrinsics.checkExpressionValueIsNotNull((Object)appendable3, (String)"append(value)");
                        StringsKt.appendln((Appendable)appendable3);
                    }
                    appendable = writer;
                    boolean bl10 = false;
                    Appendable appendable4 = appendable.append(content);
                    Intrinsics.checkExpressionValueIsNotNull((Object)appendable4, (String)"append(value)");
                    StringsKt.appendln((Appendable)appendable4);
                }
                Appendable appendable = writer;
                CharSequence charSequence = StringsKt.trimIndent((String)"\n                #else\n                #error Unsupported platform\n                #endif\n                ");
                boolean bl11 = false;
                Appendable appendable5 = appendable.append(charSequence);
                Intrinsics.checkExpressionValueIsNotNull((Object)appendable5, (String)"append(value)");
                object3 = StringsKt.appendln((Appendable)appendable5);
            }
            object2 = object3;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        return object2;
    }

    private final void createModuleFile(File outputFile2, String frameworkName) {
        FilesKt.writeText$default((File)outputFile2, (String)StringsKt.trimIndent((String)("\n            framework module " + frameworkName + " {\n                umbrella header \"" + frameworkName + ".h\"\n\n                export *\n                module * { export * }\n            }\n        ")), null, (int)2, null);
    }

    private final void mergePlists(File outputFile2, String frameworkName) {
        Collection<Framework> collection = this.getFrameworks();
        boolean bl = false;
        boolean bl2 = !collection.isEmpty();
        bl = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl2) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        File baseInfo = FatFrameworkTaskKt.access$getFiles$p((Framework)CollectionsKt.first((Iterable)this.getFrameworks())).getInfoPlist();
        this.getProject().copy((Action)new Action<CopySpec>(baseInfo, outputFile2){
            final /* synthetic */ File $baseInfo;
            final /* synthetic */ File $outputFile;

            public final void execute(CopySpec it) {
                it.from(new Object[]{this.$baseInfo});
                it.into((Object)this.$outputFile.getParentFile());
            }
            {
                this.$baseInfo = file;
                this.$outputFile = file2;
            }
        });
        this.processPlist(outputFile2, (Function1<? super PlistBuddyRunner, Unit>)((Function1)mergePlists.2.INSTANCE));
        this.processPlist(outputFile2, (Function1<? super PlistBuddyRunner, Unit>)((Function1)new Function1<PlistBuddyRunner, Unit>(this, frameworkName){
            final /* synthetic */ FatFrameworkTask this$0;
            final /* synthetic */ String $frameworkName;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull PlistBuddyRunner $receiver) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                $receiver.set(":CFBundleExecutable", this.$frameworkName);
                $receiver.set(":CFBundleName", this.$frameworkName);
                $receiver.delete(":CFBundleSupportedPlatforms:0");
                Iterable $this$map$iv = this.this$0.getFrameworks();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Framework framework2 = (Framework)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    String string = FatFrameworkTask.access$getPlistPlatform$p(this.this$0, (Framework)it);
                    collection.add(string);
                }
                Iterable $this$forEachIndexed$iv = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (T item$iv : $this$forEachIndexed$iv) {
                    void platform;
                    int n = index$iv++;
                    boolean bl = false;
                    if (n < 0) {
                        throw (Throwable)new ArithmeticException("Index overflow has happened.");
                    }
                    int n2 = n;
                    String bl2 = (String)item$iv;
                    int index = n2;
                    boolean bl3 = false;
                    $receiver.add(":CFBundleSupportedPlatforms:" + index, (String)platform);
                }
            }
            {
                this.this$0 = fatFrameworkTask2;
                this.$frameworkName = string;
                super(1);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final void mergeDSYM() {
        IosDsymFiles iosDsymFiles;
        boolean bl;
        void var17_20;
        Map.Entry $dstr$_u24__u24$framework;
        Object object;
        Object object2;
        Object k;
        Map.Entry it$iv$iv;
        Map map2;
        void $this$mapValuesTo$iv$iv;
        Map<Architecture, Framework> $this$mapValues$iv = this.archToFramework;
        boolean $i$f$mapValues = false;
        Map<Architecture, Framework> map3 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Object $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean bl2 = false;
        Iterator iterator = $this$associateByTo$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv$iv = iterator.next();
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            map2 = destination$iv$iv;
            boolean bl22 = false;
            k = it$iv$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            object2 = k;
            object = map2;
            boolean bl3 = false;
            var17_20 = $dstr$_u24__u24$framework;
            bl = false;
            Framework framework2 = (Framework)var17_20.getValue();
            iosDsymFiles = FatFrameworkTaskKt.access$getFiles$p(framework2).getDSYM();
            object.put(object2, iosDsymFiles);
        }
        Map $this$filterValues$iv = destination$iv$iv;
        boolean $i$f$filterValues = false;
        Map<Object, Object> result$iv = new LinkedHashMap();
        destination$iv$iv = $this$filterValues$iv;
        $i$f$mapValuesTo = false;
        for (Map.Entry entry : destination$iv$iv.entrySet()) {
            IosDsymFiles it = (IosDsymFiles)entry.getValue();
            boolean bl4 = false;
            if (!it.exists()) continue;
            result$iv.put(entry.getKey(), entry.getValue());
        }
        Map dsymInputs = result$iv;
        if (dsymInputs.isEmpty()) {
            return;
        }
        this.getFatDsym().mkdirs();
        $this$filterValues$iv = dsymInputs;
        object = this;
        $i$f$mapValues = false;
        result$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        $i$f$mapValuesTo = false;
        $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean bl3 = false;
        iterator = $this$associateByTo$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            void $dstr$_u24__u24$dsym;
            Object element$iv$iv$iv = iterator.next();
            it$iv$iv = (Map.Entry)element$iv$iv$iv;
            map2 = destination$iv$iv;
            boolean bl4 = false;
            k = it$iv$iv.getKey();
            $dstr$_u24__u24$framework = (Map.Entry)element$iv$iv$iv;
            iosDsymFiles = k;
            object2 = map2;
            boolean bl5 = false;
            var17_20 = $dstr$_u24__u24$dsym;
            bl = false;
            IosDsymFiles dsym = (IosDsymFiles)var17_20.getValue();
            File file = dsym.getBinary();
            object2.put((IosDsymFiles)iosDsymFiles, (File)file);
        }
        object2 = destination$iv$iv;
        super.runLipo((Map<Architecture, ? extends File>)object2, this.getFatDsym().getBinary());
        this.getProject().copy((Action)new Action<CopySpec>(this, dsymInputs){
            final /* synthetic */ FatFrameworkTask this$0;
            final /* synthetic */ Map $dsymInputs;

            public final void execute(CopySpec it) {
                it.from(new Object[]{((IosDsymFiles)CollectionsKt.first((Iterable)this.$dsymInputs.values())).getInfoPlist()});
                it.into((Object)FatFrameworkTask.access$getFatDsym$p(this.this$0).getInfoPlist().getParentFile());
            }
            {
                this.this$0 = fatFrameworkTask2;
                this.$dsymInputs = map2;
            }
        });
    }

    @TaskAction
    protected final void createFatFramework() {
        this.getFatFramework().mkdirs();
        String frameworkName = this.getFatFramework().getFrameworkName();
        this.mergeBinaries(this.getFatFramework().getBinary());
        this.mergeHeaders(this.getFatFramework().getHeader());
        this.createModuleFile(this.getFatFramework().getModuleFile(), frameworkName);
        this.mergePlists(this.getFatFramework().getInfoPlist(), frameworkName);
        this.mergeDSYM();
    }

    public FatFrameworkTask() {
        Map map2;
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        String string = project.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.name");
        this.baseName = string;
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        File file = project2.getBuildDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.buildDir");
        this.destinationDir = FilesKt.resolve((File)file, (String)"fat-framework");
        FatFrameworkTask fatFrameworkTask2 = this;
        boolean bl = false;
        fatFrameworkTask2.archToFramework = map2 = (Map)new LinkedHashMap();
    }

    public static final /* synthetic */ String access$getLipoArg$p(FatFrameworkTask $this, Architecture $receiver) {
        return $this.getLipoArg($receiver);
    }

    public static final /* synthetic */ String access$getPlistPlatform$p(FatFrameworkTask $this, Framework $receiver) {
        return $this.getPlistPlatform($receiver);
    }

    public static final /* synthetic */ IosDsymFiles access$getFatDsym$p(FatFrameworkTask $this) {
        return $this.getFatDsym();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0007J\u000e\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0007J\u000e\u0010\u0016\u001a\n \u0018*\u0004\u0018\u00010\u00170\u0017J\u0016\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0007R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/gradle/tasks/FatFrameworkTask$PlistBuddyRunner;", "", "plist", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/gradle/tasks/FatFrameworkTask;Ljava/io/File;)V", "commands", "", "", "getCommands", "()Ljava/util/List;", "ignoreExitValue", "", "getIgnoreExitValue", "()Z", "setIgnoreExitValue", "(Z)V", "getPlist", "()Ljava/io/File;", "add", "entry", "value", "delete", "run", "Lorg/gradle/process/ExecResult;", "kotlin.jvm.PlatformType", "set", "kotlin-gradle-plugin"})
    private final class PlistBuddyRunner {
        @NotNull
        private final List<String> commands;
        private boolean ignoreExitValue;
        @NotNull
        private final File plist;

        @NotNull
        public final List<String> getCommands() {
            return this.commands;
        }

        public final boolean getIgnoreExitValue() {
            return this.ignoreExitValue;
        }

        public final void setIgnoreExitValue(boolean bl) {
            this.ignoreExitValue = bl;
        }

        public final ExecResult run() {
            return FatFrameworkTask.this.getProject().exec((Action)new Action<ExecSpec>(this){
                final /* synthetic */ PlistBuddyRunner this$0;

                public final void execute(ExecSpec exec) {
                    ExecSpec execSpec = exec;
                    Intrinsics.checkExpressionValueIsNotNull((Object)execSpec, (String)"exec");
                    execSpec.setExecutable("/usr/libexec/PlistBuddy");
                    Iterable $this$forEach$iv = this.this$0.getCommands();
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        String it = (String)element$iv;
                        boolean bl = false;
                        exec.args(new Object[]{"-c", it});
                    }
                    exec.args(new Object[]{this.this$0.getPlist().getAbsolutePath()});
                    exec.setIgnoreExitValue(this.this$0.getIgnoreExitValue());
                    ByteArrayOutputStream dummyStream = new ByteArrayOutputStream();
                    exec.setStandardOutput((OutputStream)dummyStream);
                    exec.setErrorOutput((OutputStream)dummyStream);
                }
                {
                    this.this$0 = plistBuddyRunner;
                }
            });
        }

        public final boolean add(@NotNull String entry, @NotNull String value) {
            Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            return this.commands.add("Add \"" + entry + "\" string \"" + value + '\"');
        }

        public final boolean set(@NotNull String entry, @NotNull String value) {
            Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            return this.commands.add("Set \"" + entry + "\" \"" + value + '\"');
        }

        public final boolean delete(@NotNull String entry) {
            Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
            return this.commands.add("Delete \"" + entry + '\"');
        }

        @NotNull
        public final File getPlist() {
            return this.plist;
        }

        public PlistBuddyRunner(File plist) {
            List list2;
            Intrinsics.checkParameterIsNotNull((Object)plist, (String)"plist");
            this.plist = plist;
            PlistBuddyRunner plistBuddyRunner = this;
            boolean bl = false;
            plistBuddyRunner.commands = list2 = (List)new ArrayList();
        }
    }
}

