/*
 * Decompiled with CFR 0.152.
 */
package ellax.scroll;

import android.view.ViewTreeObserver;
import android.widget.ScrollView;
import ellax.scroll.ScrollProgressChangeListener;
import java.util.HashSet;
import java.util.Set;

public class ScrollViewScrollHelper
implements ViewTreeObserver.OnScrollChangedListener {
    private ScrollView mScrollView;
    private int factor;
    private Set<ScrollProgressChangeListener> mProgressListeners;

    public ScrollViewScrollHelper(ScrollView scrollView, int factor) {
        this.mScrollView = scrollView;
        this.mScrollView.getViewTreeObserver().addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
        this.factor = factor;
    }

    public void setFactor(int factor) {
        this.factor = factor;
    }

    public void onScrollChanged() {
        if (this.factor > 0) {
            this.mScrollView.post(new Runnable(){

                @Override
                public void run() {
                    int scrollY = ScrollViewScrollHelper.this.mScrollView.getScrollY();
                    scrollY = Math.max(0, scrollY);
                    float percent = (float)scrollY * 1.0f / (float)ScrollViewScrollHelper.this.factor;
                    percent = Math.min(percent, 1.0f);
                    ScrollViewScrollHelper.this.dispatch(percent, (int)(percent * 100.0f), (int)(percent * 255.0f));
                }
            });
        }
    }

    public void remove() {
        this.mScrollView.getViewTreeObserver().removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
    }

    private void dispatch(float percent, int pi, int pa) {
        if (this.mProgressListeners != null) {
            for (ScrollProgressChangeListener listener : this.mProgressListeners) {
                listener.onScrollProgressChanged(percent, pi, pa);
            }
        }
    }

    public void addListener(ScrollProgressChangeListener listener) {
        if (this.mProgressListeners == null) {
            this.mProgressListeners = new HashSet<ScrollProgressChangeListener>();
        }
        this.mProgressListeners.add(listener);
    }
}

