/*
 * Decompiled with CFR 0.152.
 */
package ellax.scroll;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import androidx.recyclerview.widget.LinearLayoutManager;

public class SaveStateLinearLayoutManager
extends LinearLayoutManager {
    public OnInstanceStateListener mListener;

    public SaveStateLinearLayoutManager(Context context) {
        super(context);
    }

    public SaveStateLinearLayoutManager(Context context, int orientation, boolean reverseLayout) {
        super(context, orientation, reverseLayout);
    }

    public SaveStateLinearLayoutManager(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    public Parcelable onSaveInstanceState() {
        LinearLayoutManager.SavedState savedState = (LinearLayoutManager.SavedState)super.onSaveInstanceState();
        return new ScrollerSavedState(savedState, this.mListener == null ? 0 : this.mListener.onSaveInstanceState());
    }

    public void setOnInstanceStateListener(OnInstanceStateListener onInstanceStateListener) {
        this.mListener = onInstanceStateListener;
    }

    public void onRestoreInstanceState(Parcelable state) {
        super.onRestoreInstanceState(state);
        if (state instanceof ScrollerSavedState && this.mListener != null) {
            this.mListener.onRestoreInstanceState(((ScrollerSavedState)state).getScroller());
        }
    }

    public static class ScrollerSavedState
    extends LinearLayoutManager.SavedState {
        private int mScroller;
        public static final Parcelable.Creator<ScrollerSavedState> CREATOR = new Parcelable.Creator<ScrollerSavedState>(){

            public ScrollerSavedState createFromParcel(Parcel in) {
                LinearLayoutManager.SavedState savedState = (LinearLayoutManager.SavedState)LinearLayoutManager.SavedState.CREATOR.createFromParcel(in);
                return new ScrollerSavedState(savedState, in.readInt());
            }

            public ScrollerSavedState[] newArray(int size) {
                return new ScrollerSavedState[size];
            }
        };

        @SuppressLint(value={"RestrictedApi"})
        public ScrollerSavedState(LinearLayoutManager.SavedState savedState, int scroller) {
            super(savedState);
            this.mScroller = scroller;
        }

        @SuppressLint(value={"RestrictedApi"})
        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.mScroller);
        }

        public int getScroller() {
            return this.mScroller;
        }
    }

    public static interface OnInstanceStateListener {
        public int onSaveInstanceState();

        public void onRestoreInstanceState(int var1);
    }
}

