/*
 * Decompiled with CFR 0.152.
 */
package ellax.scroll;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

public class RecyclerViewScrollToPositionHelper {
    private RecyclerView mRecyclerView;
    private boolean mShouldScroll = false;
    private int mToPosition;
    private ActualScrollListener mOutScrollListener;

    public RecyclerViewScrollToPositionHelper(RecyclerView recyclerView) {
        this.mRecyclerView = recyclerView;
        this.mRecyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                super.onScrollStateChanged(recyclerView, newState);
                if (RecyclerViewScrollToPositionHelper.this.mShouldScroll && 0 == newState) {
                    RecyclerViewScrollToPositionHelper.this.mShouldScroll = false;
                    RecyclerViewScrollToPositionHelper.this.smoothMoveToPosition(RecyclerViewScrollToPositionHelper.this.mToPosition);
                } else if (!RecyclerViewScrollToPositionHelper.this.mShouldScroll && 0 == newState && RecyclerViewScrollToPositionHelper.this.mOutScrollListener != null) {
                    RecyclerViewScrollToPositionHelper.this.mOutScrollListener.scrollEnd(recyclerView);
                }
            }

            public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                if (RecyclerViewScrollToPositionHelper.this.mOutScrollListener != null) {
                    RecyclerViewScrollToPositionHelper.this.mOutScrollListener.onScrolled(recyclerView, dx, dy);
                }
            }
        });
    }

    public void setActualScrollListener(ActualScrollListener listener) {
        this.mOutScrollListener = listener;
    }

    public void smoothMoveToPosition(int position) {
        if (!(this.mRecyclerView.getLayoutManager() instanceof LinearLayoutManager)) {
            return;
        }
        int firstItem = this.findFirstItemPosition(this.mRecyclerView);
        int lastItem = this.findLastItemPosition(this.mRecyclerView);
        if (position < firstItem) {
            this.mRecyclerView.smoothScrollToPosition(position);
        } else if (position <= lastItem) {
            int movePosition = position - firstItem;
            if (movePosition >= 0 && movePosition < this.mRecyclerView.getChildCount()) {
                int top = this.mRecyclerView.getChildAt(movePosition).getTop();
                this.mRecyclerView.smoothScrollBy(0, top);
            }
        } else {
            this.mRecyclerView.smoothScrollToPosition(position);
            this.mToPosition = position;
            this.mShouldScroll = true;
        }
    }

    public void moveToPosition(int position) {
        if (!(this.mRecyclerView.getLayoutManager() instanceof LinearLayoutManager)) {
            return;
        }
        LinearLayoutManager manager = (LinearLayoutManager)this.mRecyclerView.getLayoutManager();
        int firstItem = manager.findFirstVisibleItemPosition();
        int lastItem = manager.findLastVisibleItemPosition();
        if (position <= firstItem) {
            this.mRecyclerView.scrollToPosition(position);
        } else if (position <= lastItem) {
            int top = this.mRecyclerView.getChildAt(position - firstItem).getTop();
            this.mRecyclerView.scrollBy(0, top);
        } else {
            this.mRecyclerView.scrollToPosition(position);
        }
    }

    private int findFirstItemPosition(RecyclerView recyclerView) {
        return recyclerView.getChildLayoutPosition(this.mRecyclerView.getChildAt(0));
    }

    private int findLastItemPosition(RecyclerView recyclerView) {
        return recyclerView.getChildLayoutPosition(this.mRecyclerView.getChildAt(this.mRecyclerView.getChildCount() - 1));
    }

    public static interface ActualScrollListener {
        public void scrollEnd(RecyclerView var1);

        public void onScrolled(@NonNull RecyclerView var1, int var2, int var3);
    }
}

