/*
 * Decompiled with CFR 0.152.
 */
package ellax.scroll;

import android.util.Log;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import ellax.scroll.SaveStateLinearLayoutManager;
import ellax.scroll.ScrollProgressChangeListener;
import java.util.HashSet;
import java.util.Set;

public class RecyclerViewScrollHelper
extends RecyclerView.OnScrollListener {
    private RecyclerView mRecyclerView;
    private int factor;
    private int scrollD;
    private boolean vertical;
    private Set<ScrollProgressChangeListener> mProgressListeners;

    public RecyclerViewScrollHelper(RecyclerView recyclerView) {
        this(recyclerView, 0);
    }

    public RecyclerViewScrollHelper(RecyclerView recyclerView, int factor) {
        this.mRecyclerView = recyclerView;
        if (this.mRecyclerView.getLayoutManager() == null) {
            throw new IllegalStateException("layout manager is null");
        }
        if (!(this.mRecyclerView.getLayoutManager() instanceof LinearLayoutManager)) {
            throw new IllegalArgumentException("not support");
        }
        this.vertical = ((LinearLayoutManager)this.mRecyclerView.getLayoutManager()).getOrientation() == 1;
        this.mRecyclerView.addOnScrollListener((RecyclerView.OnScrollListener)this);
        this.factor = factor;
        if (this.mRecyclerView.getLayoutManager() instanceof SaveStateLinearLayoutManager) {
            ((SaveStateLinearLayoutManager)this.mRecyclerView.getLayoutManager()).setOnInstanceStateListener(new SaveStateLinearLayoutManager.OnInstanceStateListener(){

                @Override
                public int onSaveInstanceState() {
                    return RecyclerViewScrollHelper.this.scrollD;
                }

                @Override
                public void onRestoreInstanceState(int distance) {
                    RecyclerViewScrollHelper.this.scrollD = distance;
                    RecyclerViewScrollHelper.this.mRecyclerView.post(new Runnable(){

                        @Override
                        public void run() {
                            int position = ((SaveStateLinearLayoutManager)RecyclerViewScrollHelper.this.mRecyclerView.getLayoutManager()).findFirstVisibleItemPosition();
                            int top = 0;
                            View topView = RecyclerViewScrollHelper.this.mRecyclerView.getLayoutManager().getChildAt(0);
                            if (topView != null) {
                                top = topView.getTop();
                            }
                            if (position < 0 || position == 0 && top == 0) {
                                RecyclerViewScrollHelper.this.scrollD = 0;
                            }
                        }
                    });
                }
            });
        } else {
            Log.w((String)"ScrollHelper", (String)"Layoutmanager are not SaveStateLinearLayoutManager");
        }
    }

    public void setFactor(int factor) {
        this.factor = factor;
        this.onScrolled(this.mRecyclerView, 0, 0);
    }

    public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
        this.scrollD += this.vertical ? dy : dx;
        if (this.factor > 0) {
            this.mRecyclerView.post(new Runnable(){

                @Override
                public void run() {
                    float percent = (float)RecyclerViewScrollHelper.this.scrollD * 1.0f / (float)RecyclerViewScrollHelper.this.factor;
                    percent = Math.min(percent, 1.0f);
                    percent = Math.max(0.0f, percent);
                    RecyclerViewScrollHelper.this.dispatch(percent, (int)(percent * 100.0f), (int)(percent * 255.0f));
                }
            });
        }
    }

    public void dispatch(float percent, int pi, int pa) {
        if (this.mProgressListeners != null) {
            for (ScrollProgressChangeListener listener : this.mProgressListeners) {
                listener.onScrollProgressChanged(percent, pi, pa);
            }
        }
    }

    public void addListener(ScrollProgressChangeListener listener) {
        if (this.mProgressListeners == null) {
            this.mProgressListeners = new HashSet<ScrollProgressChangeListener>();
        }
        this.mProgressListeners.add(listener);
    }

    public void remove() {
        this.mRecyclerView.removeOnScrollListener((RecyclerView.OnScrollListener)this);
    }
}

