package ellax.request.util;

import com.google.gson.internal.$Gson$Types;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

/**
 * Created by dongdaqing on 2018/4/8.
 */
public class TokenHelper {
    public static Type getSourceType(Class<?> clazz) {
        String clsName = clazz.getName();
        if (clsName.startsWith("android.") || clsName.startsWith("java."))
            return Object.class;
        Type superType = clazz.getGenericSuperclass();
        if (superType instanceof ParameterizedType) {
            return getSuperclassTypeParameter(clazz, 0);
        } else {
            return getSourceType(clazz.getSuperclass());
        }
    }

    public static Type getTargetType(Class<?> clazz) {
        String clsName = clazz.getName();
        if (clsName.startsWith("android.") || clsName.startsWith("java."))
            return Object.class;
        Type superType = clazz.getGenericSuperclass();
        if (superType instanceof ParameterizedType) {
            int gl = ((ParameterizedType) superType).getActualTypeArguments().length;
            if (gl == 1) {
                //simple callback
                return getSuperclassTypeParameter(clazz, 0);
            } else if (gl == 2) {
                //transfer callback
                return getSuperclassTypeParameter(clazz, 1);
            } else {
                throw new RuntimeException("unrecognized callback type:" + clazz.getName());
            }
        } else {
            return getTargetType(clazz.getSuperclass());
        }
    }

    private static Type getSuperclassTypeParameter(Class<?> subclass, int index) {
        Type superclass = subclass.getGenericSuperclass();
        if (superclass instanceof Class) {
            throw new RuntimeException("Missing type parameter.");
        }
        ParameterizedType parameterized = (ParameterizedType) superclass;
        return $Gson$Types.canonicalize(parameterized.getActualTypeArguments()[index]);
    }
}
