package ellax.request.util;

import androidx.annotation.NonNull;
import ellax.base.IProgress;

import java.io.IOException;
import java.io.InputStream;

/**
 * Created by dongdaqing on 2018/4/3.
 *
 * 监听解析端数据读取，用作下载进度
 */
public class DelegateStream extends InputStream {
    private IProgress mProgress;
    private InputStream realStream;
    private long totalLength;
    private long current;
    private String tag;

    public static InputStream getStream(IProgress progress, InputStream realStream, long totalLength, String tag) {
        if (progress == null || totalLength == 0)
            return realStream;
        return new DelegateStream(progress, realStream, totalLength, tag);
    }

    private DelegateStream(IProgress progress, InputStream realStream, long totalLength, String tag) {
        mProgress = progress;
        this.realStream = realStream;
        this.totalLength = totalLength;
        this.current = 0;
        this.tag = tag;
    }

    @Override
    public int read() throws IOException {
        int tmp = realStream.read();
        current += tmp;
        mProgress.update(current, totalLength, cal(), tag);
        return tmp;
    }

    @Override
    public int read(@NonNull byte[] b) throws IOException {
        int tmp = realStream.read(b);
        current += tmp;
        mProgress.update(current, totalLength, cal(), tag);
        return tmp;
    }

    @Override
    public int read(@NonNull byte[] b, int off, int len) throws IOException {
        int tmp = realStream.read(b, off, len);
        current += tmp;
        mProgress.update(current, totalLength, cal(), tag);
        return tmp;
    }

    @Override
    public long skip(long n) throws IOException {
        return realStream.skip(n);
    }

    @Override
    public int available() throws IOException {
        return realStream.available();
    }

    @Override
    public void close() throws IOException {
        realStream.close();
    }

    @Override
    public void mark(int readlimit) {
        realStream.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        realStream.reset();
    }

    @Override
    public boolean markSupported() {
        return realStream.markSupported();
    }

    private float cal() {
        return current * 1.0f / totalLength;
    }
}

