package ellax.request.parser;

import java.io.InputStream;
import java.util.Map;

/**
 * Created by dongdaqing on 2018/4/2.
 * 数据解析器，用于解析服务端传回来的数据
 */
public interface Parser {
    /**
     * 解析服务端传回的数据
     * @param is
     * @param extras
     * @param length 数据的总长度，从response head 里面取出，获取失败时为-1
     * @return 解析出的结果，null 表示为解析出结果
     * @throws ParseException 解析的过程出现了错误
     */
    Object parse(InputStream is, Map<String, String> extras, long length) throws ParseException;
}
