package ellax.request.parser;

import ellax.base.error.Error;
import ellax.base.error.ErrorFactory;
import ellax.base.error.ErrorTypes;
import ellax.request.util.IOUtil;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

/**
 * Created by dongdaqing on 2018/4/2.
 * 单线程文件下载
 */
public class FileParser implements Parser {
    //传入的文件路径包含文件名：/storage/emulated/0/Android/data/com.ellabook/cache/apk/ellabook-v2.0.5.apk
    public static final String FILE_PATH = "parser.FILE_PATH";

    @Override
    public Object parse(InputStream is, Map<String, String> extras, long length) throws ParseException {
        String path = extras.get(FILE_PATH);
        if (path == null)
            throw new ParseException(new Error(ErrorTypes.PARSE_FAILED, "file path is null"));
        File file = new File(path);
        File tmp = new File(file.getParentFile(), file.getName() + ".tmp");

        if (tmp.exists() && !tmp.delete()) {
            throw new ParseException(ErrorFactory.parseFailed("failed to delete tmp file:" + tmp.getPath()));
        }
        FileOutputStream fos = null;
        try {
            if (!tmp.createNewFile()) {
                throw new ParseException(ErrorFactory.parseFailed("failed to create file:" + tmp.getPath()));
            }

            fos = new FileOutputStream(tmp);
            byte[] buffer = new byte[8096];
            int c;
            while ((c = is.read(buffer)) != -1) {
                fos.write(buffer, 0, c);
            }
            if (!tmp.renameTo(file)) {
                throw new ParseException(ErrorFactory.parseFailed("failed to rename file:" + tmp.getPath()));
            }
            return file;
        } catch (IOException e) {
            throw new ParseException(ErrorFactory.getError(e));
        } finally {
            IOUtil.close(fos);
        }
    }
}
