package ellax.request.parser;

import com.google.gson.Gson;
import ellax.base.Callback;
import ellax.base.error.Error;
import ellax.base.error.ErrorTypes;
import org.json.JSONException;
import org.json.JSONObject;

import java.lang.reflect.Type;

// @formatter:off

/**
 * Created by dongdaqing on 2018/4/9.
 * 多级json解析
 * eg：
 * {
 *     code:"xxx"
 *     message:"xxx"
 *     status:"xxx"
 *     data:{
 *         key1:"xxx"
 *         key2:"xxx"
 *         key3:{
 *             xxxxxx
 *         }
 *     }
 * }
 * 上述json中如果只想解析key3的内容可以传入key值来进行解析
 */
// @formatter:on
public class EmbeddedJsonParser extends JsonParser {
    private String[] keys;

    public EmbeddedJsonParser(Callback<String> callback, String... keys) {
        super(callback);
        this.keys = keys;
    }
    public EmbeddedJsonParser(String... keys) {
        this(null, keys);
    }

    @Override
    protected Object parseData(String data2Parse, Type type) throws ParseException {
        if (keys == null)
            super.parseData(data2Parse, type);
        else {
            try {
                for (int i = 0; i < keys.length; i++) {
                    JSONObject object = new JSONObject(data2Parse);
                    data2Parse = object.getString(keys[i]);
                }
                return new Gson().fromJson(data2Parse, type);
            } catch (JSONException e) {
                throw new ParseException(new Error(ErrorTypes.PARSE_FAILED, "failed to convert data:" + data2Parse + " to json"));
            }
        }
        return null;
    }
}
