package ellax.request.datasource;

import ellax.base.helper.AppExecutors;
import ellax.request.Params;
import ellax.request.Request;
import ellax.request.response.ResponseListener;

/**
 * created by dongdaqing 19-3-20 下午3:22
 */
public class DataSourceDelegate implements IDataSource {
    private IDataSource mDataSource;

    public DataSourceDelegate(IDataSource dataSource) {
        mDataSource = dataSource;
    }

    @Override
    public void request(final Params params, final Request<Object> request) {
        AppExecutors.networkIO(new Runnable() {
            @Override
            public void run() {
                mDataSource.request(params, request);
            }
        });
    }

    @Override
    public void cancel(Object tag) {
        mDataSource.cancel(tag);
    }

    @Override
    public boolean haveSameTag(Object tag) {
        return mDataSource.haveSameTag(tag);
    }

    @Override
    public void setResponseListener(ResponseListener responseListener) {
        mDataSource.setResponseListener(responseListener);
    }
}
