package ellax.request.datasource;

import ellax.base.error.Error;

/**
 * created by dongdaqing 19-3-20 下午3:26
 */
public class BasicErrorMaker implements ErrorMaker {

    private int sleepTime;
    private int errorTypes;
    private Error mError;

    public BasicErrorMaker(int sleepTime, int errorTypes) {
        this.sleepTime = sleepTime;
        this.errorTypes = errorTypes;
    }

    public BasicErrorMaker(int sleepTime, Error error) {
        this.sleepTime = sleepTime;
        mError = error;
    }

    @Override
    public Error makeError() {
        try {
            Thread.sleep(sleepTime);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }

        if (mError != null)
            return mError;

        return new Error(errorTypes);
    }
}
