package ellax.request.cache;

import com.google.gson.Gson;
import ellax.base.Callback;
import ellax.base.helper.AppExecutors;

import java.lang.reflect.Type;

/**
 * created by dongdaqing 19-3-4 上午11:40
 */
public class NormalCache<T> implements Cache<T> {
    private T mCache;

    private Type mType;

    public NormalCache(Type type) {
        mType = type;
    }

    @Override
    public void query(String cacheKey, final Callback<T> request) {
        /**
         * 注意，修改data的值会导致内存缓存中的值也会发生变化
         */
        T data = mCache;
        if (data == null) {
            AppExecutors.diskIO(new Query<>(mType, cacheKey, new Callback<T>() {
                @Override
                public void callback(T data) {
                    mCache = data;
                    request.callback(data);
                }
            }));
        } else {
            request.callback(data);
        }
    }

    @Override
    public void update(String cacheKey, T data, boolean clear) {
        mCache = data;
        AppExecutors.diskIO(new Update(cacheKey, new Gson().toJson(mCache)));
    }
}
