package ellax.request.cache;

import com.google.gson.Gson;
import com.google.gson.internal.$Gson$Types;
import ellax.base.Callback;
import ellax.base.helper.AppExecutors;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

/**
 * created by dongdaqing 19-3-4 下午5:56
 */
public class ListCache<T> implements Cache<List<T>> {

    private List<T> mList;
    private Type mType;

    public ListCache(Type type) {
        mType = $Gson$Types.newParameterizedTypeWithOwner(null, List.class, type);
    }

    @Override
    public void query(String cacheKey, final Callback<List<T>> request) {
        if (mList == null) {
            AppExecutors.diskIO(new Query<>(mType, cacheKey, new Callback<List<T>>() {
                @Override
                public void callback(List<T> data) {
                    if (data != null) {
                        mList = new ArrayList<>(data);
                        request.callback(new ArrayList<>(data));
                    } else {
                        request.callback(null);
                    }
                }
            }));
        } else {
            request.callback(new ArrayList<>(mList));
        }
    }

    @Override
    public synchronized void update(String cacheKey, List<T> data, boolean clear) {
        if (clear && mList != null) {
            mList.clear();
        }

        if (mList == null) {
            mList = new ArrayList<>(data);
        } else {
            mList.addAll(data);
        }

        AppExecutors.diskIO(new Update(cacheKey, new Gson().toJson(mList)));
    }
}
