package ellax.request.cache;

import androidx.annotation.WorkerThread;
import android.util.Base64;
import android.util.Log;

import java.io.*;

/**
 * created by dongdaqing 19-3-4 下午4:52
 */
class DiskCache {

    @WorkerThread
    static String query(String key) {
        File dir = new File(CacheCenter.getContext().getFilesDir(), "xp");
        File file = new File(dir, key);

        if (!file.exists())
            return null;

        return new String(Base64.decode(readFromFile(file), Base64.DEFAULT));
    }

    @WorkerThread
    static void update(String key, String o) {
        File dir = new File(CacheCenter.getContext().getFilesDir(), "xp");
        if (!dir.exists() && !dir.mkdirs()) {
            Log.e("xrequest", "unable to create dir");
            return;
        }
        File file = new File(dir, key);
        writeToFile(file, o);
    }

    private static String readFromFile(File file) {
        try {
            StringBuilder builder = new StringBuilder();
            FileReader reader = new FileReader(file);
            char[] chars = new char[1024];
            int count;
            do {
                count = reader.read(chars);
                if (count != -1) {
                    builder.append(chars, 0, count);
                }
            }
            while (count != -1);
            reader.close();
            return builder.toString();
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static void writeToFile(File file, String obj) {
        try {

            if (!file.exists() && !file.createNewFile()) {
                Log.e("xrequest", "unable to create record file");
            }

            FileWriter writer = new FileWriter(file);
            writer.write(Base64.encodeToString(obj.getBytes(), Base64.DEFAULT));
            writer.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
}
