package ellax.request.cache;

import com.google.gson.reflect.TypeToken;
import ellax.request.Params;

import java.lang.reflect.Type;
import java.util.List;

/**
 * created by dongdaqing 19-3-4 上午10:42
 * 缓存参数
 */
public final class CacheParam {
    public static final int CACHE_TYPE_AUTO = -1;
    public static final int CACHE_TYPE_NORMAL = 2;//数据类型是非列表，会使用NormalCache创建缓存
    public static final int CACHE_TYPE_LIST = 3;//数据类型是列表，会使用ListCache创建缓存

    private CacheKeyGenerator mCacheKeyGenerator;
    private String cacheKey;//缓存的key值
    private Type mType;//缓存数据的类型
    private int cacheType = CACHE_TYPE_AUTO;//缓存数据type

    private boolean readFromCache;//是否读缓存
    private boolean writeToCache;//是否写缓存
    private boolean clearBeforeUpdate;//更新缓存之前清空旧缓存
    private boolean discardDirtyCache;//true：不返回脏缓存，false：返回dirty缓存

    public CacheParam() {
        readFromCache = true;//默认读缓存
        writeToCache = true;//默认写缓存
        clearBeforeUpdate = true;//默认清空旧数据
        discardDirtyCache = false;//默认返回脏数据
    }

    public CacheParam(boolean readFromCache, boolean writeToCache, boolean clearBeforeUpdate) {
        this.readFromCache = readFromCache;
        this.writeToCache = writeToCache;
        this.clearBeforeUpdate = clearBeforeUpdate;
        this.discardDirtyCache = false;
    }

    public CacheParam(boolean readFromCache, boolean writeToCache, boolean clearBeforeUpdate, boolean discardDirtyCache) {
        this.readFromCache = readFromCache;
        this.writeToCache = writeToCache;
        this.clearBeforeUpdate = clearBeforeUpdate;
        this.discardDirtyCache = discardDirtyCache;
    }

    public void setCacheKeyGenerator(CacheKeyGenerator cacheKeyGenerator) {
        mCacheKeyGenerator = new CacheKeyMd5Encoder(cacheKeyGenerator);
    }

    /**
     * 大部分情况下不需要调用{@link #listType(),#listType(Class),#normalType(),#normalType(Class)}
     * 这四个方法的任意一个，因为泛型的类型可以推断出来。当然，如果在调用层对{@link ellax.request.callback.SimpleCallback}或者是对{@link ellax.request.callback.TransferCallback}
     * 进行了二次封装，那么可能会获取不到真实的数据类型，这种情况下旧必须条用这几个方法中的一个来设置数据类型
     * @return
     */
    public CacheParam listType() {
        cacheType = CACHE_TYPE_LIST;
        return this;
    }

    public CacheParam listType(Class type) {
        cacheType = CACHE_TYPE_LIST;
        mType = TypeToken.getParameterized(List.class, type).getType();
        return this;
    }

    public CacheParam normalType() {
        cacheType = CACHE_TYPE_NORMAL;
        return this;
    }

    public CacheParam normalType(Class type) {
        cacheType = CACHE_TYPE_NORMAL;
        mType = type;
        return this;
    }

    public boolean readFromCache() {
        return readFromCache;
    }

    public boolean writeToCache() {
        return writeToCache;
    }

    public boolean shouldDiscardDirtyCache() {
        return discardDirtyCache;
    }

    public boolean clearBeforeUpdate() {
        return clearBeforeUpdate;
    }

    public int getCacheType() {
        return cacheType;
    }

    public Type getType() {
        return mType;
    }

    public String getCacheKey(Params params) {
        if (cacheKey == null)
            cacheKey = mCacheKeyGenerator.getKey(params);
        return cacheKey;
    }
}
