package ellax.request.cache;

import androidx.annotation.Nullable;

import ellax.request.Params;

/**
 * created by dongdaqing 19-3-4 下午2:59
 * 获取用于缓存接口数据的key
 */
public interface CacheKeyGenerator {
    /**
     * 生成的key对于每一个要缓存的数据须是独一无二的，
     * 比如在咿啦看书中大部分的接口可以使用 method+uid 的方式生成唯一的key值
     * 在咿啦英语中大部分接口可以使用 url+uid 的方式生成唯一的key值
     * @param params
     * @return 直接返回对应的内容就行，后面会对其使用md5压缩
     */
    String getKey(@Nullable Params params);
}
