package ellax.request.cache;

import android.content.Context;
import android.util.SparseArray;

import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;

import ellax.base.Callback;
import ellax.request.RequestState;
import ellax.request.RequestStateManager;

/**
 * created by dongdaqing 19-3-2 下午5:35
 */
public class CacheCenter {

    private static Set<String> sNonDirtyCacheSet = new HashSet<>();
    private static SparseArray<Cache> sCacheHandler;
    private static Context sContext;

    public static Context getContext() {
        return sContext;
    }

    public static void setup(Context context) {
        sContext = context;
    }

    public static boolean cacheEnabledForKey(String key) {
        return sCacheHandler != null && sCacheHandler.get(key.hashCode()) != null;
    }

    public static <T> void query(String requestUniqueKey, String key, Callback<T> callback) {
        RequestStateManager.stateChanged(requestUniqueKey, RequestState.REQUEST_QUERY_CACHE_START);
        //noinspection unchecked
        sCacheHandler.get(key.hashCode()).query(key, callback);
    }

    public static <T> void update(String key, T data, boolean clear) {
        //noinspection unchecked
        sCacheHandler.get(key.hashCode()).update(key, data, clear);
    }

    /**
     * 标记缓存数据是脏数据
     *
     * @param method 接口
     * @param uid    当前用户id
     */
    public static void markDirty(String method, String uid) {
        sNonDirtyCacheSet.remove(new CacheKeyMd5Encoder(new SimpleGenerator(method, uid, null)).getKey(null));
    }

    /**
     * 标记缓存数据是脏数据
     *
     * @param method 接口
     * @param uid    当前用户id
     * @param extra
     */
    public static void markDirty(String method, String uid, String extra) {
        sNonDirtyCacheSet.remove(new CacheKeyMd5Encoder(new SimpleGenerator(method, uid, extra)).getKey(null));
    }

    /**
     * 标记缓存数据是脏数据
     */
    public static void markDirty(CacheKeyGenerator cacheKeyGenerator) {
        sNonDirtyCacheSet.remove(new CacheKeyMd5Encoder(cacheKeyGenerator).getKey(null));
    }

    /**
     * 将所有的数据都标记成dirty状态，在用户信息发生变化时调用
     */
    public static void clearAllCache() {
        if (sCacheHandler != null)
            sCacheHandler.clear();
    }

    /**
     * 标记当前缓存非dirty
     *
     * @param key
     */
    public static void markNonDirty(String key) {
        sNonDirtyCacheSet.add(key);
    }

    public static boolean isDirtyCache(String cacheKey) {
        return !sNonDirtyCacheSet.contains(cacheKey);
    }

    public static void enableCache(String key, Cache cache) {
        if (sCacheHandler == null)
            sCacheHandler = new SparseArray<>();
        sCacheHandler.put(key.hashCode(), cache);
    }

    public static void enableCache(String key, Type type) {
        enableCache(key, type, false);
    }

    public static void enableCache(String key, Type type, boolean list) {
        enableCache(key, createCache(type, list));
    }

    public static Cache createCache(Type type, boolean list) {
        return list ? new ListCache(type) : new NormalCache(type);
    }

    public static void disableCache(String key) {
        if (sCacheHandler != null)
            sCacheHandler.remove(key.hashCode());
    }
}
