package ellax.request;

import android.os.Handler;
import android.os.Looper;
import ellax.base.helper.AppExecutors;
import ellax.base.transition.TransitionManager;

/**
 * created by dongdaqing 19-3-18 下午5:50
 */
class TransitionHelper {
    /**
     * @param transitionKey
     * @param uniqueKey
     */
    synchronized static void bindWithRequest(int transitionKey, String uniqueKey) {
        RequestStateManager.registerListener(new TransitionCanceller(transitionKey, uniqueKey));
    }

    private static class TransitionCanceller implements RequestStateListener {

        private final Handler mHandler = new Handler(Looper.getMainLooper());
        private final String mUniqueKey;
        private final int mTransitionKey;
        private final Runnable mUnbinder = new Runnable() {
            @Override
            public void run() {
                //请求成功，不再需要transition了
                TransitionManager.unbind(mTransitionKey);
                //取消掉监听器
                RequestStateManager.unregisterListener(TransitionCanceller.this);
            }
        };

        private int startCount;

        private TransitionCanceller(int transitionKey, String uniqueKey) {
            mTransitionKey = transitionKey;
            mUniqueKey = uniqueKey;
        }

        @Override
        public void onRequestStateChanged(String uniqueKey, int state) {
            if (mUniqueKey.equals(uniqueKey)) {
                /**
                 *   这个变量记录接收过的状态，如果接受到重复的状态就抛弃掉（不处理）该状态
                 *
                 *   什么情况下会出现接收到重复状态的问题？
                 *   一个正常的请求过程是不会出现这种情况的，但是如果用户在callback的回调方法里面（onSuccess,onError）里面去发起相同请求，
                 *   这时候当前请求的RequestStateListener可能还没被移除掉，这时就会接收到重复的状态
                 */
                if (startCount > 1)
                    return;

                switch (state) {
                    case RequestState.REQUEST_START:
                        startCount++;
                        break;
                    case RequestState.REQUEST_QUERY_CACHE_END:
                        /**
                         * 缓存查询完毕之后100ms没有开始查询服务端就认为当前请求已经结束了
                         */
                        mHandler.postDelayed(mUnbinder, 100);
                        break;
                    case RequestState.REQUEST_QUERY_SERVER_START:
                        mHandler.removeCallbacks(mUnbinder);
                        break;
                    case RequestState.REQUEST_QUERY_SERVER_SUCCESS:
                        //请求成功，不再需要transition了
                        AppExecutors.mainThread(new Runnable() {
                            @Override
                            public void run() {
                                TransitionManager.unbind(mTransitionKey);
                            }
                        });
                    case RequestState.REQUEST_QUERY_SERVER_FAILURE:
                        //请求完成时，取消掉监听器
                        RequestStateManager.unregisterListener(TransitionCanceller.this);
                        break;
                }
            }
        }
    }
}
