package ellax.request;

import ellax.base.transition.StateInterceptor;
import ellax.base.transition.Transition;

/**
 * created by dongdaqing 2019-06-21 10:07
 */
public class TransitionErrorHelper implements StateInterceptor {

    private long lastInterceptTime;

    @Override
    public boolean beforeTransition(int oldState, int newState) {
        if (newState == Transition.STATE_NORMAL && System.currentTimeMillis() - lastInterceptTime < 1000)
            //拦截掉此次的操作
            return true;

        /**
         * 从加载状态，切换到异常状态
         *
         * 目前的网络请求过程：
         *        1.startProgress(开始动画，切换到STATE_LOADING)
         *        2.1 success（成功）
         *        2.2 error（失败，切换到异常页面（STATE_NETWORK_BROKEN或者STATE_EMPTY）或者其他行为操作）
         *        3 stopProgress（切换到STATE_NORMAL）
         *
         * 请求的路径只有两条：
         *        1 -> 2.1 -> 3，这个是正常流程，请求开始切换加载页面，完成切换到原始页面
         *        1 -> 2.2 -> 3 这个是错误处理流程，从上面的描述可以看到，在失败的时候可能会切换到异常状态（只有空数据和网络出错会被Transition处理），也可能没人任何操作，
         *                      如果是切换到STATE_NETWORK_BROKEN或者STATE_EMPTY，那么就会出现在切换到异常页面之后立即切换到STATE_NORMAL的情况，为了处理这种情况，这里增加一个限制
         */
        if (oldState == Transition.STATE_LOADING && (newState == Transition.STATE_NETWORK_BROKEN || newState == Transition.STATE_EMPTY)) {
            //记录当前时间，如果1s之内切换到STATE_NORMAL就认为这是stopProgress切换的，忽略掉此次操作
            lastInterceptTime = System.currentTimeMillis();
        }
        return false;
    }

    @Override
    public void afterTransition(int state) {

    }
}
