package ellax.request;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

/**
 * created by dongdaqing 19-3-18 下午5:04
 */
public class RequestStateManager implements RequestStateListener {
    private static RequestStateManager sRequestStateManager;
    private final Set<RequestStateListener> mListenerSet;

    private RequestStateManager() {
        mListenerSet = new CopyOnWriteArraySet<>();
    }

    public synchronized static void registerListener(RequestStateListener listener) {
        if (sRequestStateManager == null)
            sRequestStateManager = new RequestStateManager();

        sRequestStateManager.mListenerSet.add(listener);
    }

    public synchronized static void unregisterListener(RequestStateListener listener) {
        if (sRequestStateManager != null)
            sRequestStateManager.mListenerSet.remove(listener);
    }

    public synchronized static void stateChanged(String uniqueKey, int state) {
        if (sRequestStateManager != null)
            sRequestStateManager.onRequestStateChanged(uniqueKey, state);
    }

    @Override
    public void onRequestStateChanged(String uniqueKey, int state) {
        synchronized (mListenerSet) {
            for (RequestStateListener listener : mListenerSet) {
                listener.onRequestStateChanged(uniqueKey, state);
            }
        }
    }
}
