package ellax.request;

import java.util.Map;

/**
 * @author dongdaqing 2018-05-12 17:05
 */
public class RequestConstants {
    //数据来源
    public static final String DATA_SOURCE_KEY = "RequestConstants.data_source";
    public static final String DATA_SOURCE_SERVER = "RequestConstants.server";
    public static final String DATA_SOURCE_CACHE = "RequestConstants.cache";

    public static boolean isFromServer(Map<String, String> extra) {
        return DATA_SOURCE_SERVER.equals(extra.get(DATA_SOURCE_KEY));
    }

    public static final String AUTO_CANCEL_PENDING_REQUEST_KEY = "RequestConstants.auto_cancel_pending_request_key";
    public static final String AUTO_CANCEL_PENDING_REQUEST_YES = "RequestConstants.auto_cancel_pending_request_yes";

    //发起请求时是否自动取消含有相同标签的请求，这里主要用于防止一些提交操作重复进行
    public static boolean shouldAutoCancelPendingRequest(Map<String, String> extra) {
        return AUTO_CANCEL_PENDING_REQUEST_YES.equals(extra.get(AUTO_CANCEL_PENDING_REQUEST_KEY));
    }

    public static final String REQUEST_CUSTOM_TIME_OUT = "RequestConstants.request_custom_time_out";//自定义超时时间

    public static final String ABORT_ON_SAME_TAG_KEY = "RequestConstants.abort_on_same_tag";
    public static final String ABORT_ON_SAME_TAG_YES = "RequestConstants.abort_on_same_tag_yes";

    public static boolean shouldAbortOnSameTag(Map<String, String> extra) {
        return ABORT_ON_SAME_TAG_YES.equals(extra.get(ABORT_ON_SAME_TAG_KEY));
    }

    public static final String REQUEST_SOURCE_NAME = "RequestConstants.request_source_name";
}
