package ellax.request;

import androidx.annotation.NonNull;
import ellax.base.error.Error;
import ellax.base.IProgress;
import okhttp3.Call;

import java.util.Map;

/**
 * Created by dongdaqing on 2018/4/2.
 */
public interface Request<T> {
    /**
     * 标记请求，这里不使用cancel()样式的函数，因为取消操作并不是这个接口的实现类完成的，
     * 而是其他地方完成的，这里就是把其他地方的处理结果放进来而已，简单的做一下标记的意思,
     * 这一步标记并不会对正在执行的请求有任何影响，请求还是会正常执行处理，只是不会执行主线程回调。
     * 如果确实想要打断正在进行的网络请求，可以通过{@link Call#cancel()}方法。
     * 缓存查询步骤都是非常快的，所以暂不提供打断的方法
     *
     * @param cancel true 表示取消
     */
    void mark(boolean cancel);

    /**
     * 请求开始，可以将动画在这里开始
     */
    void onStart();

    /**
     * 请求成功
     *
     * @param response 请求的响应
     * @param extras   extra info for this request
     */
    void onRequestSuccess(@NonNull T response, Map<String, String> extras);

    /**
     * 请求出错
     *
     * @param error  错误内容
     * @param extras
     */
    void onError(Error error, Map<String, String> extras);

    /**
     * 请求结束，可以在这里结束动画
     */
    void onFinish();

    /**
     * 获取用于执行动画的接口
     *
     * @return
     */
    IProgress getProgress();

    /**
     * 获取最内层的Request
     *
     * @return
     */
    Request getOriginalRequest();
}
