package ellax.request;

import androidx.annotation.IntDef;

import ellax.request.cache.CacheParam;
import ellax.request.parser.Parser;

import java.io.File;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Map;

/**
 * Created by dongdaqing on 2018/4/2.
 * 请求参数
 */
public interface Params {

    /**
     * 请求报文格式，form表单
     */
    int REQUEST_DATA_FORMAT_FORM = 0;
    /**
     * 请求报文格式，json
     */
    int REQUEST_DATA_FORMAT_JSON = 1;

    //定义请求数据类型枚举
    @IntDef({REQUEST_DATA_FORMAT_FORM, REQUEST_DATA_FORMAT_JSON})
    @Retention(RetentionPolicy.SOURCE)
    @interface RequestDataFormat{}

    /**
     * url for request,can not be null
     *
     * @return
     */
    String url();

    /**
     * extra info for this request
     *
     * @return
     */
    Map<String, String> extras();

    /**
     * params for request, or null
     *
     * @return
     */
    Map<String, String> params();

    String jsonParams();

    /**
     * custom additional header
     *
     * @return
     */
    Map<String, String> headers();

    /**
     * files to upload
     *
     * @return
     */
    Map<String, File> files();

    /**
     * request method, default is get
     *
     * @return
     */
    HttpMethod method();

    /**
     * response parser
     *
     * @return
     */
    Parser parser();

    /**
     * param used for cache, or null if cache is not need
     *
     * @return
     */
    CacheParam cache();

    /**
     * tag for request,can use to cancel request
     *
     * @return
     */
    int tag();

    /**
     * a unique key for this request
     *
     * @return
     */
    String uniqueKey();

    /**
     * unregister transition with this key when request success
     * @return
     */
    int transitionKey();

    /**
     * 报文格式，form表单，还是json
     *
     * @return int One of {@link #REQUEST_DATA_FORMAT_FORM}, {@link #REQUEST_DATA_FORMAT_JSON}
     */
    @RequestDataFormat
    int requestDataFormat();
}