/*
 * Decompiled with CFR 0.152.
 */
package com.ddq.xphoto;

import android.app.Activity;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.net.Uri;
import com.ddq.xphoto.PhotoCallback;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t\u001a&\u0010\n\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"DIR_NAME", "", "cleanPhotoDir", "", "context", "Landroid/content/Context;", "createPhotoFile", "Ljava/io/File;", "activity", "Landroid/app/Activity;", "writeUriToFile", "uri", "Landroid/net/Uri;", "file", "callback", "Lcom/ddq/xphoto/PhotoCallback;", "xphoto_release"})
public final class PhotoHelperKt {
    @NotNull
    public static final String DIR_NAME = "dpics";

    @Nullable
    public static final File createPhotoFile(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        File dir = new File(activity.getFilesDir(), DIR_NAME);
        if (!dir.exists() && !dir.mkdir()) {
            return null;
        }
        File file = new File(dir, String.valueOf(System.currentTimeMillis()) + ".jpg");
        if (file.createNewFile()) {
            return file;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void writeUriToFile(@NotNull Activity activity, @NotNull Uri uri, @NotNull File file, @NotNull PhotoCallback callback) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        AssetFileDescriptor desc = activity.getContentResolver().openAssetFileDescriptor(uri, "r");
        if (desc != null) {
            try {
                Closeable closeable = new FileOutputStream(file);
                boolean bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    FileOutputStream it = (FileOutputStream)closeable;
                    boolean bl3 = false;
                    FileInputStream fis = desc.createInputStream();
                    byte[] bytes = new byte[8096];
                    int c = 0;
                    do {
                        if ((c = fis.read(bytes)) <= 0) continue;
                        it.write(bytes, 0, c);
                    } while (c != -1);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                String string = file.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.path");
                callback.onPhotoSelected(string);
            }
            catch (Exception e) {
                callback.onError(e.toString());
            }
        }
    }

    public static final void cleanPhotoDir(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        File[] fileArray = new File(context.getFilesDir(), DIR_NAME).listFiles();
        if (fileArray != null) {
            File[] $this$forEach$iv = fileArray;
            boolean $i$f$forEach = false;
            File[] fileArray2 = $this$forEach$iv;
            int n = fileArray2.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File it = element$iv = fileArray2[i];
                boolean bl = false;
                it.delete();
            }
        }
    }
}

