/*
 * Decompiled with CFR 0.152.
 */
package com.ddq.xphoto;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.Parcelable;
import android.provider.MediaStore;
import androidx.core.content.FileProvider;
import com.ddq.xphoto.PhotoCallback;
import com.ddq.xphoto.PhotoHelperKt;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u0006\u0010\u0010\u001a\u00020\nJ\n\u0010\u0011\u001a\u00020\n*\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/ddq/xphoto/PhotoHelper;", "", "activity", "Landroid/app/Activity;", "callback", "Lcom/ddq/xphoto/PhotoCallback;", "(Landroid/app/Activity;Lcom/ddq/xphoto/PhotoCallback;)V", "ongoing", "", "onActivityResult", "", "requestCode", "", "resultCode", "data", "Landroid/content/Intent;", "selectPhoto", "takePhoto", "xphoto_release"})
public final class PhotoHelper {
    private String ongoing;
    private final Activity activity;
    private final PhotoCallback callback;

    public final void selectPhoto() {
        Intent intent = new Intent("android.intent.action.PICK");
        if (this.activity.getPackageManager().resolveActivity(intent, 65536) != null) {
            intent.setType("image/*");
            intent.setData(MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
            this.activity.startActivityForResult(intent, 201);
        } else {
            this.callback.onError("no gallery app");
        }
    }

    public final void takePhoto(@NotNull Activity $this$takePhoto) {
        Uri uri;
        Intrinsics.checkNotNullParameter((Object)$this$takePhoto, (String)"$this$takePhoto");
        String string = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM).getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Environment.getExternalS\u2026Y_DCIM).getAbsolutePath()");
        String path = string;
        String name = String.valueOf(System.currentTimeMillis()) + ".jpg";
        File file = new File(path, name);
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (Build.VERSION.SDK_INT >= 29) {
            ContentValues values = new ContentValues();
            values.put("_display_name", name);
            values.put("relative_path", Environment.DIRECTORY_DCIM);
            values.put("mime_type", "image/jpeg");
            uri = $this$takePhoto.getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values);
        } else {
            uri = Build.VERSION.SDK_INT >= 24 ? FileProvider.getUriForFile((Context)((Context)$this$takePhoto), (String)(this.activity.getPackageName() + ".fileprovider"), (File)file) : Uri.fromFile((File)file);
        }
        Uri uri2 = uri;
        intent.putExtra("output", (Parcelable)uri2);
        $this$takePhoto.startActivityForResult(intent, 200);
    }

    public final void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        if (resultCode == -1) {
            switch (requestCode) {
                case 200: {
                    if (this.ongoing == null) break;
                    String string = this.ongoing;
                    Intrinsics.checkNotNull((Object)string);
                    this.callback.onPhotoSelected(string);
                    break;
                }
                case 201: {
                    Intent intent = data;
                    if ((intent != null ? intent.getData() : null) == null) {
                        this.callback.onError("error");
                        return;
                    }
                    ContentResolver resolver = this.activity.getContentResolver();
                    Uri uri = data.getData();
                    Intrinsics.checkNotNull((Object)uri);
                    String type = resolver.getType(uri);
                    if (type != null && StringsKt.startsWith$default((String)type, (String)"image/", (boolean)false, (int)2, null)) {
                        File file = PhotoHelperKt.createPhotoFile(this.activity);
                        if (file != null) {
                            Uri uri2 = data.getData();
                            Intrinsics.checkNotNull((Object)uri2);
                            Intrinsics.checkNotNullExpressionValue((Object)uri2, (String)"data.data!!");
                            PhotoHelperKt.writeUriToFile(this.activity, uri2, file, this.callback);
                            break;
                        }
                        this.callback.onError("unable to create image file");
                        break;
                    }
                    this.callback.onError("wrong file type");
                    break;
                }
            }
        }
    }

    public PhotoHelper(@NotNull Activity activity, @NotNull PhotoCallback callback) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.activity = activity;
        this.callback = callback;
    }
}

