/*
 * Decompiled with CFR 0.152.
 */
package ellax.log.pojo;

import android.util.Base64;
import com.google.gson.Gson;
import ellax.base.Callback;
import ellax.base.helper.AppExecutors;
import ellax.log.Logger;
import ellax.log.Uploader;
import ellax.log.pojo.LogRecord;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class Log {
    public static final String LOG_DIR_NAME = "ella_lls";
    private static final String PREFIX = "be-";
    private static final SimpleDateFormat sSimpleDateFormat = new SimpleDateFormat("yyyyMMdd", Locale.getDefault());
    private String date;
    private Uploader mUploader;

    public static Log create(Uploader uploader) {
        Log log = new Log();
        log.mUploader = uploader;
        log.date = sSimpleDateFormat.format(new Date());
        return log;
    }

    public String getDate() {
        return this.date;
    }

    public void upload(LogRecord logRecord) {
        this.saveLog(logRecord, true);
    }

    void saveLog(final LogRecord logRecord, final boolean upload) {
        AppExecutors.diskIO((Runnable)new Runnable(){

            @Override
            public void run() {
                File dir = new File(Logger.getContext().getFilesDir(), Log.LOG_DIR_NAME);
                if (dir.exists() || dir.mkdir()) {
                    File file = new File(dir, Log.PREFIX + logRecord.getNum());
                    try {
                        if (file.exists() || file.createNewFile()) {
                            String log = "[" + new Gson().toJson((Object)logRecord) + "]";
                            FileWriter writer = new FileWriter(file);
                            writer.write(Base64.encodeToString((byte[])log.getBytes(), (int)0));
                            writer.close();
                            if ((upload || Log.getTotalSize() > 307200L) && Log.this.mUploader != null) {
                                Log.this.mUploader.upload(file, new FileCleaner());
                            }
                        } else {
                            File[] files;
                            android.util.Log.e((String)"xlog", (String)("can not create log file:" + file.getPath()));
                            for (File ff : files = dir.listFiles()) {
                                ff.delete();
                            }
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    private static long getTotalSize() {
        File[] dir = new File(Logger.getContext().getFilesDir(), LOG_DIR_NAME).listFiles();
        if (dir == null) {
            return 0L;
        }
        long total = 0L;
        for (File file : dir) {
            if (!file.isFile()) continue;
            total += file.length();
        }
        return total;
    }

    private class FileCleaner
    implements Callback<File> {
        private FileCleaner() {
        }

        public void callback(File file) {
            file.delete();
            File[] dir = new File(Logger.getContext().getFilesDir(), Log.LOG_DIR_NAME).listFiles();
            if (dir != null && dir.length > 0) {
                int index = 0;
                do {
                    File cf = dir[index];
                    String name = cf.getName();
                    if (!cf.isFile() || name == null || !name.startsWith(Log.PREFIX)) continue;
                    Log.this.mUploader.upload(cf, new FileCleaner());
                    break;
                } while (++index < dir.length);
            }
        }
    }
}

