/*
 * Decompiled with CFR 0.152.
 */
package ellax.log.pojo;

import android.util.Log;
import ellax.log.pojo.Record;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;

class Host {
    private static final SimpleDateFormat sSimpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss", Locale.getDefault());
    private String host;
    private String enter;
    private String uri;
    private String leave;
    private long duration;
    private List<Record> events;
    private transient boolean close;
    private transient long start;

    Host() {
    }

    static Host create(String name) {
        Host host = new Host();
        host.start = System.currentTimeMillis();
        host.enter = sSimpleDateFormat.format(new Date());
        host.host = name;
        Log.d((String)"xlog", (String)("enter page:" + name));
        return host;
    }

    void leave() {
        if (!this.close) {
            long current = System.currentTimeMillis();
            this.duration = (current - this.start) / 1000L + 1L;
            Date date = new Date();
            date.setTime(current);
            this.leave = sSimpleDateFormat.format(date);
            this.close = true;
            Log.d((String)"xlog", (String)("exit page:" + this.host));
        }
    }

    public void add(String event, String message, Integer tag) {
        if (this.events == null) {
            this.events = new CopyOnWriteArrayList<Record>();
        }
        this.events.add(new Record(event, message, tag));
    }

    public boolean isSame(String name) {
        return this.host != null && this.host.equals(name);
    }

    public String toString() {
        return String.format(Locale.getDefault(), "{%s:%s}", this.host, this.close ? "close" : "open");
    }
}

