/*
 * Decompiled with CFR 0.152.
 */
package ellax.log;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import ellax.base.IdRetriever;
import ellax.log.NameProvider;
import ellax.log.Uploader;
import ellax.log.WatchDog;
import ellax.log.pojo.Log;
import ellax.log.pojo.LogRecord;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class Logger {
    private static final String PREFERENCE = "ellax.log";
    private static final Set<Integer> mEnterSet = new HashSet<Integer>();
    private static IdRetriever sIdRetriever;
    private static LogRecord sLogRecord;
    private static Context sContext;
    private static String ip;
    private static Bundle sBundle;
    private static Log sLog;
    private static NameProvider sNameProvider;
    private static Date enterDate;

    public static void setEnterDate(Date enterDate) {
        Logger.enterDate = enterDate;
    }

    public static Date getEnterDate() {
        if (enterDate == null) {
            enterDate = new Date(Calendar.getInstance().getTimeInMillis());
        }
        return enterDate;
    }

    public static void setup(Application app, Bundle bundle, IdRetriever retriever, Uploader uploader, Runnable afterAppPaused, NameProvider nameProvider) {
        sContext = app;
        sIdRetriever = retriever;
        sBundle = bundle;
        sNameProvider = nameProvider;
        sLog = Log.create(uploader);
        enterDate = new Date();
        app.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new WatchDog(afterAppPaused));
    }

    public static void record(String event) {
        Logger.record(event, null);
    }

    public static void record(String event, String message) {
        Logger.record(event, message, null);
    }

    public static void record(String event, String message, Integer tag) {
        if (sLogRecord != null) {
            sLogRecord.add(event, message, tag);
        }
    }

    static void enter(Object object) {
        if (!mEnterSet.contains(object.hashCode())) {
            mEnterSet.add(object.hashCode());
            if (sLogRecord == null) {
                sLogRecord = Logger.createRecord(sIdRetriever);
            }
            sLogRecord.enter(object, sNameProvider);
        }
    }

    static void leave(Object object) {
        if (sLogRecord != null && mEnterSet.remove(object.hashCode())) {
            sLogRecord.exit(object);
        }
    }

    public static void userChanged() {
        if (sLogRecord != null) {
            sLog.upload(sLogRecord);
        }
        sLogRecord = Logger.createRecord(sIdRetriever);
        mEnterSet.clear();
    }

    public static void upload() {
        Logger.userChanged();
    }

    static boolean active() {
        if (sIdRetriever.getUid() == null) {
            return false;
        }
        android.util.Log.d((String)"xlog", (String)"app is active");
        LogRecord record = Logger.createRecord(sIdRetriever);
        sLog.upload(record);
        return true;
    }

    static void exit() {
        android.util.Log.d((String)"xlog", (String)"exit app");
        sLog.upload(sLogRecord);
        sLogRecord = null;
    }

    private static LogRecord createRecord(IdRetriever idRetriever) {
        int num;
        SharedPreferences preferences = sContext.getSharedPreferences(PREFERENCE, 0);
        if (sLog.getDate().equals(preferences.getString("date", null))) {
            num = preferences.getInt("num", 0) + 1;
        } else {
            preferences.edit().putString("date", sLog.getDate()).apply();
            num = 1;
        }
        if (num > 9999999) {
            num = 1;
        }
        preferences.edit().putInt("num", num).apply();
        return LogRecord.create(sLog, idRetriever, sBundle, num, ip);
    }

    public static void setIp(String ip) {
        Logger.ip = ip;
        if (sLogRecord != null) {
            sLogRecord.setIp(ip);
        }
    }

    public static void setLocation(String location) {
        if (sLogRecord != null) {
            sLogRecord.setLocate(location);
        }
    }

    public static Context getContext() {
        return sContext;
    }
}

