/*
 * Decompiled with CFR 0.152.
 */
package ellax.bookmanager;

import android.util.Log;
import ellax.bookmanager.BookEvent;
import ellax.bookmanager.BookManager;
import ellax.bookmanager.DownloadInfoCallback;
import ellax.bookmanager.InstallCallback;
import ellax.bookmanager.InstallManager;
import java.io.File;

public class ReaderResource
implements Comparable<ReaderResource> {
    public static final String RESOURCE_TYPE_BOOK = "book";
    public static final String RESOURCE_TYPE_PARENTING = "parenting";
    public String bookCode;
    public String url;
    public String resourceType;
    public String readerVersion;
    public String resourceVersion;
    public long resourceSize;
    public Object extraInfo;
    public boolean publicResource;
    public String tags;
    private File mDownloadFile;
    private File mInstallFile;
    private boolean tryMode;
    public ReaderResource nextResource;
    private int progress;
    boolean wifi;
    boolean topPriority;

    public int calculateProgress(String url, long soFarBytes, long totalBytes) {
        long total = totalBytes;
        long down = soFarBytes;
        ReaderResource resource = this;
        do {
            if (resource.url.equals(url)) {
                if (totalBytes <= 0L) continue;
                if (resource.resourceSize != totalBytes) {
                    this.dispatchResourceSizeNotMatch(resource.resourceSize, totalBytes);
                }
                resource.resourceSize = totalBytes;
                continue;
            }
            if (!resource.isInstalled()) {
                total += resource.resourceSize;
            }
            if (!resource.isDownloaded()) continue;
            down += resource.resourceSize;
        } while ((resource = resource.nextResource) != null);
        int p = total == 0L ? 0 : (int)((float)down * 1.0f / (float)total * 100.0f);
        if (p > this.progress) {
            this.progress = p;
        }
        return this.progress;
    }

    void setTryMode(boolean tryMode) {
        ReaderResource resource = this;
        do {
            resource.tryMode = tryMode;
        } while ((resource = resource.nextResource) != null);
    }

    boolean isTryMode() {
        return this.tryMode;
    }

    public String getBookCode() {
        return this.bookCode;
    }

    private boolean isInstalled() {
        if (this.mInstallFile == null) {
            this.mInstallFile = this.getResourcePath(this.tryMode);
        }
        return this.mInstallFile.exists();
    }

    private boolean isDownloaded() {
        if (this.mDownloadFile == null) {
            this.mDownloadFile = ReaderResource.getTempPath(this);
        }
        return this.mDownloadFile.exists();
    }

    boolean isAllInstalledInUserDir() {
        ReaderResource resource = this;
        boolean installed = true;
        do {
            File file = this.getResourcePath(false);
            installed &= file.exists();
        } while ((resource = resource.nextResource) != null);
        return installed;
    }

    boolean isAllInstalled() {
        ReaderResource resource = this;
        boolean installed = true;
        do {
            installed &= resource.isInstalled();
        } while ((resource = resource.nextResource) != null);
        return installed;
    }

    boolean isReadyForInstall() {
        return this.getDownloadableResource() == null;
    }

    boolean needInstall() {
        return !this.isInstalled() && this.isDownloaded();
    }

    ReaderResource getDownloadableResource() {
        ReaderResource resource = this;
        do {
            if (resource.isInstalled() || resource.isDownloaded()) continue;
            return resource;
        } while ((resource = resource.nextResource) != null);
        return null;
    }

    void transfer(final InstallCallback callback) {
        if (!this.tryMode && BookManager.getResourceInstallDir(this.getBookCode(), true, this.publicResource).exists()) {
            InstallManager.move(this, new InstallCallback(){

                @Override
                public void complete(boolean success) {
                    ReaderResource.this.dispatchResourceMovement(true, success);
                    BookEvent event = new BookEvent(ReaderResource.this.getBookCode(), -6);
                    event.success = success;
                    BookManager.getDownloadManager().post(event);
                    callback.complete(success);
                }
            });
        } else {
            this.dispatchResourceMovement(false, false);
            callback.complete(false);
        }
    }

    private void dispatchResourceMovement(boolean exist, boolean success) {
        DownloadInfoCallback callback = BookManager.getDownloadInfoCallback();
        if (callback != null) {
            callback.moveResource(this, exist, success);
        }
    }

    private void dispatchResourceSizeNotMatch(long old, long newSize) {
        DownloadInfoCallback callback = BookManager.getDownloadInfoCallback();
        if (callback != null) {
            callback.resourceSizeNotMatch(this, old, newSize);
        }
    }

    public boolean move() {
        if (this.tryMode) {
            return true;
        }
        File source = BookManager.getResourceInstallDir(this.getBookCode(), !this.tryMode, this.publicResource);
        File target = BookManager.getResourceInstallDir(this.getBookCode(), this.tryMode, this.publicResource);
        if (!target.exists() && !target.mkdirs()) {
            Log.e((String)"BookManager", (String)("failed to create dir: " + target.getPath()));
        }
        return source.renameTo(target);
    }

    private File getResourcePath(boolean tryMode) {
        File basePath = new File(BookManager.getResourceInstallDir(this.getBookCode(), tryMode, this.publicResource), BookManager.getBookResourcePath());
        switch (this.resourceType) {
            case "book": {
                return basePath;
            }
            case "parenting": {
                File book = BookManager.getResourceInstallDir(this.getBookCode(), tryMode, this.publicResource);
                File b2 = new File(book, "Iphone2208");
                File b1 = new File(book, "Iphone1334");
                if (b2.exists()) {
                    return new File(b2, "component" + File.separator + "education");
                }
                return new File(b1, "component" + File.separator + "education");
            }
        }
        throw new IllegalArgumentException("resource type is not valid");
    }

    File getInstallPath() {
        File basePath = BookManager.getResourceInstallDir(this.getBookCode(), this.tryMode, this.publicResource);
        switch (this.resourceType) {
            case "book": {
                return basePath;
            }
            case "parenting": {
                File file = new File(basePath, "Iphone2208");
                if (file.exists()) {
                    return file;
                }
                return new File(basePath, "Iphone1334");
            }
        }
        throw new IllegalArgumentException("resource type is not valid");
    }

    static File getTempPath(String bookCode, String resourceType, String suffix) {
        File dir = BookManager.getBookDir(true);
        String name = bookCode + suffix;
        if (!RESOURCE_TYPE_BOOK.equals(resourceType)) {
            name = bookCode + "_" + resourceType + suffix;
        }
        return new File(dir, name);
    }

    static File getTempPath(String bookCode, String resourceType) {
        return ReaderResource.getTempPath(bookCode, resourceType, ".eb");
    }

    static File getTempPath(ReaderResource resource) {
        return ReaderResource.getTempPath(resource.getBookCode(), resource.resourceType);
    }

    static File getTempPath(ReaderResource resource, String suffix) {
        return ReaderResource.getTempPath(resource.getBookCode(), resource.resourceType, suffix);
    }

    @Override
    public int compareTo(ReaderResource o) {
        if (this.bookCode != null && o != null && this.bookCode.equals(o.bookCode)) {
            return 0;
        }
        return -1;
    }

    boolean match(String tag) {
        String[] ts;
        if (tag == null || this.tags == null) {
            return false;
        }
        for (String ss : ts = tag.split(",")) {
            if (!this.tags.contains(ss)) continue;
            return true;
        }
        return false;
    }
}

