/*
 * Decompiled with CFR 0.152.
 */
package ellax.bookmanager;

import android.util.Log;
import com.google.gson.Gson;
import ellax.base.util.Md5;
import ellax.bookmanager.BookLocalInfo;
import ellax.bookmanager.BookManager;
import ellax.bookmanager.DownloadInfoCallback;
import ellax.bookmanager.InstallCallback;
import ellax.bookmanager.ReaderResource;
import ellax.bookmanager.UnZipCallback;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

class InstallManager {
    static final String BOOK_INFO = "bookInfo.json";
    static final String EXTRA_INFO = "extra.json";
    private static final List<String> sOngoing = new ArrayList<String>();

    InstallManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void install(ReaderResource resource, Install callback) {
        InstallManager.dispatchInstall(resource, "prepare");
        List<String> list = sOngoing;
        synchronized (list) {
            if (!sOngoing.contains(resource.getBookCode())) {
                InstallManager.dispatchInstall(resource, "pending");
                sOngoing.add(resource.getBookCode());
                BookManager.execute(new Installer(resource, callback));
            } else {
                InstallManager.dispatchInstall(resource, "already in progress");
            }
        }
    }

    private static void dispatchInstall(ReaderResource resource, String step) {
        DownloadInfoCallback callback = BookManager.getDownloadInfoCallback();
        if (callback != null) {
            callback.install(resource, step);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void move(ReaderResource resource, InstallCallback callback) {
        List<String> list = sOngoing;
        synchronized (list) {
            if (!sOngoing.contains(resource.getBookCode())) {
                sOngoing.add(resource.getBookCode());
                BookManager.execute(new Move(resource, callback));
            }
        }
    }

    static void unzip(String src, String dest) throws Exception {
        File dir = new File(dest);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IllegalStateException("can not create dest folder: " + dest);
        }
        ZipFile srcFile = new ZipFile(src);
        Enumeration<? extends ZipEntry> entries = srcFile.entries();
        while (entries.hasMoreElements()) {
            int count;
            ZipEntry entry = entries.nextElement();
            String name = new String(entry.getName().replace("\\", "/").getBytes("8859_1"), "GB2312");
            File file = new File(dest, name);
            File parent = file.getParentFile();
            if (!parent.exists() && !parent.mkdirs()) {
                throw new IllegalStateException("can not create folder: " + parent.getPath());
            }
            if (entry.isDirectory()) {
                if (file.exists() || file.mkdir()) continue;
                throw new IllegalStateException("can not create folder: " + file.getPath());
            }
            if (!file.exists() && !file.createNewFile()) {
                throw new IllegalStateException("can not create file: " + file.getPath());
            }
            byte[] buffer = new byte[0x100000];
            InputStream is = srcFile.getInputStream(entry);
            FileOutputStream fos = new FileOutputStream(file);
            while ((count = is.read(buffer)) != -1) {
                fos.write(buffer, 0, count);
            }
            fos.close();
            is.close();
        }
        srcFile.close();
    }

    static void write(File file, Object object) {
        try {
            if (file.exists() || file.createNewFile()) {
                FileWriter writer = new FileWriter(file);
                writer.write(new Gson().toJson(object));
                writer.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static BookLocalInfo readInfo(File bookDir) {
        File file = new File(bookDir, BOOK_INFO);
        String extra = InstallManager.readString(file);
        if (extra != null) {
            return (BookLocalInfo)new Gson().fromJson(extra, BookLocalInfo.class);
        }
        return null;
    }

    static Object readExtra(String bookCode, Class cls) {
        try {
            File dir = BookManager.getResourceForReader(bookCode, true);
            File file = new File(dir.getParentFile(), EXTRA_INFO);
            String extra = InstallManager.readString(file);
            if (extra != null) {
                return new Gson().fromJson(extra, cls);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String readString(File file) {
        FileInputStream fis = null;
        try {
            int c;
            int increment = 8192;
            byte[] bytes = new byte[]{};
            byte[] tmp = new byte[8192];
            fis = new FileInputStream(file);
            while ((c = fis.read(tmp)) != -1) {
                byte[] tmp1 = new byte[c + bytes.length];
                System.arraycopy(bytes, 0, tmp1, 0, bytes.length);
                System.arraycopy(tmp, 0, tmp1, bytes.length, c);
                bytes = tmp1;
            }
            String string = new String(bytes);
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    private static void deleteIfExist(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] files;
                for (File ff : files = file.listFiles()) {
                    InstallManager.deleteIfExist(ff);
                }
            }
            if (!file.delete()) {
                Log.e((String)"BookManager", (String)("failed to delete file: " + file.getPath()));
            }
        }
    }

    private static class Move
    implements Runnable {
        ReaderResource mResource;
        InstallCallback mComplete;

        public Move(ReaderResource resource, InstallCallback complete) {
            this.mResource = resource;
            this.mComplete = complete;
        }

        @Override
        public void run() {
            try {
                this.mComplete.complete(this.mResource.move());
            }
            finally {
                sOngoing.remove(this.mResource.getBookCode());
            }
        }
    }

    private static class Installer
    implements Runnable {
        ReaderResource mResource;
        Install mInstall;

        Installer(ReaderResource resource, Install install) {
            this.mResource = resource;
            this.mInstall = install;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            InstallManager.dispatchInstall(this.mResource, "start");
            this.mInstall.start(this.mResource);
            try {
                ReaderResource resource = this.mResource;
                do {
                    if (!resource.needInstall()) continue;
                    File file = resource.getInstallPath();
                    File zip = ReaderResource.getTempPath(resource);
                    InstallManager.dispatchInstall(this.mResource, resource.bookCode);
                    UnZipCallback callback = BookManager.getUnZipCallback();
                    if (callback != null) {
                        callback.unzip(zip, resource.bookCode);
                    } else {
                        InstallManager.unzip(zip.getPath(), file.getPath());
                    }
                    InstallManager.deleteIfExist(zip);
                } while ((resource = resource.nextResource) != null);
                File dir = BookManager.getResourceInstallDir(this.mResource.getBookCode(), this.mResource.isTryMode(), this.mResource.publicResource);
                BookLocalInfo bookLocalInfo = new BookLocalInfo();
                bookLocalInfo.bookCode = this.mResource.getBookCode();
                bookLocalInfo.resourceVersion = this.mResource.resourceVersion;
                bookLocalInfo.readerVersion = this.mResource.readerVersion;
                bookLocalInfo.installTime = System.currentTimeMillis();
                bookLocalInfo.tags = this.mResource.tags;
                InstallManager.write(new File(dir, InstallManager.BOOK_INFO), bookLocalInfo);
                if (this.mResource.extraInfo != null) {
                    InstallManager.write(new File(dir, InstallManager.EXTRA_INFO), this.mResource.extraInfo);
                }
                this.mInstall.complete(this.mResource, true);
                InstallManager.dispatchInstall(this.mResource, "success");
            }
            catch (Exception e) {
                e.printStackTrace();
                Log.d((String)"BookManager", (String)"zip exception occur,delete downloaded file");
                if (!BookManager.debug) {
                    ReaderResource resource = this.mResource;
                    do {
                        File file = ReaderResource.getTempPath(resource);
                        Log.d((String)"BookManager", (String)String.format(Locale.getDefault(), "file:%s,sum:%s", resource.url, Md5.encodeFile((String)file.getPath())));
                        InstallManager.deleteIfExist(file);
                    } while ((resource = resource.nextResource) != null);
                    InstallManager.deleteIfExist(this.mResource.getInstallPath());
                }
                this.mInstall.complete(this.mResource, false);
                InstallManager.dispatchInstall(this.mResource, "failed");
            }
            finally {
                sOngoing.remove(this.mResource.getBookCode());
            }
        }
    }

    static interface Install {
        public void start(ReaderResource var1);

        public void complete(ReaderResource var1, boolean var2);
    }
}

