/*
 * Decompiled with CFR 0.152.
 */
package ellax.bookmanager;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.StatFs;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.WindowManager;
import ellax.base.IdRetriever;
import ellax.base.helper.AppExecutors;
import ellax.bookmanager.BookContainer;
import ellax.bookmanager.BookLocalInfo;
import ellax.bookmanager.DeleteEvent;
import ellax.bookmanager.DownloadInfoCallback;
import ellax.bookmanager.DownloadManager2;
import ellax.bookmanager.InstallManager;
import ellax.bookmanager.Poster;
import ellax.bookmanager.ReaderResource;
import ellax.bookmanager.UnZipCallback;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;

public class BookManager {
    static boolean debug = false;
    public static final int ERROR = -1;
    public static final int COMPLETED = -2;
    public static final int PROGRESS = -3;
    public static final int PAUSED = -4;
    public static final int PENDING = -5;
    public static final int UNZIP_END = -6;
    public static final int UNZIP_START = -7;
    public static final int NONE = -8;
    public static final int FILE_BUSY = -9;
    public static final int SAME_TASK_BUSY = -10;
    public static final int PRE_ALLOCATE_FAILED = -11;
    public static final int QUEUE_CLEARED = -12;
    private static DownloadManager2 sDownloadManager;
    private static Context sContext;
    private static String sBookResource;
    private static IdRetriever sIdRetriever;
    private static DownloadInfoCallback sDownloadInfoCallback;
    private static UnZipCallback sUnZipCallback;
    private static String sBasePath;
    private static boolean sUserSpecified;
    private static final String sPublicName = "ella_public";

    public static void setup(Application app, Poster poster, IdRetriever idRetriever) {
        BookManager.setup(app, poster, idRetriever, app.getFilesDir().getPath(), true);
    }

    public static void setup(Application app, Poster poster, IdRetriever idRetriever, String basePath, boolean userSpecified) {
        sContext = app;
        sIdRetriever = idRetriever;
        sDownloadManager = new DownloadManager2(poster);
        sBasePath = basePath;
        sUserSpecified = userSpecified;
        BookManager.calculateResource();
    }

    static Context getContext() {
        return sContext;
    }

    static DownloadInfoCallback getDownloadInfoCallback() {
        return sDownloadInfoCallback;
    }

    public static void setDownloadInfoCallback(DownloadInfoCallback downloadInfoCallback) {
        sDownloadInfoCallback = downloadInfoCallback;
    }

    static UnZipCallback getUnZipCallback() {
        return sUnZipCallback;
    }

    public static void setUnZipCallback(UnZipCallback unZipCallback) {
        sUnZipCallback = unZipCallback;
    }

    public static void setDownloadProgressCallbackInterval(int ms) {
        BookManager.getDownloadManager().setMinimalProgressCallbackMs(ms);
    }

    public static File getBookDir(boolean publicResource) {
        if (publicResource) {
            return new File(sBasePath, sPublicName);
        }
        if (sUserSpecified) {
            String uid = sIdRetriever.getUid();
            return new File(new File(sBasePath, uid == null ? "U20000000" : uid), "book");
        }
        return new File(sBasePath, "book");
    }

    public static File getTryResourceDir() {
        return new File(sBasePath, "try");
    }

    private static File getBookInstallDirAsFile(String bookCode, boolean publicResource) {
        return new File(BookManager.getBookDir(publicResource), bookCode);
    }

    private static String getBookInstallDir(String bookCode, boolean publicResource) {
        return BookManager.getBookInstallDirAsFile(bookCode, publicResource).getPath();
    }

    private static File getBookTryResourceInstallDir(String bookCode) {
        return new File(BookManager.getTryResourceDir(), bookCode);
    }

    public static File getResourceInstallDir(String bookCode, boolean tryMode, boolean publicResource) {
        if (tryMode) {
            return BookManager.getBookTryResourceInstallDir(bookCode);
        }
        return BookManager.getBookInstallDirAsFile(bookCode, publicResource);
    }

    public static boolean isBookInstalled(String bookCode) {
        return BookManager.isBookInstalled(bookCode, false);
    }

    public static boolean isBookInstalled(String bookCode, boolean tryMode) {
        File f1 = new File(BookManager.getResourceInstallDir(bookCode, tryMode, false), "Iphone1334");
        if (f1.exists()) {
            return true;
        }
        File f2 = new File(BookManager.getResourceInstallDir(bookCode, tryMode, false), "Iphone2208");
        if (f2.exists()) {
            return true;
        }
        File f3 = new File(BookManager.getResourceInstallDir(bookCode, tryMode, true), "Iphone1334");
        if (f3.exists()) {
            return true;
        }
        File f4 = new File(BookManager.getResourceInstallDir(bookCode, tryMode, true), "Iphone2208");
        return f4.exists();
    }

    public static boolean isBookTeachModeInstalled(String bookCode) {
        File basePath = new File(BookManager.getBookInstallDir(bookCode, false), "Iphone1334");
        File basePath2 = new File(BookManager.getBookInstallDir(bookCode, false), "Iphone2208");
        if (basePath.exists()) {
            return new File(basePath, "component" + File.separator + "education").exists();
        }
        if (basePath2.exists()) {
            return new File(basePath2, "component" + File.separator + "education").exists();
        }
        File basePath3 = new File(BookManager.getBookInstallDir(bookCode, true), "Iphone1334");
        File basePath4 = new File(BookManager.getBookInstallDir(bookCode, true), "Iphone2208");
        if (basePath3.exists()) {
            return new File(basePath3, "component" + File.separator + "education").exists();
        }
        if (basePath4.exists()) {
            return new File(basePath4, "component" + File.separator + "education").exists();
        }
        return false;
    }

    public static void download(BookContainer book, boolean tryRead, boolean isOnlyWifi) {
        sDownloadManager.addTask(book.getMainResource(), tryRead, isOnlyWifi);
    }

    public static void download(BookContainer book, boolean isOnlyWifi) {
        BookManager.download(book, false, isOnlyWifi);
    }

    public static void download(ReaderResource resource, boolean isOnlyWifi) {
        sDownloadManager.addTask(resource, false, isOnlyWifi);
    }

    public static void downloadNow(ReaderResource resource, boolean isOnlyWifi) {
        resource.topPriority = true;
        sDownloadManager.addTask(resource, false, isOnlyWifi);
    }

    public static void pause(BookContainer book) {
        sDownloadManager.pauseTask(book.getMainResource());
    }

    public static void pause(ReaderResource resource) {
        sDownloadManager.pauseTask(resource);
    }

    public static void pauseAll() {
        sDownloadManager.pauseAllTasks();
    }

    public static void uninstall(BookContainer book) {
        BookManager.uninstall(book.getMainResource());
    }

    public static void uninstall(ReaderResource resource) {
        sDownloadManager.deleteTask(resource);
        BookManager.uninstall(resource.getBookCode());
    }

    public static void uninstallSync(BookContainer book) {
        BookManager.uninstallSync(book.getMainResource());
    }

    public static void uninstallSync(ReaderResource resource) {
        sDownloadManager.deleteTask(resource);
        BookManager.uninstallSync(resource.getBookCode());
    }

    public static void uninstall(String bookCode) {
        BookManager.execute(new Uninstall(bookCode));
    }

    public static void uninstallSync(String bookCode) {
        new Uninstall(bookCode).run();
    }

    private static void delete(String bookCode) {
        File book = ReaderResource.getTempPath(bookCode, "book");
        BookManager.deleteIfExist(book);
        File teach = ReaderResource.getTempPath(bookCode, "parenting");
        BookManager.deleteIfExist(teach);
    }

    private static void deleteIfExist(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] files;
                for (File ff : files = file.listFiles()) {
                    BookManager.deleteIfExist(ff);
                }
            }
            if (!file.delete()) {
                Log.e((String)"BookManager", (String)("failed to delete file: " + file.getPath()));
            }
        }
    }

    public static void setDebug(boolean debug) {
        BookManager.debug = debug;
    }

    public static boolean isDownloading(BookContainer book) {
        return sDownloadManager.isDownloading(book.getMainResource());
    }

    public static boolean isDownloading(ReaderResource readerResource) {
        ReaderResource resource = readerResource;
        do {
            if (!sDownloadManager.isDownloading(resource)) continue;
            return true;
        } while ((resource = resource.nextResource) != null);
        return false;
    }

    public static boolean isBookUp2Date(String bookCode, String currentVersion, boolean publicResource) {
        File file = BookManager.getBookInstallDirAsFile(bookCode, publicResource);
        BookLocalInfo info = InstallManager.readInfo(file);
        return info != null && TextUtils.equals((CharSequence)info.resourceVersion, (CharSequence)currentVersion);
    }

    public static File getResourceForReader(String bookCode, boolean tryMode) throws FileNotFoundException {
        File resource = BookManager.chooseResourceFromDir(BookManager.getBookInstallDirAsFile(bookCode, false));
        if (resource == null) {
            resource = BookManager.chooseResourceFromDir(BookManager.getBookInstallDirAsFile(bookCode, true));
        }
        if (resource == null && tryMode) {
            resource = BookManager.chooseResourceFromDir(BookManager.getBookTryResourceInstallDir(bookCode));
        }
        if (resource != null) {
            return resource;
        }
        throw new FileNotFoundException("book " + bookCode + " is not installed");
    }

    private static File chooseResourceFromDir(File dir) {
        File[] files = dir.listFiles();
        String resourcePath = BookManager.getBookResourcePath();
        if (files != null) {
            if (files.length == 1) {
                return files[0];
            }
            if (files.length > 1) {
                for (File file : files) {
                    if (!file.getName().equals(resourcePath)) continue;
                    return file;
                }
                for (File file : files) {
                    if (!file.getName().equals("Iphone2208") && !file.getName().equals("Iphone1334")) continue;
                    return file;
                }
            }
        }
        return null;
    }

    private static void calculateResource() {
        WindowManager manager = (WindowManager)sContext.getSystemService("window");
        DisplayMetrics metrics = new DisplayMetrics();
        manager.getDefaultDisplay().getRealMetrics(metrics);
        int height = Math.max(metrics.heightPixels, metrics.widthPixels);
        int width = Math.min(metrics.heightPixels, metrics.widthPixels);
        sBookResource = height * 9 > width * 16 ? "Iphone2208" : "normal";
    }

    public static String getBookResourcePath() {
        if ("normal".equals(sBookResource)) {
            return "Iphone1334";
        }
        return "Iphone2208";
    }

    public static String getBookResource() {
        return sBookResource;
    }

    public static Object readExtra(String bookCode, Class cls) {
        return InstallManager.readExtra(bookCode, cls);
    }

    public static List<BookLocalInfo> getInstalledBooks() {
        ArrayList<BookLocalInfo> list = new ArrayList<BookLocalInfo>();
        File[] dir = BookManager.getBookDir(false).listFiles();
        BookManager.loadBooks(dir, list);
        File[] dir2 = BookManager.getBookDir(true).listFiles();
        BookManager.loadBooks(dir2, list);
        return list;
    }

    private static void generateTags(File[] dirs) {
        if (dirs == null) {
            return;
        }
        for (File dir : dirs) {
            BookLocalInfo info = InstallManager.readInfo(dir);
            if (info == null || !TextUtils.isEmpty((CharSequence)info.tags)) continue;
            File extra = new File(dir, "extra.json");
            String ss = InstallManager.readString(extra);
            info.tags = ss == null || !ss.contains("bookCode") ? "eng" : "chi";
            InstallManager.write(new File(dir, "bookInfo.json"), info);
        }
    }

    public static List<BookLocalInfo> getInstalledBooksByTag(String tag) {
        SharedPreferences preferences = sContext.getSharedPreferences(BookManager.class.getName(), 0);
        if (preferences.getLong("last_refresh", 0L) < 1576131823194L) {
            preferences.edit().putLong("last_refresh", System.currentTimeMillis()).apply();
            BookManager.generateTags(BookManager.getBookDir(false).listFiles());
            BookManager.generateTags(BookManager.getBookDir(true).listFiles());
        }
        List<BookLocalInfo> list = BookManager.getInstalledBooks();
        ArrayList<BookLocalInfo> rss = new ArrayList<BookLocalInfo>();
        for (BookLocalInfo info : list) {
            if (!info.match(tag)) continue;
            rss.add(info);
        }
        return rss;
    }

    private static void loadBooks(File[] dir, List<BookLocalInfo> list) {
        if (dir != null && dir.length > 0) {
            for (File parent : dir) {
                BookLocalInfo info = InstallManager.readInfo(parent);
                if (info == null) continue;
                info.path = parent.getPath();
                list.add(info);
            }
        }
    }

    public static long getAvailableSpace() {
        File dir = BookManager.getBookDir(false);
        if (dir.exists() || dir.mkdirs()) {
            long remain = new StatFs(dir.getAbsolutePath()).getAvailableBytes();
            return remain;
        }
        return 0L;
    }

    public static void setMinimalAvailableSpace(long size) {
        sDownloadManager.setMinimalAvailableSpace(size);
    }

    public static void setMinimalProgressCallbackMs(int minimalProgressCallbackMs) {
        sDownloadManager.setMinimalProgressCallbackMs(minimalProgressCallbackMs);
    }

    public static void setMaxRetryCount(int maxRetryCount) {
        sDownloadManager.setMaxRetryCount(maxRetryCount);
    }

    static DownloadManager2 getDownloadManager() {
        return sDownloadManager;
    }

    static void execute(Runnable runnable) {
        AppExecutors.diskIO((Runnable)runnable);
    }

    public static int getDownloadCount() {
        return sDownloadManager.getDownloadCount();
    }

    public static int getDownloadCountByTag(String tag) {
        return sDownloadManager.getDownloadCountByTag(tag);
    }

    public static boolean loadLocalBooksMayTakeTooLong() {
        File[] pd;
        int result = 0;
        File[] d = BookManager.getBookDir(false).listFiles();
        if (d != null) {
            result += d.length;
        }
        if ((pd = BookManager.getBookDir(true).listFiles()) != null) {
            result += pd.length;
        }
        return result >= 16;
    }

    static {
        sUserSpecified = true;
    }

    private static class Uninstall
    implements Runnable {
        private String bookCode;

        Uninstall(String bookCode) {
            this.bookCode = bookCode;
        }

        @Override
        public void run() {
            File userFile = BookManager.getBookInstallDirAsFile(this.bookCode, false);
            BookManager.deleteIfExist(userFile);
            File shareFile = BookManager.getBookInstallDirAsFile(this.bookCode, true);
            BookManager.deleteIfExist(shareFile);
            File tryResource = BookManager.getBookTryResourceInstallDir(this.bookCode);
            BookManager.deleteIfExist(tryResource);
            BookManager.delete(this.bookCode);
            sDownloadManager.post(new DeleteEvent(this.bookCode, true));
        }
    }
}

