/*
 * Decompiled with CFR 0.152.
 */
package ellax.base.helper;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.Checkable;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.annotation.AnimRes;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.FloatRange;
import androidx.annotation.IdRes;
import androidx.annotation.StringRes;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.core.content.ContextCompat;
import androidx.core.view.ViewCompat;
import androidx.core.widget.TextViewCompat;
import androidx.fragment.app.FragmentTransaction;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class ViewHelper {
    public static final int MARGIN_ALL = 0;
    public static final int MARGIN_LEFT = 1;
    public static final int MARGIN_RIGHT = 2;
    public static final int MARGIN_TOP = 4;
    public static final int MARGIN_BOTTOM = 8;
    public static final int MARGIN_HORIZONTAL = 3;
    public static final int MARGIN_VERTICAL = 12;
    private SparseArray<View> mViewArray;
    private View mRootView;

    public ViewHelper(Activity activity) {
        this(activity.getWindow().getDecorView().getRootView().findViewById(0x1020002));
    }

    public ViewHelper(View rootView) {
        if (rootView == null) {
            throw new IllegalArgumentException("rootView is null");
        }
        this.mRootView = rootView;
        this.mViewArray = new SparseArray();
    }

    public ViewHelper(Context context, int layout) {
        this.mRootView = LayoutInflater.from((Context)context).inflate(layout, null);
        this.mViewArray = new SparseArray();
    }

    public void setText(@IdRes int id2, CharSequence sequence) {
        TextView textView = (TextView)this.getView(id2);
        if (textView != null) {
            textView.setText(sequence);
            if (textView instanceof EditText) {
                ((EditText)textView).setSelection(textView.getText().length());
            }
        }
    }

    public void setHint(@IdRes int id2, CharSequence sequence) {
        TextView textView = (TextView)this.getView(id2);
        if (textView != null) {
            textView.setHint(sequence);
        }
    }

    public void setHintColor(@IdRes int id2, @ColorInt int color) {
        TextView textView = (TextView)this.getView(id2);
        if (textView != null) {
            textView.setHintTextColor(color);
        }
    }

    public void setText(@IdRes int id2, @StringRes int sequence) {
        TextView textView = (TextView)this.getView(id2);
        if (textView != null) {
            textView.setText(sequence);
        }
    }

    public void setTextSize(@IdRes int id2, float px) {
        this.setTextSize(id2, px, 0);
    }

    public void setTextSize(@IdRes int id2, float size, int unit) {
        TextView textView = (TextView)this.getView(id2);
        if (textView != null) {
            textView.setTextSize(unit, size);
        }
    }

    public void setTextColor(@IdRes int id2, @ColorInt int color) {
        TextView textView = (TextView)this.getView(id2);
        if (textView != null) {
            textView.setTextColor(color);
        }
    }

    public void setTextColorRes(@IdRes int id2, @ColorRes int color) {
        TextView textView = (TextView)this.getView(id2);
        if (textView != null) {
            textView.setTextColor(ContextCompat.getColor((Context)this.mRootView.getContext(), (int)color));
        }
    }

    public void setTextColor(@IdRes int id2, String color) {
        TextView textView = (TextView)this.getView(id2);
        if (textView != null) {
            textView.setTextColor(Color.parseColor((String)color));
        }
    }

    public void setTextGravity(@IdRes int id2, @ColorInt int gravity) {
        TextView textView = (TextView)this.getView(id2);
        if (textView != null) {
            textView.setGravity(gravity);
        }
    }

    public void moveCursor2End(@IdRes int id2) {
        EditText editText = (EditText)this.getView(id2);
        if (editText != null) {
            editText.setSelection(editText.getText().length());
        }
    }

    public void setCompoundDrawableStart(@IdRes int id2, @DrawableRes int drawable) {
        TextView textView = (TextView)this.getView(id2);
        if (textView != null) {
            TextViewCompat.setCompoundDrawablesRelativeWithIntrinsicBounds((TextView)textView, (Drawable)this.getDrawable(drawable), null, null, null);
        }
    }

    public void setCompoundDrawableRight(@IdRes int id2, @DrawableRes int drawable) {
        TextView textView = (TextView)this.getView(id2);
        if (textView != null) {
            TextViewCompat.setCompoundDrawablesRelativeWithIntrinsicBounds((TextView)textView, null, null, (Drawable)this.getDrawable(drawable), null);
        }
    }

    public void setCompoundDrawableTop(@IdRes int id2, @DrawableRes int drawable) {
        TextView textView = (TextView)this.getView(id2);
        if (textView != null) {
            TextViewCompat.setCompoundDrawablesRelativeWithIntrinsicBounds((TextView)textView, null, (Drawable)this.getDrawable(drawable), null, null);
        }
    }

    public void setCompoundDrawableStart(@IdRes int id2, Drawable drawable) {
        TextView textView = (TextView)this.getView(id2);
        if (textView != null) {
            TextViewCompat.setCompoundDrawablesRelativeWithIntrinsicBounds((TextView)textView, (Drawable)drawable, null, null, null);
        }
    }

    public void setCompoundDrawableRight(@IdRes int id2, Drawable drawable) {
        TextView textView = (TextView)this.getView(id2);
        if (textView != null) {
            TextViewCompat.setCompoundDrawablesRelativeWithIntrinsicBounds((TextView)textView, null, null, (Drawable)drawable, null);
        }
    }

    public void setCompoundDrawableTop(@IdRes int id2, Drawable drawable) {
        TextView textView = (TextView)this.getView(id2);
        if (textView != null) {
            TextViewCompat.setCompoundDrawablesRelativeWithIntrinsicBounds((TextView)textView, null, (Drawable)drawable, null, null);
        }
    }

    public void setProgress(@IdRes int id2, int progress) {
        ProgressBar progressBar = (ProgressBar)this.getView(id2);
        if (Build.VERSION.SDK_INT >= 24) {
            progressBar.setProgress(progress, true);
        } else {
            progressBar.setProgress(progress);
        }
    }

    public String getText(@IdRes int id2) {
        TextView textView = (TextView)this.getView(id2);
        if (textView instanceof EditText) {
            return textView.getText().toString().trim();
        }
        return textView.getText().toString();
    }

    public float getTextSize(@IdRes int id2) {
        TextView textView = (TextView)this.getView(id2);
        return textView.getTextSize();
    }

    public void setChecked(@IdRes int id2, boolean checked) {
        Checkable checkable = (Checkable)this.getView(id2);
        if (checkable != null) {
            checkable.setChecked(checked);
        }
    }

    public void setCheckedListener(@IdRes int id2, CompoundButton.OnCheckedChangeListener listener) {
        CompoundButton compoundButton = (CompoundButton)this.getView(id2);
        if (compoundButton != null) {
            compoundButton.setOnCheckedChangeListener(listener);
        }
    }

    public boolean isChecked(@IdRes int id2) {
        Checkable checkable = (Checkable)this.getView(id2);
        return checkable.isChecked();
    }

    public void setSelected(@IdRes int id2, boolean selected) {
        Object view = this.getView(id2);
        if (view != null) {
            view.setSelected(selected);
        }
    }

    public boolean isSelected(@IdRes int id2) {
        Object view = this.getView(id2);
        return view.isSelected();
    }

    public void setImage(@IdRes int id2, @DrawableRes int drawable) {
        ImageView iv = (ImageView)this.getView(id2);
        if (iv != null) {
            iv.setImageDrawable(this.getDrawable(drawable));
        }
    }

    public void setImage(@IdRes int id2, Drawable drawable) {
        ImageView iv = (ImageView)this.getView(id2);
        if (iv != null) {
            iv.setImageDrawable(drawable);
        }
    }

    public void setBackground(@IdRes int id2, @DrawableRes int drawable) {
        Object iv = this.getView(id2);
        if (iv != null) {
            iv.setBackground(this.getDrawable(drawable));
        }
    }

    public void setBackground(@IdRes int id2, Drawable drawable) {
        Object iv = this.getView(id2);
        if (iv != null) {
            iv.setBackground(drawable);
        }
    }

    public void setBackgroundColor(@IdRes int id2, @ColorInt int color) {
        Object iv = this.getView(id2);
        if (iv != null) {
            iv.setBackgroundColor(color);
        }
    }

    public void setBackgroundColor(@IdRes int id2, @ColorInt int color, float alpha) {
        Object iv = this.getView(id2);
        if (iv != null) {
            int a = (int)(alpha * 255.0f);
            iv.setBackgroundColor(a << 24 | color & 0xFFFFFF);
        }
    }

    public void setForeground(@IdRes int id2, @DrawableRes int drawable) {
        FrameLayout iv = (FrameLayout)this.getView(id2);
        if (iv != null) {
            iv.setForeground(this.getDrawable(drawable));
        }
    }

    public void setEnable(@IdRes int id2, boolean enable) {
        Object iv = this.getView(id2);
        if (iv != null) {
            iv.setEnabled(enable);
        }
    }

    public void setActivated(@IdRes int id2, boolean enable) {
        Object iv = this.getView(id2);
        if (iv != null) {
            iv.setActivated(enable);
        }
    }

    public void setFocusable(@IdRes int id2, boolean enable) {
        Object iv = this.getView(id2);
        if (iv != null) {
            iv.setFocusable(enable);
        }
    }

    public void setVisibility(@IdRes int id2, int visibility) {
        Object view = this.getView(id2);
        if (view != null) {
            view.setVisibility(visibility);
        }
    }

    public void setVisibility(@IdRes int id2, boolean visible) {
        Object view = this.getView(id2);
        if (view != null) {
            view.setVisibility(visible ? 0 : 8);
        }
    }

    public boolean isVisible(@IdRes int id2) {
        Object view = this.getView(id2);
        return view.getVisibility() == 0;
    }

    public void setElevation(@IdRes int id2, float elevation) {
        Object view = this.getView(id2);
        if (view != null) {
            ViewCompat.setElevation(view, (float)elevation);
        }
    }

    public void setAlpha(int id2, @FloatRange(from=0.0, to=1.0) float alpha) {
        Object view = this.getView(id2);
        if (view != null) {
            view.setAlpha(alpha);
        }
    }

    public void setTranslationX(@IdRes int id2, float value) {
        Object view = this.getView(id2);
        if (view != null) {
            view.setTranslationX(value);
        }
    }

    public void setTranslationY(@IdRes int id2, float value) {
        Object view = this.getView(id2);
        if (view != null) {
            view.setTranslationY(value);
        }
    }

    public float getTranslationY(@IdRes int id2) {
        Object view = this.getView(id2);
        return view.getTranslationY();
    }

    public void setClickListener(@IdRes int id2, View.OnClickListener listener) {
        Object view = this.getView(id2);
        if (view != null) {
            view.setOnClickListener(listener);
        }
    }

    public void setTopPadding(@IdRes int id2, int padding) {
        Object view = this.getView(id2);
        if (view != null) {
            view.setPadding(view.getPaddingLeft(), padding, view.getPaddingRight(), view.getPaddingBottom());
        }
    }

    public void setHorizontalPadding(@IdRes int id2, int padding) {
        Object view = this.getView(id2);
        if (view != null) {
            view.setPadding(padding, view.getPaddingTop(), padding, view.getPaddingBottom());
        }
    }

    public void setTransitionName(@IdRes int id2, String name) {
        Object view = this.getView(id2);
        ViewCompat.setTransitionName(view, (String)name);
    }

    public void startAnimation(@IdRes int id2, Animation animation) {
        Object view = this.getView(id2);
        if (view != null) {
            view.startAnimation(animation);
        }
    }

    public void startAnimation(@IdRes int id2, @AnimRes int animation) {
        Animation anim = AnimationUtils.loadAnimation((Context)this.mRootView.getContext(), (int)animation);
        this.startAnimation(id2, anim);
    }

    public void clearAnimation(@IdRes int id2) {
        Object view = this.getView(id2);
        if (view != null) {
            view.clearAnimation();
        }
    }

    public void setMargin(@IdRes int id2, int margin, int position) {
        Object view = this.getView(id2);
        ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
        if (this.haveBits(position, 1)) {
            layoutParams.leftMargin = margin;
        }
        if (this.haveBits(position, 2)) {
            layoutParams.rightMargin = margin;
        }
        if (this.haveBits(position, 4)) {
            layoutParams.topMargin = margin;
        }
        if (this.haveBits(position, 8)) {
            layoutParams.bottomMargin = margin;
        }
        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    public int getMargin(@IdRes int id2, int position) {
        Object view = this.getView(id2);
        ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
        switch (position) {
            case 1: {
                return layoutParams.leftMargin;
            }
            case 2: {
                return layoutParams.rightMargin;
            }
            case 4: {
                return layoutParams.topMargin;
            }
            case 8: {
                return layoutParams.bottomMargin;
            }
        }
        return 0;
    }

    private boolean haveBits(int val, int cons) {
        return (val & cons) == cons;
    }

    public void addSharedElement(FragmentTransaction transaction, @IdRes int id2) {
        Object view = this.getView(id2);
        transaction.addSharedElement(view, ViewCompat.getTransitionName(view));
    }

    public boolean changePasswordVisibility(@IdRes int id2) {
        EditText editText = (EditText)this.getView(id2);
        int selection = editText.getSelectionStart();
        int inputType = editText.getInputType();
        int typeClass = inputType & 0xF;
        int typeFlag = inputType & 0xFFF000;
        int typeVar = inputType & 0xFF0;
        int newType = -1;
        boolean visible = true;
        if (typeClass == 1) {
            if ((typeVar & 0x80) == 128) {
                newType = typeClass | typeFlag;
            } else {
                newType = typeClass | typeFlag | 0x80;
                visible = false;
            }
        } else if (typeClass == 2) {
            if ((typeVar & 0x10) == 16) {
                newType = typeClass | typeFlag;
            } else {
                newType = typeClass | typeFlag | 0x10;
                visible = false;
            }
        }
        if (newType != -1) {
            editText.setInputType(newType);
        }
        editText.setSelection(selection);
        return visible;
    }

    public View getRootView() {
        return this.mRootView;
    }

    public void addView(@IdRes int id2, View child, ViewGroup.LayoutParams layoutParams) {
        ViewGroup viewGroup = (ViewGroup)this.getView(id2);
        if (layoutParams != null) {
            viewGroup.addView(child, layoutParams);
        } else {
            viewGroup.addView(child);
        }
    }

    public void addView(@IdRes int id2, View child) {
        this.addView(id2, child, null);
    }

    public <T extends View> T getView(int id2) {
        View textView = (View)this.mViewArray.get(id2);
        if (textView == null) {
            textView = this.mRootView.findViewById(id2);
            this.mViewArray.put(id2, (Object)textView);
        }
        return (T)textView;
    }

    public int getTop(@IdRes int id2) {
        Object view = this.getView(id2);
        return view.getTop();
    }

    public int getBottom(@IdRes int id2) {
        Object view = this.getView(id2);
        return view.getBottom();
    }

    public int getLeft(@IdRes int id2) {
        Object view = this.getView(id2);
        return view.getLeft();
    }

    public int getRight(@IdRes int id2) {
        Object view = this.getView(id2);
        return view.getRight();
    }

    public ViewGroup.LayoutParams getLayoutParams(@IdRes int id2) {
        Object view = this.getView(id2);
        return view.getLayoutParams();
    }

    public void setLayoutParams(@IdRes int id2, ViewGroup.LayoutParams layoutParams) {
        Object view = this.getView(id2);
        view.setLayoutParams(layoutParams);
    }

    private Context getContext() {
        return this.mRootView.getContext();
    }

    private Drawable getDrawable(int res) {
        return res == 0 ? null : AppCompatResources.getDrawable((Context)this.getContext(), (int)res);
    }

    public void detachFromParent() {
        ViewGroup group = (ViewGroup)this.mRootView.getParent();
        group.removeView(this.mRootView);
    }

    public void clear() {
        this.mViewArray.clear();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MarginPosition {
    }
}

