/*
 * Decompiled with CFR 0.152.
 */
package ellax.base.helper;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.Context;
import android.os.Looper;
import android.widget.Toast;
import androidx.annotation.StringRes;
import ellax.base.helper.AppExecutors;

public class ToastHelper {
    private static ToastHelper sToast;
    private Context mContext;
    private ToastRunnable mShortToast;
    private ToastRunnable mLongToast;
    private ToastCenterRunnable mShortCenterToast;

    private ToastHelper(Context context) {
        this.mContext = context instanceof Application ? context : context.getApplicationContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setup(Context context) {
        if (sToast != null) return;
        Class<ToastHelper> clazz = ToastHelper.class;
        synchronized (ToastHelper.class) {
            if (sToast != null) return;
            sToast = new ToastHelper(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @SuppressLint(value={"ShowToast"})
    public static void showToast(String str) {
        if (ToastHelper.sToast.mShortToast == null) {
            ToastHelper.sToast.mShortToast = new ToastRunnable(0);
        }
        ToastHelper.sToast.mShortToast.setText(str);
        ToastHelper.show(ToastHelper.sToast.mShortToast);
    }

    @SuppressLint(value={"ShowToast"})
    public static void showToast(@StringRes int res) {
        ToastHelper.showToast(ToastHelper.sToast.mContext.getString(res));
    }

    @SuppressLint(value={"ShowToast"})
    public static void showLongToast(String str) {
        if (ToastHelper.sToast.mLongToast == null) {
            ToastHelper.sToast.mLongToast = new ToastRunnable(1);
        }
        ToastHelper.sToast.mLongToast.setText(str);
        ToastHelper.show(ToastHelper.sToast.mLongToast);
    }

    @SuppressLint(value={"ShowToast"})
    public static void showLongToast(@StringRes int res) {
        ToastHelper.showLongToast(ToastHelper.sToast.mContext.getString(res));
    }

    public static void showCenterToast(String str) {
        if (ToastHelper.sToast.mShortCenterToast == null) {
            ToastHelper.sToast.mShortCenterToast = new ToastCenterRunnable(0);
        }
        ToastHelper.sToast.mShortCenterToast.setText(str);
        ToastHelper.showCenter(ToastHelper.sToast.mShortCenterToast);
    }

    private static void show(Runnable runnable) {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            runnable.run();
        } else {
            AppExecutors.mainThread(runnable);
        }
    }

    private static void showCenter(ToastCenterRunnable runnable) {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            runnable.run();
        } else {
            AppExecutors.mainThread(runnable);
        }
    }

    @SuppressLint(value={"ShowCenterToast"})
    private static class ToastCenterRunnable
    implements Runnable {
        private Toast mToast;
        private String text;
        private int duration;

        public ToastCenterRunnable(int duration) {
            this.duration = duration;
        }

        public void setText(String text) {
            this.text = text;
        }

        @Override
        public void run() {
            if (sToast == null) {
                throw new RuntimeException("ToastUtil has not been initialized");
            }
            if (this.mToast == null || this.mToast.getView() != null && this.mToast.getView().isShown()) {
                this.mToast = Toast.makeText((Context)sToast.mContext, null, (int)this.duration);
            }
            this.mToast.setGravity(17, 0, 0);
            this.mToast.setText((CharSequence)this.text);
            this.mToast.show();
        }
    }

    @SuppressLint(value={"ShowToast"})
    private static class ToastRunnable
    implements Runnable {
        private Toast mToast;
        private String text;
        private int duration;

        public ToastRunnable(int duration) {
            this.duration = duration;
        }

        public void setText(String text) {
            this.text = text;
        }

        @Override
        public void run() {
            if (sToast == null) {
                throw new RuntimeException("ToastUtil has not been initialized");
            }
            if (this.mToast == null || this.mToast.getView() != null && this.mToast.getView().isShown()) {
                this.mToast = Toast.makeText((Context)sToast.mContext, null, (int)this.duration);
            }
            this.mToast.setText((CharSequence)this.text);
            this.mToast.show();
        }
    }
}

