/*
 * Decompiled with CFR 0.152.
 */
package ellax.base.helper;

import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class AppExecutors {
    private static AppExecutors sAppExecutors;
    private static final int THREAD_COUNT = 3;
    private final Executor diskIO;
    private final Executor networkIO;
    private final Executor mainThread;

    @VisibleForTesting
    AppExecutors(Executor diskIO, Executor networkIO, Executor mainThread) {
        this.diskIO = diskIO;
        this.networkIO = networkIO;
        this.mainThread = mainThread;
    }

    private AppExecutors() {
        this(Executors.newSingleThreadExecutor(), Executors.newFixedThreadPool(3), new MainThreadExecutor());
    }

    public static void diskIO(Runnable runnable) {
        AppExecutors.get().diskIO.execute(runnable);
    }

    public static void networkIO(Runnable runnable) {
        AppExecutors.get().networkIO.execute(runnable);
    }

    public static void mainThread(Runnable runnable) {
        AppExecutors.get().mainThread.execute(runnable);
    }

    private static AppExecutors get() {
        if (sAppExecutors == null) {
            sAppExecutors = new AppExecutors();
        }
        return sAppExecutors;
    }

    private static class MainThreadExecutor
    implements Executor {
        private Handler mainThreadHandler = new Handler(Looper.getMainLooper());

        private MainThreadExecutor() {
        }

        @Override
        public void execute(@NonNull Runnable command) {
            this.mainThreadHandler.post(command);
        }
    }
}

